/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.jaxp.DocHandlerResult;
import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xsl.xpath.DTMDOMBuilder;
import com.sap.engine.lib.xsl.xpath.XPathMatcher;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.output.CanonicalDocHandlerSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XSLTTransformation
extends Transformation {
    public XSLTTransformation(Object[] args) {
        super(args);
    }

    public XSLTTransformation() {
        this(null);
    }

    @Override
    public void transform(Data data) throws SignatureException {
        if (this.additionalArgs.length != 1 || !(this.additionalArgs[0] instanceof String) && !(this.additionalArgs[0] instanceof InputStream)) {
            throw new SignatureException("XSLTTransformation expects a one-elemnent array, containing a xslt stylesheet either as a stirng or as an input stream", new Object[]{data, this.additionalArgs});
        }
        InputStream xslInput = null;
        xslInput = this.additionalArgs[0] instanceof String ? new ByteArrayInputStream(((String)this.additionalArgs[0]).getBytes()) : (InputStream)this.additionalArgs[0];
        ByteArrayInputStream is = new ByteArrayInputStream(data.getOctets());
        data.setOctets(XSLTTransformation.transformXSLT(is, xslInput));
    }

    public static byte[] transformXSLT(InputStream xmlInput, InputStream xslInput) throws SignatureException {
        try {
            ByteArrayOutputStream baos = SignatureContext.getByteArrayOutputStreamPool().getInstance();
            TransformerFactoryImpl factory = new TransformerFactoryImpl();
            StreamSource xmlSource = null;
            StreamSource xslSource = null;
            xmlSource = new StreamSource(xmlInput);
            xslSource = new StreamSource(xslInput);
            StreamResult result = new StreamResult(baos);
            ((TransformerFactory)factory).newTransformer(xslSource).transform(xmlSource, result);
            byte[] res = baos.toByteArray();
            return res;
        }
        catch (Exception e) {
            throw new SignatureException("Error in XSLTTransforation transform", new Object[]{xmlInput, xslInput}, e);
        }
    }

    public static byte[] filter(Node n, String query) throws SignatureException {
        byte[] byArray;
        CanonicalDocHandlerSerializer cdhs = null;
        try {
            Transformer tr = new TransformerFactoryImpl().newTransformer();
            ByteArrayOutputStream baos = SignatureContext.getByteArrayOutputStreamPool().getInstance();
            Properties prop = SignatureContext.getProperties();
            cdhs = Canonicalization.get(baos, prop);
            DOMSource source = new DOMSource(n);
            DocHandlerResult result = new DocHandlerResult(cdhs);
            tr.transform(source, result);
            byArray = baos.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new SignatureException("Error filtering XSLTTransformation", new Object[]{n, query}, e);
            }
            catch (Throwable throwable) {
                Canonicalization.release(cdhs);
                throw throwable;
            }
        }
        Canonicalization.release(cdhs);
        return byArray;
    }

    public static byte[] filter(byte[] input, String query) throws SignatureException {
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        return XSLTTransformation.filter(bais, query);
    }

    public static Node filter(String fileName, String query) throws SignatureException {
        try {
            XPathMatcher matcher = new XPathMatcher(fileName);
            XObject result = matcher.process(query);
            result.print(0);
            if (result instanceof XNodeSet) {
                DTMDOMBuilder builder = new DTMDOMBuilder(((XNodeSet)result).dtm);
                return builder.domtree[0];
            }
            throw new SignatureException("Unexpected return type from XPathQuerry", new Object[]{fileName, query});
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureException("Error filtering XSLTTransformation", new Object[]{fileName, query}, e);
        }
    }

    public static byte[] filter(InputStream input, String query) throws SignatureException {
        try {
            XPathMatcher matcher = new XPathMatcher(input);
            XObject result = matcher.process(query);
            if (result instanceof XNodeSet) {
                DTMDOMBuilder builder = new DTMDOMBuilder(((XNodeSet)result).dtm);
                Document doc = (Document)builder.domtree[0];
                return Canonicalization.canonicalize(doc, true);
            }
            throw new SignatureException("Unexpected return type from XPathQuerry", new Object[]{input, query});
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureException("Error filtering input stream", new Object[]{input, query}, e);
        }
    }

    @Override
    public Transformation defineFrom(GenericElement el, HashMap $dataHashmap) throws SignatureException {
        throw new SignatureException("defineFrom not implemented for standard transformation: XSLTTransformation!", new Object[]{el, $dataHashmap});
    }
}

