/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.stream;

import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReaderFactory;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReaderImpl;
import com.sap.engine.lib.xml.stream.XMLStreamExceptionExt;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.AttributesImpl;

public class XMLStreamReaderImpl
implements XMLStreamReader {
    public static final String NOTATIONS = "javax.xml.stream.notations";
    public static final String ENTITIES = "javax.xml.stream.entities";
    private static final int[][] tokenToStreamMatrix = new int[8][1];
    private static Hashtable<Integer, Integer> streamToTokenMap;
    private XMLTokenReader tr = null;
    private QName currentEl = null;
    private String charData = null;
    private int state;
    private InputSource inSource;
    private AttributesImpl attrs = new AttributesImpl();
    private int textStart = 0;
    private Map namespaceMap;
    private List prefixesOnLastStartElement;
    private List<String[]> endedPrefixesOnLastEndElement;

    static {
        XMLStreamReaderImpl.tokenToStreamMatrix[0][0] = 7;
        XMLStreamReaderImpl.tokenToStreamMatrix[6][0] = 8;
        XMLStreamReaderImpl.tokenToStreamMatrix[1][0] = 1;
        XMLStreamReaderImpl.tokenToStreamMatrix[2][0] = 2;
        XMLStreamReaderImpl.tokenToStreamMatrix[3][0] = 4;
        XMLStreamReaderImpl.tokenToStreamMatrix[5][0] = 5;
        XMLStreamReaderImpl.tokenToStreamMatrix[4][0] = 3;
        XMLStreamReaderImpl.tokenToStreamMatrix[7][0] = 11;
        streamToTokenMap = new Hashtable(15);
        streamToTokenMap.put(10, 1);
        streamToTokenMap.put(12, 3);
        streamToTokenMap.put(4, 3);
        streamToTokenMap.put(5, 5);
        streamToTokenMap.put(11, 7);
        streamToTokenMap.put(8, 6);
        streamToTokenMap.put(2, 2);
        streamToTokenMap.put(15, 3);
        streamToTokenMap.put(9, 3);
        streamToTokenMap.put(13, 1);
        streamToTokenMap.put(14, 3);
        streamToTokenMap.put(3, 4);
        streamToTokenMap.put(6, 3);
        streamToTokenMap.put(7, 0);
        streamToTokenMap.put(1, 1);
    }

    public XMLStreamReaderImpl(XMLTokenReader tReader) {
        this.tr = tReader;
        this.state = tReader.getState();
        if (this.state == 1) {
            this.copyAttribsToInternalVariable(this.tr.getAttributes());
        }
        if (this.state == 1 || this.state == 2) {
            this.currentEl = new QName(this.tr.getURI(), this.tr.getLocalName());
        }
        if (this.state == 3 || this.state == 5) {
            this.charData = this.tr.getValue();
        }
    }

    protected XMLStreamReaderImpl(InputStream inStr) {
        XMLTokenReaderFactory factory = XMLTokenReaderFactory.getInstance();
        XMLTokenReaderImpl tr = (XMLTokenReaderImpl)factory.createReader(inStr);
        tr.setOmmitComments(false);
        try {
            this.state = tr.begin();
            tr.getParser().bSoapProcessing = false;
        }
        catch (ParserException e) {
            throw new IllegalStateException(e);
        }
        this.tr = tr;
    }

    protected XMLStreamReaderImpl(Reader rdr) {
        XMLTokenReaderFactory factory = XMLTokenReaderFactory.getInstance();
        XMLTokenReaderImpl tr = (XMLTokenReaderImpl)factory.createReader(rdr);
        tr.setOmmitComments(false);
        try {
            this.state = tr.begin();
            tr.getParser().bSoapProcessing = false;
        }
        catch (ParserException e) {
            throw new IllegalStateException(e);
        }
        this.tr = tr;
    }

    protected XMLStreamReaderImpl(Source source) {
        XMLTokenReaderImpl tr;
        this.inSource = new InputSource(source.getSystemId());
        if (source instanceof StreamSource) {
            this.inSource.setByteStream(((StreamSource)source).getInputStream());
            XMLTokenReaderFactory factory = XMLTokenReaderFactory.getInstance();
            tr = (XMLTokenReaderImpl)factory.createReader(this.inSource);
            tr.setOmmitComments(false);
            tr.init(this.inSource.getByteStream());
            try {
                this.state = tr.begin();
                tr.getParser().bSoapProcessing = false;
            }
            catch (ParserException e) {
                throw new IllegalStateException(e);
            }
        } else {
            throw new IllegalArgumentException("Only XMLStreamReader from StreamSource is supported.");
        }
        this.tr = tr;
    }

    @Override
    public Object getProperty(String prop) throws IllegalArgumentException {
        if (prop == null) {
            throw new IllegalArgumentException("Property name cannot be null!");
        }
        Object propValue = null;
        if (this.state == 7) {
            if (prop.equals(NOTATIONS)) {
                propValue = null;
            } else if (prop.equals(ENTITIES)) {
                propValue = null;
            }
        }
        return propValue;
    }

    @Override
    public int next() throws XMLStreamException {
        try {
            this.state = this.tr.next();
        }
        catch (ParserException e) {
            throw new XMLStreamExceptionExt(e);
        }
        if (this.state == 6) {
            return tokenToStreamMatrix[this.state][0];
        }
        this.endedPrefixesOnLastEndElement = null;
        if (this.state == 1) {
            this.copyAttribsToInternalVariable(this.tr.getAttributes());
        }
        if (this.state == 1 || this.state == 2) {
            this.currentEl = new QName(this.tr.getURI(), this.tr.getLocalName());
            this.namespaceMap = null;
            this.prefixesOnLastStartElement = null;
        }
        if (this.state == 3 || this.state == 5) {
            this.charData = this.tr.getValue();
        }
        return tokenToStreamMatrix[this.state][0];
    }

    @Override
    public void require(int type, String localName, String namespaceURI) throws XMLStreamException {
        if (type != streamToTokenMap.get(type)) {
            throw new XMLStreamExceptionExt("The required value 'type' is not matched!");
        }
        if (this.state == 1 || this.state == 2) {
            if (localName != null && !localName.equals(this.tr.getLocalName())) {
                throw new XMLStreamExceptionExt("The required value 'localName' is not matched!");
            }
            if (namespaceURI != null && !namespaceURI.equals(this.tr.getURI())) {
                throw new XMLStreamExceptionExt("The required value 'Namespace URI' is not matched!");
            }
        } else if (localName != null || namespaceURI != null) {
            throw new XMLStreamExceptionExt("Cannot test for localName or NS URI equality if not in STARTELEMENT  or ENDELEMENT states!");
        }
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.state != 1) {
            throw new XMLStreamExceptionExt("Parser is not at the beginning of an element!");
        }
        String elText = null;
        String elName = this.tr.getLocalName();
        StringBuffer res = new StringBuffer();
        while (this.state != 2) {
            try {
                this.state = this.tr.next();
            }
            catch (ParserException e) {
                throw new XMLStreamExceptionExt(e);
            }
            if (this.state == 6 || this.state == 1) {
                throw new XMLStreamExceptionExt("Unexpected state reached while reading XML stream, did not find closing tag for element " + elName);
            }
            if (this.state != 3) continue;
            elText = this.tr.getValue();
            res.append(elText);
        }
        return res.toString();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int state = this.next();
        while (state != 1 && state != 2) {
            if (state == 8) {
                throw new XMLStreamExceptionExt("expected start or end tag");
            }
            state = this.next();
        }
        return tokenToStreamMatrix[state][0];
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.state != 6;
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.tr.end();
        }
        catch (ParserException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Cannot return Namespace URI for null prefix!");
        }
        return this.tr.getPrefixMapping(prefix);
    }

    @Override
    public boolean isStartElement() {
        return this.state == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.state == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.state == 3;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.state == 3 && this.tr.isWhitespace();
    }

    @Override
    public String getAttributeValue(String namespaceUri, String localName) {
        if (this.state != 1) {
            throw new IllegalStateException("Parser is not in START_ELEMENT state!");
        }
        namespaceUri = namespaceUri != null ? namespaceUri : "";
        return this.attrs.getValue(namespaceUri, localName);
    }

    @Override
    public int getAttributeCount() {
        if (this.state != 1) {
            throw new IllegalStateException("Parser not in START_ELEMENT state!");
        }
        if (this.attrs == null) {
            return 0;
        }
        return this.attrs.getLength();
    }

    @Override
    public QName getAttributeName(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Parser not in START_ELEMENT state!");
        }
        String fake = this.attrs.getQName(index);
        String realUri = fake.indexOf(":") != -1 ? this.getNamespaceURI(fake.substring(0, fake.indexOf(58))) : "";
        String realName = fake.indexOf(":") != -1 ? fake.substring(fake.indexOf(58) + 1) : fake;
        return new QName(realUri, realName);
    }

    @Override
    public String getAttributeNamespace(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Parser not in START_ELEMENT state!");
        }
        return this.attrs.getURI(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Parser not in START_ELEMENT state!");
        }
        return this.attrs.getLocalName(index);
    }

    private String getPrefixForNS(String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            return null;
        }
        String prefix = null;
        Map mappings = this.getNamespaceMappings();
        for (String tryThis : mappings.keySet()) {
            String mapped = (String)mappings.get(tryThis);
            if (mapped == null || !mapped.equals(nsURI)) continue;
            prefix = tryThis;
            break;
        }
        return prefix;
    }

    @Override
    public String getAttributePrefix(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Parser not in START_ELEMENT state!");
        }
        return this.getPrefixForNS(this.attrs.getURI(index));
    }

    @Override
    public String getAttributeType(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Parser not in START_ELEMENT state!");
        }
        return this.attrs.getType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Parser not in START_ELEMENT state!");
        }
        return this.attrs.getValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return false;
    }

    @Override
    public int getNamespaceCount() {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("Valid states for this method are STARTELEMENT and ENDELEMENT");
        }
        if (this.state == 1) {
            return this.getPrexiesOnLastStartElement().size();
        }
        return this.getEndedPrefixMappings().size();
    }

    @Override
    public String getNamespacePrefix(int index) {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("Cannot get prefix if not in STARTELEMENT or ENDELEMENT");
        }
        if (this.state == 1) {
            List tmpRef = this.getPrexiesOnLastStartElement();
            if (index >= tmpRef.size()) {
                throw new ArrayIndexOutOfBoundsException("No prefix defined at position " + index);
            }
            return (String)tmpRef.get(index);
        }
        List<String[]> tmp = this.getEndedPrefixMappings();
        if (index >= tmp.size()) {
            throw new ArrayIndexOutOfBoundsException("No prefix defined at position " + index);
        }
        return tmp.get(index)[0];
    }

    @Override
    public String getNamespaceURI(int index) {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("Cannot get namespace if not in STARTELEMENT or ENDELEMENT");
        }
        if (this.state == 1) {
            List tmpRef = this.getPrexiesOnLastStartElement();
            if (index >= tmpRef.size()) {
                throw new ArrayIndexOutOfBoundsException("No URI defined at position " + index);
            }
            Map maps = this.getNamespaceMappings();
            return (String)maps.get(tmpRef.get(index));
        }
        List<String[]> tmp = this.getEndedPrefixMappings();
        if (index >= tmp.size()) {
            throw new ArrayIndexOutOfBoundsException("No URI defined at position " + index);
        }
        return tmp.get(index)[1];
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        final Map namespaces = this.getNamespaceMappings();
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)namespaces.get(prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return XMLStreamReaderImpl.this.getPrefixForNS(namespaceURI);
            }

            public Iterator getPrefixes(String namespaceURI) {
                ArrayList<String> res = new ArrayList<String>();
                for (String tmpP : namespaces.keySet()) {
                    String value = (String)namespaces.get(tmpP);
                    if (!value.equals(namespaceURI)) continue;
                    res.add(tmpP);
                }
                return res.iterator();
            }
        };
    }

    @Override
    public int getEventType() {
        return tokenToStreamMatrix[this.tr.getState()][0];
    }

    @Override
    public String getText() {
        if (this.state != 3 && this.state != 5) {
            throw new IllegalStateException("Parser state is not CHARACTERS");
        }
        return this.charData;
    }

    @Override
    public char[] getTextCharacters() {
        if (this.state != 3) {
            throw new IllegalStateException("Parser state is not CHARACTERS");
        }
        return this.tr.getValue().toCharArray();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (targetStart < 0 || targetStart > length) {
            throw new IndexOutOfBoundsException("Start index is greater than length");
        }
        return -1;
    }

    @Override
    public int getTextStart() {
        this.textStart = 0;
        return this.textStart;
    }

    @Override
    public int getTextLength() {
        if (this.state != 3) {
            throw new IllegalStateException("Parser state is not CHARACTERS");
        }
        return this.charData.length() - this.textStart;
    }

    @Override
    public String getEncoding() {
        if (this.tr instanceof XMLTokenReaderImpl) {
            return ((XMLTokenReaderImpl)this.tr).getEncoding();
        }
        return null;
    }

    @Override
    public boolean hasText() {
        return this.state == 3 || this.state == 5;
    }

    @Override
    public Location getLocation() {
        String sysId;
        String publicId;
        int tmpLineN = -1;
        int tmpColN = -1;
        try {
            if (this.tr instanceof XMLTokenReaderImpl) {
                XMLTokenReaderImpl trImpl = (XMLTokenReaderImpl)this.tr;
                tmpLineN = trImpl.getParser().getLineNumber();
                tmpColN = trImpl.getParser().getColumnNumber();
            }
        }
        catch (ParserException parserException) {
            return null;
        }
        if (this.inSource != null) {
            publicId = this.inSource.getPublicId();
            sysId = this.inSource.getSystemId();
        } else {
            publicId = null;
            sysId = null;
        }
        final int LineNo = tmpLineN;
        final int ColNo = tmpColN;
        return new Location(){

            @Override
            public int getLineNumber() {
                return LineNo;
            }

            @Override
            public int getColumnNumber() {
                return ColNo;
            }

            @Override
            public int getCharacterOffset() {
                return -1;
            }

            @Override
            public String getPublicId() {
                return publicId;
            }

            @Override
            public String getSystemId() {
                return sysId;
            }
        };
    }

    @Override
    public QName getName() {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("Parser is not at the beginning or end of the element!");
        }
        return this.currentEl;
    }

    @Override
    public String getLocalName() {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("Parser is not at the beginning or end of the element!");
        }
        return this.tr.getLocalName();
    }

    @Override
    public boolean hasName() {
        return this.state == 1 || this.state == 2;
    }

    @Override
    public String getNamespaceURI() {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("Parser is not at the beginning or end of the element!");
        }
        return this.tr.getURI();
    }

    @Override
    public String getPrefix() {
        String prefix = null;
        if (this.state == 1 || this.state == 2) {
            prefix = this.getPrefixForNS(this.tr.getURI());
        }
        return prefix;
    }

    @Override
    public String getVersion() {
        if (this.tr instanceof XMLTokenReaderImpl) {
            return ((XMLTokenReaderImpl)this.tr).getXmlVer();
        }
        return null;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return this.isStandalone();
    }

    @Override
    public String getCharacterEncodingScheme() {
        if (this.tr instanceof XMLTokenReaderImpl) {
            return ((XMLTokenReaderImpl)this.tr).getEncoding();
        }
        return null;
    }

    @Override
    public String getPITarget() {
        if (this.tr instanceof XMLTokenReaderImpl) {
            return ((XMLTokenReaderImpl)this.tr).getPiTarget();
        }
        return null;
    }

    @Override
    public String getPIData() {
        if (this.tr instanceof XMLTokenReaderImpl) {
            return ((XMLTokenReaderImpl)this.tr).getPiData();
        }
        return null;
    }

    private Map getNamespaceMappings() {
        Map<String, String> res;
        if (this.namespaceMap != null) {
            return this.namespaceMap;
        }
        try {
            res = this.tr.getNamespaceMappings();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.namespaceMap = res;
        return res;
    }

    private List getPrexiesOnLastStartElement() {
        List<String> res;
        if (this.prefixesOnLastStartElement != null) {
            return this.prefixesOnLastStartElement;
        }
        try {
            res = this.tr.getPrefixesOnLastStartElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.prefixesOnLastStartElement = res;
        return res;
    }

    private List<String[]> getEndedPrefixMappings() {
        List<String[]> res;
        if (this.endedPrefixesOnLastEndElement != null) {
            return this.endedPrefixesOnLastEndElement;
        }
        try {
            res = this.tr.getEndedPrefixMappings();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.endedPrefixesOnLastEndElement = res;
        return res;
    }

    private void copyAttribsToInternalVariable(Attributes orig) {
        this.attrs.clear();
        if (orig != null) {
            int i = 0;
            while (i < orig.getLength()) {
                if (!"http://www.w3.org/2000/xmlns/".equals(orig.getURI(i))) {
                    this.attrs.addAttribute(orig.getURI(i), orig.getLocalName(i), orig.getQName(i), orig.getType(i), orig.getValue(i));
                }
                ++i;
            }
        }
    }
}

