/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.stream;

import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriterFactory;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriterImpl;
import com.sap.engine.lib.xml.stream.XMLStreamExceptionExt;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLStreamWriterImpl
implements XMLStreamWriter {
    private XMLTokenWriter tw;
    boolean isEmptyStarted = false;

    public XMLStreamWriterImpl(OutputStream outStr) {
        try {
            XMLTokenWriterFactory factory = XMLTokenWriterFactory.getInstance();
            this.tw = factory.createWriter();
            ((XMLTokenWriterImpl)this.tw).DELIMETER_CHAR = (char)34;
            this.tw.init(outStr);
        }
        catch (IOException ioE) {
            throw new RuntimeException(ioE);
        }
    }

    public XMLStreamWriterImpl(OutputStream outStr, String encoding) {
        try {
            XMLTokenWriterFactory factory = XMLTokenWriterFactory.getInstance();
            this.tw = factory.createWriter();
            ((XMLTokenWriterImpl)this.tw).DELIMETER_CHAR = (char)34;
            this.tw.init(outStr, encoding);
        }
        catch (IOException ioE) {
            throw new RuntimeException(ioE);
        }
    }

    public XMLStreamWriterImpl(XMLTokenWriter tWrt) {
        this.tw = tWrt;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.closeEmptyElement();
        try {
            this.tw.enter(null, localName);
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.closeEmptyElement();
        try {
            this.tw.enter(namespaceURI, localName);
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.closeEmptyElement();
        try {
            this.tw.enter(namespaceURI, localName);
            if (namespaceURI != null && namespaceURI.length() > 0 && prefix != null && !prefix.equals(this.tw.getPrefixForNamespace(namespaceURI))) {
                this.tw.setPrefixForNamespace(prefix, namespaceURI);
            }
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(namespaceURI, localName);
        this.isEmptyStarted = true;
    }

    @Override
    public void writeEmptyElement(String prefix, String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(prefix, namespaceURI, localName);
        this.isEmptyStarted = true;
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeStartElement(localName);
        this.isEmptyStarted = true;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.closeEmptyElement();
        try {
            this.tw.leave();
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.closeEmptyElement();
        try {
            this.tw.close();
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.tw.close();
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.tw.flush();
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        try {
            this.tw.writeAttribute(null, localName, value);
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        try {
            this.tw.setPrefixForNamespace(prefix, namespaceURI);
            this.tw.writeAttribute(namespaceURI, localName, value);
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        try {
            this.tw.writeAttribute(namespaceURI, localName, value);
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeNamespace(String arg0, String arg1) throws XMLStreamException {
        if (arg0 == null || "xmlns".equals(arg0) || "".equals(arg0)) {
            this.writeDefaultNamespace(arg1);
        }
        try {
            this.tw.setPrefixForNamespace(arg0, arg1);
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeDefaultNamespace(String arg0) throws XMLStreamException {
        try {
            this.tw.setPrefixForNamespace("", arg0);
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeComment(String comment) throws XMLStreamException {
        this.closeEmptyElement();
        try {
            this.tw.writeComment(comment);
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeProcessingInstruction(String arg0) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String arg0, String arg1) throws XMLStreamException {
    }

    @Override
    public void writeCData(String arg0) throws XMLStreamException {
        this.closeEmptyElement();
        try {
            this.tw.writeContentCData(arg0.toCharArray());
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeDTD(String arg0) throws XMLStreamException {
    }

    @Override
    public void writeEntityRef(String arg0) throws XMLStreamException {
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        try {
            this.tw.writeInitial();
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        if (version != null && !version.equals("1.0")) {
            throw new XMLStreamExceptionExt("Only XML version 1.0 is currently supported");
        }
        try {
            this.tw.writeInitial();
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (version != null && !version.equals("1.0")) {
            throw new XMLStreamExceptionExt("Only XML version 1.0 is currently supported");
        }
        try {
            this.tw.writeInitial();
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.closeEmptyElement();
        try {
            this.tw.writeContent(text);
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void writeCharacters(char[] src, int start, int len) throws XMLStreamException {
        this.closeEmptyElement();
        this.writeCharacters(new String(src, start, len));
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        String px = null;
        try {
            px = this.tw.getPrefixForNamespace(uri);
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
        return px;
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        try {
            this.tw.setPrefixForNamespace(prefix, uri);
        }
        catch (IOException e) {
            throw new XMLStreamExceptionExt(e);
        }
    }

    @Override
    public void setDefaultNamespace(String arg0) throws XMLStreamException {
        this.writeDefaultNamespace(arg0);
    }

    @Override
    public void setNamespaceContext(NamespaceContext arg0) throws XMLStreamException {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return null;
    }

    @Override
    public Object getProperty(String arg0) throws IllegalArgumentException {
        return null;
    }

    private void closeEmptyElement() throws XMLStreamException {
        if (this.isEmptyStarted) {
            try {
                this.tw.leave();
            }
            catch (IOException e) {
                throw new XMLStreamExceptionExt(e);
            }
            this.isEmptyStarted = false;
        }
    }
}

