/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BASE64Encoder
extends FilterOutputStream {
    protected static boolean skipNewLines = Boolean.parseBoolean(System.getProperty("com.sap.xml.security.skipCL", "true"));
    static byte[] b1 = new byte[256];
    static byte[][] b2 = new byte[256][256];
    static byte[][] b3 = new byte[256][256];
    static byte[] b4 = new byte[256];
    private int bufsize;
    private int count;
    private int bytesPerLine;
    private int byte0;
    private int byte1;
    private int byte2;

    static {
        char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        int i = 0;
        while (i < 256) {
            BASE64Encoder.b1[i] = (byte)pem_array[i >>> 2 & 0x3F];
            BASE64Encoder.b4[i] = (byte)pem_array[i & 0x3F];
            int j = 0;
            while (j < 256) {
                BASE64Encoder.b2[i][j] = (byte)pem_array[(i << 4 & 0x30) + (j >>> 4 & 0xF)];
                BASE64Encoder.b3[i][j] = (byte)pem_array[(i << 2 & 0x3C) + (j >>> 6 & 3)];
                ++j;
            }
            ++i;
        }
    }

    public BASE64Encoder(OutputStream outputstream, int i) {
        super(outputstream);
        this.bytesPerLine = i / 4;
    }

    public BASE64Encoder(OutputStream outputstream) {
        this(outputstream, 80);
    }

    @Override
    public void write(byte[] input, int start, int length) throws IOException {
        length += start;
        switch (this.bufsize) {
            case 1: {
                if (start < length) {
                    this.byte1 = input[start++] & 0xFF;
                } else {
                    this.bufsize = 1;
                    return;
                }
            }
            case 2: {
                if (start < length) {
                    this.byte2 = input[start++] & 0xFF;
                } else {
                    this.bufsize = 2;
                    return;
                }
            }
            case 3: {
                this.bufsize = 0;
                if (!skipNewLines && this.count == this.bytesPerLine) {
                    this.out.write(13);
                    this.out.write(10);
                    this.count = 0;
                }
                this.out.write(b1[this.byte0]);
                this.out.write(b2[this.byte0][this.byte1]);
                this.out.write(b3[this.byte1][this.byte2]);
                this.out.write(b4[this.byte2]);
                ++this.count;
            }
        }
        int end = length - (length - start) % 3;
        while (start < end) {
            if (!skipNewLines && this.count == this.bytesPerLine) {
                this.out.write(13);
                this.out.write(10);
                this.count = 0;
            }
            this.byte0 = input[start++] & 0xFF;
            this.byte1 = input[start++] & 0xFF;
            this.byte2 = input[start++] & 0xFF;
            this.out.write(b1[this.byte0]);
            this.out.write(b2[this.byte0][this.byte1]);
            this.out.write(b3[this.byte1][this.byte2]);
            this.out.write(b4[this.byte2]);
            ++this.count;
        }
        switch (length - start) {
            case 2: {
                this.byte0 = input[start++] & 0xFF;
                this.byte1 = input[start++] & 0xFF;
                this.bufsize = 2;
                break;
            }
            case 1: {
                this.byte0 = input[start++] & 0xFF;
                this.bufsize = 1;
            }
        }
    }

    @Override
    public void write(byte[] input) throws IOException {
        this.write(input, 0, input.length);
    }

    @Override
    public void write(int i) throws IOException {
        switch (this.bufsize) {
            case 1: {
                this.byte1 = i;
                this.bufsize = 2;
                break;
            }
            case 2: {
                this.byte2 = i;
                this.bufsize = 3;
                break;
            }
            case 3: {
                if (!skipNewLines && this.count == this.bytesPerLine) {
                    this.out.write(13);
                    this.out.write(10);
                    this.count = 0;
                }
                this.out.write(b1[this.byte0]);
                this.out.write(b2[this.byte0][this.byte1]);
                this.out.write(b3[this.byte1][this.byte2]);
                this.out.write(b4[this.byte2]);
                ++this.count;
                break;
            }
            case 0: {
                this.byte0 = i;
                this.bufsize = 1;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.count == this.bytesPerLine) {
            this.out.write(13);
            this.out.write(10);
        }
        switch (this.bufsize) {
            case 1: {
                this.out.write(b1[this.byte0]);
                this.out.write(b2[this.byte0][0]);
                this.out.write(61);
                this.out.write(61);
                break;
            }
            case 2: {
                this.out.write(b1[this.byte0]);
                this.out.write(b2[this.byte0][this.byte1]);
                this.out.write(b3[this.byte1][0]);
                this.out.write(61);
                break;
            }
            case 3: {
                this.out.write(b1[this.byte0]);
                this.out.write(b2[this.byte0][this.byte1]);
                this.out.write(b3[this.byte1][this.byte2]);
                this.out.write(b4[this.byte2]);
            }
        }
        this.out.close();
    }

    public static byte[] encodeN(byte[] input) {
        int byte1;
        int byte0;
        if (input.length == 0) {
            return input;
        }
        byte[] output = new byte[(input.length + 2) / 3 * 4];
        int i = 0;
        int j = 0;
        int k = input.length;
        while (k > 2) {
            byte0 = input[i++] & 0xFF;
            byte1 = input[i++] & 0xFF;
            int byte2 = input[i++] & 0xFF;
            output[j++] = b1[byte0];
            output[j++] = b2[byte0][byte1];
            output[j++] = b3[byte1][byte2];
            output[j++] = b4[byte2];
            k -= 3;
        }
        if (k == 1) {
            byte0 = input[i++] & 0xFF;
            output[j++] = b1[byte0];
            output[j++] = b2[byte0][0];
            output[j++] = 61;
            output[j++] = 61;
        } else if (k == 2) {
            byte0 = input[i++] & 0xFF;
            byte1 = input[i++] & 0xFF;
            output[j++] = b1[byte0];
            output[j++] = b2[byte0][byte1];
            output[j++] = b3[byte1][0];
            output[j++] = 61;
        }
        return output;
    }

    public static byte[] encode(byte[] input, int line_length) {
        int byte1;
        int byte0;
        if (input.length == 0) {
            return input;
        }
        int i = (input.length + 2) / 3 * 4;
        byte[] output = new byte[i + (line_length == 0 ? 0 : i / line_length * 2)];
        i = 0;
        int j = 0;
        line_length /= 4;
        int index = 0;
        int k = input.length;
        while (k > 2) {
            byte0 = input[i++] & 0xFF;
            byte1 = input[i++] & 0xFF;
            int byte2 = input[i++] & 0xFF;
            output[j++] = b1[byte0];
            output[j++] = b2[byte0][byte1];
            output[j++] = b3[byte1][byte2];
            output[j++] = b4[byte2];
            if (++index == line_length) {
                output[j++] = 13;
                output[j++] = 10;
                index = 0;
            }
            k -= 3;
        }
        if (k == 1) {
            byte0 = input[i++] & 0xFF;
            output[j++] = b1[byte0];
            output[j++] = b2[byte0][0];
            output[j++] = 61;
            output[j++] = 61;
            if (++index == line_length) {
                output[j++] = 13;
                output[j++] = 10;
                index = 0;
            }
        } else if (k == 2) {
            byte0 = input[i++] & 0xFF;
            byte1 = input[i++] & 0xFF;
            output[j++] = b1[byte0];
            output[j++] = b2[byte0][byte1];
            output[j++] = b3[byte1][0];
            output[j++] = 61;
            if (++index == line_length) {
                output[j++] = 13;
                output[j++] = 10;
                index = 0;
            }
        }
        return output;
    }

    public static byte[] encode(byte[] input) {
        return skipNewLines ? BASE64Encoder.encodeN(input) : BASE64Encoder.encode(input, 80);
    }

    public static boolean isSkipNewLines() {
        return skipNewLines;
    }

    public static void setSkipNewLines(boolean skipNewLines) {
        BASE64Encoder.skipNewLines = skipNewLines;
    }
}

