/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.io.IOException;
import java.io.InputStream;

public class CharArrayInputStream
extends InputStream {
    private CharArray data = new CharArray();
    private int idx = 0;
    private int marked = 0;

    public CharArrayInputStream(CharArray input) {
        this.reuse(input);
    }

    public CharArrayInputStream reuse(CharArray input) {
        this.data.set(input);
        this.idx = 0;
        return this;
    }

    @Override
    public int read() throws IOException {
        if (this.idx >= this.data.length()) {
            return -1;
        }
        return this.data.charAt(this.idx++);
    }

    @Override
    public long skip(long n) throws IOException {
        this.idx = (int)((long)this.idx + n);
        return n;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.marked = this.idx;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.idx = this.marked;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

