/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.handlers.EmptyDocHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.parser.helpers.Reference;
import com.sap.engine.lib.xsl.xpath.DTMFactory;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public final class NamespaceAppender
extends EmptyDocHandler {
    private static final String MARK = "#MARK";
    private static final String DNS = "#DNS";
    private static final String NONE = "#NONE";
    private static final CharArray CA_EMPTY = CharArray.EMPTY;
    private static final CharArray CA_XMLNS = new CharArray("xmlns");
    private static final CharArray CA_XMLNS_COLON = new CharArray("xmlns:");
    private static final CharArray CA_XML = new CharArray("xml");
    private static final CharArray CA_XMLNS_NS = new CharArray("http://www.w3.org/2000/xmlns/");
    private DocHandler h = null;
    private String[] stack = new String[100];
    private int nStack;
    private boolean isMappedInLastContext = false;
    private CharArray ca0 = new CharArray();
    private CharArray ca1 = new CharArray();
    private CharArray ca2 = new CharArray();

    public NamespaceAppender() {
    }

    public NamespaceAppender(DocHandler h) {
        this.init(h);
    }

    public NamespaceAppender init(DocHandler h) {
        this.h = h;
        return this;
    }

    @Override
    public void startDocument() throws Exception {
        this.nStack = 0;
        this.h.startDocument();
    }

    @Override
    public void startElementStart(CharArray uri, CharArray localName, CharArray qname) throws Exception {
        qname.parseNS(this.ca0, this.ca1);
        String uri1 = this.findMapping(this.ca0);
        if (this.empty(uri) && !this.empty(uri1)) {
            uri = new CharArray(uri1);
        }
        this.h.startElementStart(uri, localName, qname);
        this.pushContext();
        if (this.empty(uri)) {
            this.undeclareDNS();
        } else if (this.empty(this.ca0)) {
            this.declareDNS(uri.toString());
        } else {
            String prefix = this.ca0.getString();
            this.declare(prefix, uri.toString());
        }
    }

    @Override
    public void addAttribute(CharArray curi, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        if (this.empty(prefix) && localName.equals("xmlns")) {
            if (this.empty(value)) {
                this.undeclareDNS();
            } else {
                this.declareDNS(value.getString());
            }
            return;
        }
        if (prefix.equals("xmlns")) {
            this.declare(localName.getString(), value.getString());
            return;
        }
        if (localName.startsWith(CA_XMLNS_COLON)) {
            this.declare(localName.getString().substring(6), value.getString());
            return;
        }
        if (curi.length() == 0) {
            if (!this.empty(prefix) && !prefix.startsWith(CA_XML)) {
                throw new TransformerException("Namespace fixup failed. Prefix '" + prefix + "' used in attribute '" + qname + "' is not declared anywhere");
            }
        } else if (this.empty(prefix)) {
            LogWriter.getSystemLogWriter().println("Warning: XMLParser/NamepspaceAppender: Adding an attribute with name:\"" + qname + "\" and namespace:\"" + curi + "\". This is not allowed. The attribute name must have a prefix. Ignoring namespace declaration.");
        } else if (!prefix.equals(CA_XML)) {
            String uri = curi.toString();
            this.declare(prefix.getString(), uri);
        }
        this.h.addAttribute(curi, prefix, localName, qname, type, value);
    }

    @Override
    public void startElementEnd(boolean isEmpty) throws Exception {
        this.h.startElementEnd(isEmpty);
    }

    @Override
    public void endElement(CharArray curi, CharArray localName, CharArray qname, boolean isEmpty) throws Exception {
        this.h.endElement(curi, localName, qname, isEmpty);
        this.popContext();
    }

    @Override
    public void onXMLDecl(String version, String encoding, String ssdecl) throws Exception {
        this.h.onXMLDecl(version, encoding, ssdecl);
    }

    @Override
    public void startPrefixMapping(CharArray prefix, CharArray uri) throws Exception {
    }

    @Override
    public void endPrefixMapping(CharArray prefix) throws Exception {
    }

    @Override
    public void endDocument() throws Exception {
        this.h.endDocument();
    }

    @Override
    public void charData(CharArray carr, boolean bDisableOutputEscaping) throws Exception {
        this.h.charData(carr, bDisableOutputEscaping);
    }

    @Override
    public void onPI(CharArray target, CharArray data) throws Exception {
        this.h.onPI(target, data);
    }

    @Override
    public void onComment(CharArray text) throws Exception {
        this.h.onComment(text);
    }

    @Override
    public void onCDSect(CharArray text) throws Exception {
        this.h.onCDSect(text);
    }

    @Override
    public void onDTDElement(CharArray name, CharArray model) throws Exception {
        this.h.onDTDElement(name, model);
    }

    @Override
    public void onDTDAttListStart(CharArray name) throws Exception {
        this.h.onDTDAttListStart(name);
    }

    @Override
    public void onDTDAttListItem(CharArray name, CharArray attname, String type, String defDecl, CharArray vAttValue, String note) throws Exception {
        this.h.onDTDAttListItem(name, attname, type, defDecl, vAttValue, note);
    }

    @Override
    public void onDTDAttListEnd() throws Exception {
        this.h.onDTDAttListEnd();
    }

    @Override
    public void onDTDEntity(Entity entity) throws Exception {
        this.h.onDTDEntity(entity);
    }

    @Override
    public void onDTDNotation(CharArray name, CharArray pub, CharArray sys) throws Exception {
        this.h.onDTDNotation(name, pub, sys);
    }

    @Override
    public void startDTD(CharArray name, CharArray pub, CharArray sys) throws Exception {
        this.h.startDTD(name, pub, sys);
    }

    @Override
    public void endDTD() throws Exception {
        this.h.endDTD();
    }

    @Override
    public void onContentReference(Reference ref) throws Exception {
        this.h.onContentReference(ref);
    }

    @Override
    public void onWarning(String s) throws Exception {
        this.h.onWarning(s);
    }

    private void push(String prefix, String uri) {
        if (this.nStack + 2 >= this.stack.length) {
            String[] old = this.stack;
            this.stack = new String[this.nStack * 2];
            System.arraycopy(old, 0, this.stack, 0, old.length);
        }
        this.stack[this.nStack++] = prefix;
        this.stack[this.nStack++] = uri;
    }

    private void pushContext() {
        this.push(MARK, MARK);
    }

    private void declare(String p, String u) throws Exception {
        String m = this.findMapping(p);
        if (this.isMappedInLastContext) {
            if (!m.equals(u)) {
                throw new TransformerException("Namespace fixup failed. Attempt to map prefix '" + p + "' to both '" + m + "' and '" + u + "'");
            }
        } else if (m == null || !m.equals(u)) {
            this.push(p, u);
            this.ca1.set(CA_XMLNS);
            this.ca1.append(':');
            this.ca1.append(p);
            this.h.addAttribute(null, CA_XMLNS, this.ca0.set(p), this.ca1, null, this.ca2.set(u));
        }
    }

    private void declareDNS(String u) throws Exception {
        String m = this.findMapping(DNS);
        if (this.isMappedInLastContext) {
            if (!m.equals(u)) {
                throw new TransformerException("Namespace fixup failed.");
            }
        } else if (m == null || m.equals(NONE) || !m.equals(u)) {
            this.push(DNS, u);
            this.h.addAttribute(CA_XMLNS_NS, CA_EMPTY, CA_XMLNS, CA_XMLNS, null, this.ca0.set(u));
        }
    }

    private void undeclareDNS() throws Exception {
        String m = this.findMapping(DNS);
        if (this.isMappedInLastContext) {
            if (!m.equals(NONE)) {
                throw new TransformerException("Namespace fixup failed");
            }
        } else if (m != null && !m.equals(NONE)) {
            this.push(DNS, NONE);
            this.h.addAttribute(CA_XMLNS_NS, CA_EMPTY, CA_XMLNS, CA_XMLNS, null, CA_EMPTY);
        }
    }

    private void popContext() {
        do {
            --this.nStack;
        } while (!this.stack[this.nStack].equals(MARK));
        --this.nStack;
    }

    private String findMapping(String prefix) {
        int i = this.nStack - 2;
        this.isMappedInLastContext = true;
        while (i >= 0) {
            if (this.stack[i].equals(MARK)) {
                i -= 2;
                this.isMappedInLastContext = false;
                continue;
            }
            if (prefix.equals(this.stack[i])) {
                return this.stack[i + 1];
            }
            i -= 2;
        }
        return null;
    }

    private String findMapping(CharArray prefix) {
        int i = this.nStack - 2;
        this.isMappedInLastContext = true;
        while (i >= 0) {
            if (this.stack[i].equals(MARK)) {
                i -= 2;
                this.isMappedInLastContext = false;
                continue;
            }
            if (prefix.equals(this.stack[i])) {
                return this.stack[i + 1];
            }
            i -= 2;
        }
        return null;
    }

    private boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    private boolean empty(CharArray s) {
        return s == null || s.length() == 0;
    }

    @Override
    public void onStartContentEntity(CharArray name, boolean isExpanding) throws Exception {
        this.h.onStartContentEntity(name, isExpanding);
    }

    @Override
    public void onEndContentEntity(CharArray name) throws Exception {
        this.h.onEndContentEntity(name);
    }

    @Override
    public void onCustomEvent(int eventId, Object obj) throws Exception {
        this.h.onCustomEvent(eventId, obj);
    }

    void setNodeToHandler(Node node) {
        if (this.h instanceof DTMFactory) {
            ((DTMFactory)this.h).setNodeToHandler(node);
        }
    }
}

