/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import com.sap.engine.lib.xml.dom.DOMImplementationImpl;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXToDOMHandler
extends DefaultHandler
implements ContentHandler,
DTDHandler,
ErrorHandler,
DeclHandler,
LexicalHandler {
    private Document document = null;
    private Node root = null;
    private Node current = null;
    private DOMResult domResult = null;
    private boolean isInCDATASection = false;

    public SAXToDOMHandler() {
    }

    public SAXToDOMHandler(Node node) {
        this.setRoot(node);
    }

    public SAXToDOMHandler(DOMResult domResult) {
        this.domResult = domResult;
        this.setRoot(domResult.getNode());
    }

    public void setRoot(Node node) {
        this.root = node;
    }

    public Node getRoot() {
        return this.root;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.root == null) {
            this.document = new DOMImplementationImpl().createDocument(null, null, null);
            this.root = this.document;
        } else {
            this.document = this.root instanceof Document ? (Document)this.root : this.root.getOwnerDocument();
        }
        if (this.document == null) {
            throw new SAXException("Unable to convert SAX to DOM, root Node has no owner Document.");
        }
        this.current = this.root;
        this.isInCDATASection = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.domResult != null) {
            this.domResult.setNode(this.root);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Element x = this.document.createElementNS(uri, qName);
        int i = 0;
        while (i < atts.getLength()) {
            String uri2 = atts.getURI(i);
            if (atts.getQName(i).startsWith("xmlns")) {
                uri2 = "http://www.w3.org/2000/xmlns/";
            }
            x.setAttributeNS(uri2, atts.getQName(i), atts.getValue(i));
            ++i;
        }
        this.current.appendChild(x);
        this.current = x;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.current = this.current.getParentNode();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        Text x = this.isInCDATASection ? this.document.createCDATASection(new String(ch, start, length)) : this.document.createTextNode(new String(ch, start, length));
        this.current.appendChild(x);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        ProcessingInstruction x = this.document.createProcessingInstruction(target, data);
        this.current.appendChild(x);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
    }

    @Override
    public void elementDecl(String name, String model) throws SAXException {
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        Comment x = this.document.createComment(new String(ch, start, length));
        this.current.appendChild(x);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.isInCDATASection = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.isInCDATASection = false;
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }
}

