/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import com.sap.engine.lib.xml.parser.helpers.CharArray;

public class SymbolTable {
    protected static final int TABLE_SIZE = 10001;
    protected Entry[] fBuckets = null;
    protected int fTableSize;
    protected byte[] entriesInCollusionList;

    public SymbolTable() {
        this(10001);
    }

    public SymbolTable(int tableSize) {
        this.fTableSize = tableSize;
        this.fBuckets = new Entry[this.fTableSize];
        this.entriesInCollusionList = new byte[this.fTableSize];
    }

    public String addSymbol(String symbol) {
        int bucket = this.hash(symbol) % this.fTableSize;
        int length = symbol.length();
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                if (length == entry.characters.length) {
                    int i = 0;
                    while (i < length) {
                        if (symbol.charAt(i) == entry.characters[i]) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    return entry.symbol;
                }
            }
            entry = entry.next;
        }
        this.updateCollList(bucket);
        this.fBuckets[bucket] = entry = new Entry(symbol, this.fBuckets[bucket]);
        return entry.symbol;
    }

    public synchronized String addSymbol(char[] buffer, int offset, int length) {
        int bucket = this.hash(buffer, offset, length) % this.fTableSize;
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                if (length == entry.characters.length) {
                    int i = 0;
                    while (i < length) {
                        if (buffer[offset + i] == entry.characters[i]) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    return entry.symbol;
                }
            }
            entry = entry.next;
        }
        this.updateCollList(bucket);
        this.fBuckets[bucket] = entry = new Entry(buffer, offset, length, this.fBuckets[bucket]);
        return entry.symbol;
    }

    public String addSymbol(CharArray ca) {
        return this.addSymbol(ca.getData(), ca.getOffset(), ca.getSize());
    }

    public int hash(String symbol) {
        int code = 0;
        int length = symbol.length();
        int i = 0;
        while (i < length) {
            code = code * 37 + symbol.charAt(i);
            ++i;
        }
        return code & 0x7FFFFFF;
    }

    public int hash(char[] buffer, int offset, int length) {
        int code = 0;
        int i = 0;
        while (i < length) {
            code = code * 37 + buffer[offset + i];
            ++i;
        }
        return code & 0x7FFFFFF;
    }

    public boolean containsSymbol(String symbol) {
        int bucket = this.hash(symbol) % this.fTableSize;
        int length = symbol.length();
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                if (length == entry.characters.length) {
                    int i = 0;
                    while (i < length) {
                        if (symbol.charAt(i) == entry.characters[i]) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] buffer, int offset, int length) {
        int bucket = this.hash(buffer, offset, length) % this.fTableSize;
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                if (length == entry.characters.length) {
                    int i = 0;
                    while (i < length) {
                        if (buffer[offset + i] == entry.characters[i]) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    private void updateCollList(int index) {
        if (this.entriesInCollusionList[index] > 10) {
            this.fBuckets[index] = null;
            this.entriesInCollusionList[index] = 0;
        } else {
            int n = index;
            this.entriesInCollusionList[n] = (byte)(this.entriesInCollusionList[n] + 1);
        }
    }

    protected static final class Entry {
        public String symbol;
        public char[] characters;
        public Entry next;

        public Entry(String symbol, Entry next) {
            this.symbol = symbol.intern();
            this.characters = new char[symbol.length()];
            symbol.getChars(0, this.characters.length, this.characters, 0);
            this.next = next;
        }

        public Entry(char[] ch, int offset, int length, Entry next) {
            this.characters = new char[length];
            System.arraycopy(ch, offset, this.characters, 0, length);
            this.symbol = new String(this.characters).intern();
            this.next = next;
        }
    }
}

