/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util.analyze;

import com.sap.engine.lib.xml.util.analyze.XMLAnalyzerResult;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class XMLAnalyzer {
    public XMLAnalyzerResult analyze(String fname) throws IOException {
        int ii;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fname));
        boolean inTag = false;
        int tagcount = 0;
        int tagchars = 0;
        int tagsyms = 0;
        int docchars = 0;
        int totchars = 0;
        long proctime = System.currentTimeMillis();
        while ((ii = in.read()) != -1) {
            if (ii == 60) {
                inTag = true;
                ++tagcount;
                ++tagsyms;
            } else if (ii == 47) {
                ++tagsyms;
            } else if (ii == 62) {
                ++tagsyms;
                inTag = false;
            } else if (inTag) {
                ++tagchars;
            } else {
                ++docchars;
            }
            ++totchars;
        }
        proctime = System.currentTimeMillis() - proctime;
        in.close();
        return new XMLAnalyzerResult(fname, totchars, tagcount, tagchars, tagsyms, docchars, proctime);
    }
}

