/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.util.NestedIOException;
import com.sap.engine.lib.xsl.xpath.FunctionLibrary;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.functions.BSFFunction;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BSFLibrary
implements FunctionLibrary {
    private CharArray classNameOrg = new CharArray();
    private static String bsfManager = "com.ibm.bsf.BSFManager";
    private static String bsfException = "com.ibm.bsf.BSFException";
    private static String bsfEngine = "com.ibm.bsf.BSFEngine";
    private static Class bsfManagerClass = null;
    private static Class bsfExceptionClass = null;
    private static Class bsfEngineClass = null;
    private String language = null;
    private Object bsfManagerObject = null;
    private Object bsfEngineObject = null;

    static {
        try {
            bsfManagerClass = Class.forName(bsfManager);
            bsfExceptionClass = Class.forName(bsfException);
            bsfEngineClass = Class.forName(bsfEngine);
        }
        catch (ClassNotFoundException e) {
            LogWriter.getSystemLogWriter().println("At least one class for BSF not found!");
            e.printStackTrace();
        }
    }

    public BSFLibrary(String name, String language, String scriptSource) throws XPathException {
        if (name != null) {
            this.classNameOrg.set(name);
        } else {
            this.classNameOrg.set(language);
        }
        this.language = language;
        this.getReady(scriptSource);
    }

    public BSFLibrary(String name, String language, File f) throws XPathException, ClassNotFoundException, IOException {
        if (name != null) {
            this.classNameOrg.set(name);
        } else {
            this.classNameOrg.set(language);
        }
        try {
            char c;
            if (language == null) {
                Method m = bsfManagerClass.getMethod("getLangFromFilename", Class.forName("java.lang.String"));
                this.language = (String)m.invoke(null, new String(f.getName()));
            } else {
                this.language = language;
            }
            StringBuffer result = new StringBuffer();
            FileReader f1 = new FileReader(f);
            while ((c = (char)f1.read()) != '\uffff') {
                result.append(c);
            }
            f1.close();
            this.getReady(result.toString());
        }
        catch (IOException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new NestedIOException(e);
        }
        catch (IllegalAccessException e) {
            throw new NestedIOException(e);
        }
        catch (InvocationTargetException e) {
            throw new NestedIOException(e);
        }
    }

    private void getReady(String scriptSource) throws XPathException {
        try {
            this.bsfManagerObject = bsfManagerClass.newInstance();
            Boolean isLanguageRegistered = (Boolean)bsfManagerClass.getMethod("isLanguageRegistered", Class.forName("java.lang.String")).invoke(null, new String(this.language));
            if (!isLanguageRegistered.booleanValue()) {
                throw new XPathException("Language " + this.language + " is not registered!");
            }
            this.bsfEngineObject = bsfManagerClass.getMethod("loadScriptingEngine", Class.forName("java.lang.String")).invoke(this.bsfManagerObject, new String(this.language));
            this.compileSource(scriptSource);
        }
        catch (XPathException e) {
            throw new XPathException(e);
        }
        catch (InvocationTargetException e) {
            throw new XPathException(e);
        }
        catch (Exception e) {
            throw new XPathException(e);
        }
    }

    @Override
    public void init(String str) {
    }

    private void compileSource(String ScriptSource) throws XPathException {
        try {
            bsfEngineClass.getMethod("exec", Class.forName("java.lang.String"), Integer.TYPE, Integer.TYPE, Class.forName("java.lang.Object")).invoke(this.bsfEngineObject, "", new Integer("-1"), new Integer("-1"), ScriptSource);
        }
        catch (Exception e) {
            throw new XPathException(e);
        }
    }

    @Override
    public XFunction getFunction(CharArray method) throws XPathException {
        return new BSFFunction(this.bsfEngineObject, method.toString());
    }

    @Override
    public CharArray getName() {
        return this.classNameOrg;
    }
}

