/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xml.dom.AttrImpl;
import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.pool.CharArrayPool;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xsl.xpath.LibraryManager;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.xobjects.XObjectFactory;
import com.sap.engine.lib.xsl.xslt.QName;
import com.sap.engine.lib.xsl.xslt.VariableContext;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DTM {
    public static final int DEFAULT_CAPACITY = 10;
    public int RESIZE_STEP = 10;
    public static int MAX_SIZE = 1000;
    public int size = 0;
    private int capacity;
    public QName[] name;
    public byte[] nodeType;
    public int[] parent;
    public int[] firstChild;
    public int[] firstAttr;
    public int[] previousSibling;
    public int[] nextSibling;
    public int[] documentNodes;
    public int documentNodesCount = 0;
    private boolean[] initialized = null;
    private StringBuffer leadingText = new StringBuffer(1024);
    private static final String[] empty = new String[0];
    private boolean[] dangling = null;
    private boolean domInitialized = false;
    private DocumentImpl doc = null;
    private Node frag = null;
    protected CharArray[] stringValue;
    protected CharArray buffer = new CharArray(100000, 100000);
    protected int[] indexStart;
    protected int[] indexEnd;
    boolean bEndDoc = false;
    private int[] idAttributes = new int[100];
    private int nIdAttributes = 0;
    private int danglingLength = 0;
    public int lastAttribute = -1;
    public Node[] domtree = null;
    public static final byte ELEMENT_NODE = 1;
    public static final byte ATTRIBUTE_NODE = 2;
    public static final byte TEXT_NODE = 3;
    public static final byte CDATA_SECTION_NODE = 4;
    public static final byte ENTITY_REFERENCE_NODE = 5;
    public static final byte ENTITY_NODE = 6;
    public static final byte PROCESSING_INSTRUCTION_NODE = 7;
    public static final byte COMMENT_NODE = 8;
    public static final byte DOCUMENT_NODE = 9;
    public static final byte DOCUMENT_TYPE_NODE = 10;
    public static final byte DOCUMENT_FRAGMENT_NODE = 11;
    public static final byte NOTATION_NODE = 12;
    public static final byte NAMESPACE_NODE = 13;
    public static final byte WHATEVER_NODE = 100;
    public static final int NONE = -1;
    public CharArrayPool carrPool = new CharArrayPool(10000, 10000);
    public Hashtable qnamesTable = new Hashtable(10000);
    public XObjectFactory xfactProcess = null;
    public XObjectFactory xfactMatch = null;
    public Hashtable xfDocumentCache = new Hashtable();
    private int[] excluding = null;
    private String[] specialPrefixes = null;
    private boolean inclusive = true;
    private Hashtable hiddenXML = new Hashtable();
    private Hashtable ownXMLAttribs = new Hashtable();
    boolean retain = true;
    int lastDocElID;
    Hashtable lastElementsTable = new Hashtable();

    public DTM() {
        this(10);
    }

    public DTM(int capacity) {
        this.capacity = capacity;
        this.name = new QName[capacity];
        this.nodeType = new byte[capacity];
        this.parent = new int[capacity];
        this.firstChild = new int[capacity];
        this.firstAttr = new int[capacity];
        this.previousSibling = new int[capacity];
        this.nextSibling = new int[capacity];
        this.stringValue = new CharArray[capacity];
        this.indexStart = new int[capacity];
        this.indexEnd = new int[capacity];
        this.documentNodes = new int[10];
    }

    public void setFactories(XObjectFactory xp, XObjectFactory xm) {
        this.xfactProcess = xp;
        this.xfactMatch = xm;
    }

    public XPathContext getInitialContext() {
        return this.getInitialContext(null);
    }

    public XPathContext getInitialContext(XSLStylesheet owner) {
        if (this.xfactProcess == null) {
            this.xfactMatch = this.xfactProcess = new XObjectFactory(100);
        }
        return new XPathContext(this, 0, 1, 1, new VariableContext(), new LibraryManager(), new Hashtable(), 0, this.xfactProcess, this.xfactMatch, owner, null);
    }

    public void clear() {
        this.size = 0;
        this.buffer.clear();
        this.xfactProcess = null;
        this.xfactMatch = null;
        this.xfDocumentCache.clear();
        this.nIdAttributes = 0;
        this.documentNodesCount = 0;
        this.qnamesTable.clear();
        this.domInitialized = false;
        this.lastElementsTable.clear();
        this.lastDocElID = -1;
    }

    public void clearDirty() {
        this.size = 0;
        this.buffer.clear();
        if (this.xfactProcess != null) {
            this.xfactProcess.releaseAllPools();
        }
        if (this.xfactMatch != null) {
            this.xfactMatch.releaseAllPools();
        }
        this.xfDocumentCache.clear();
        this.nIdAttributes = 0;
        this.documentNodesCount = 0;
        this.leadingText.setLength(0);
        if (this.capacity > MAX_SIZE) {
            this.trim();
            this.xfactMatch = null;
            this.xfactProcess = null;
        }
        this.qnamesTable.clear();
    }

    public void addIdAttribute(int x) {
        if (this.idAttributes.length == this.nIdAttributes) {
            int[] idAttributesOld = this.idAttributes;
            this.idAttributes = new int[this.nIdAttributes * 2];
            System.arraycopy(idAttributesOld, 0, this.idAttributes, 0, this.nIdAttributes);
        }
        this.idAttributes[this.nIdAttributes] = x;
        ++this.nIdAttributes;
    }

    public int getElementById(String id) {
        int i = 0;
        while (i < this.nIdAttributes) {
            if (this.getStringValue(this.idAttributes[i]).equals(id)) {
                return this.parent[this.idAttributes[i]];
            }
            ++i;
        }
        return -1;
    }

    protected void appendNode(CharArray name0, CharArray uri, int uriId, byte nodeType0, CharArray stringValue0, int indexStart0, int indexEnd0) {
        if (this.size >= this.capacity - 1) {
            this.resize();
        }
        if (nodeType0 == 9) {
            this.bEndDoc = false;
            this.documentNodes[this.documentNodesCount++] = this.size;
            if (this.documentNodesCount == this.documentNodes.length) {
                int[] temp = new int[this.documentNodesCount + this.RESIZE_STEP];
                System.arraycopy(this.documentNodes, 0, temp, 0, this.documentNodesCount);
                this.documentNodes = temp;
            }
        } else {
            this.bEndDoc = false;
        }
        if (uri == null) {
            uri = CharArray.EMPTY;
        }
        if (nodeType0 != 3) {
            String key = "{" + uri + '}' + name0;
            QName qname = (QName)this.qnamesTable.get(key);
            if (qname == null) {
                qname = new QName().reuse(name0, uri, uriId);
                this.qnamesTable.put(key, qname);
            }
            this.name[this.size] = qname;
        } else {
            this.name[this.size] = null;
        }
        this.nodeType[this.size] = nodeType0;
        this.nextSibling[this.size] = -1;
        this.previousSibling[this.size] = -1;
        this.firstChild[this.size] = -1;
        this.parent[this.size] = -1;
        if (stringValue0 != null) {
            if (this.stringValue[this.size] != null) {
                this.stringValue[this.size].clear();
            }
            if (this.stringValue[this.size] == null) {
                this.stringValue[this.size] = this.carrPool.getObject().reuse();
            }
            this.stringValue[this.size].set(stringValue0);
        }
        this.indexStart[this.size] = indexStart0;
        this.indexEnd[this.size] = indexEnd0;
        ++this.size;
    }

    private void appendDetailedItem(StringBuffer sb, int index) {
        sb.append("    [").append(index).append("] ").append(this.nodeTypeToString(this.nodeType[index])).append(" name='").append(this.name[index]).append("', parent=").append(this.parent[index]).append(", previousSibling=").append(this.previousSibling[index]).append(", nextSibling=").append(this.nextSibling[index]).append(", firstChild=").append(this.firstChild[index]).append(", stringValue='");
        if (this.stringValue[index].length() < 30) {
            sb.append(this.stringValue[index].replace('\n', '#'));
        } else {
            sb.append(this.stringValue[index].replace('\n', '#'));
            sb.append("...");
        }
        sb.append("']\n");
    }

    public String toDetailedString() {
        if (this.size == 0) {
            return "(EMPTY DTM)";
        }
        StringBuffer r = new StringBuffer(100000);
        r.append("\nDocument Table Model, detailed description: \n");
        this.appendDetailedItem(r, 0);
        int i = 1;
        while (i < this.size) {
            this.appendDetailedItem(r, i);
            ++i;
        }
        r.append("\n");
        return r.toString();
    }

    public int[] getChildNodes(int node, int[] nodes, int start) {
        int i = this.firstChild[node];
        int p = start;
        int nodesLength = nodes.length;
        while (true) {
            if (p >= nodesLength) {
                nodes = this.resizeIntArray(nodes, p);
                nodesLength = nodes.length;
            }
            nodes[p] = i;
            if (i == -1) break;
            i = this.nextSibling[i];
            ++p;
        }
        return nodes;
    }

    public int[] getChildNodes(int node) {
        int i = this.firstChild[node];
        int nodeCount = 0;
        while (i != -1) {
            ++nodeCount;
            i = this.nextSibling[i];
        }
        int[] nodes = new int[nodeCount];
        i = this.firstChild[node];
        nodeCount = 0;
        while (i != -1) {
            nodes[nodeCount++] = i;
            i = this.nextSibling[i];
        }
        return nodes;
    }

    public int[] getAttributeNodes(int node, int[] nodes, int start) {
        int x = node + 1;
        int p = start;
        int nodesLength = nodes.length;
        while (true) {
            byte t;
            if (p >= nodesLength) {
                nodes = this.resizeIntArray(nodes, p);
                nodesLength = nodes.length;
            }
            if ((t = this.nodeType[x]) != 2 && t != 13) break;
            if (t == 2) {
                nodes[p] = x;
                ++p;
            }
            ++x;
        }
        nodes[p] = -1;
        return nodes;
    }

    public int[] getAttributeAndNSNodes(int node, int[] nodes, int start) {
        int x = this.firstAttr[node];
        int p = start;
        int nodesLength = nodes.length;
        while (x != -1) {
            if (p >= nodesLength) {
                nodes = this.resizeIntArray(nodes, p);
                nodesLength = nodes.length;
            }
            nodes[p++] = x;
            if (p >= nodes.length) {
                nodes = this.resizeIntArray(nodes, p);
            }
            x = this.nextSibling[x];
        }
        nodes[p] = -1;
        return nodes;
    }

    public int getAttributesStartIndex(int node) {
        return this.firstAttr[node] != -1 ? this.firstAttr[node] : node + 1;
    }

    public int getAttributesEndIndex(int node) {
        if (this.firstAttr[node] != -1) {
            int x = this.firstAttr[node];
            while (this.nextSibling[x] != -1) {
                x = this.nextSibling[x];
            }
            return x;
        }
        int x = node + 1;
        while (x < this.size && this.nodeType[x] == 2) {
            ++x;
        }
        return x - 1;
    }

    public int getAttributesAndNSEndIndex(int node) {
        if (this.firstAttr[node] != -1) {
            int x = this.firstAttr[node];
            while (this.nextSibling[x] != -1) {
                x = this.nextSibling[x];
            }
            return x;
        }
        int x = node + 1;
        while (x < this.size && (this.nodeType[x] == 2 || this.nodeType[x] == 13)) {
            ++x;
        }
        return x - 1;
    }

    void resize() {
        this.resize(this.capacity + this.RESIZE_STEP);
    }

    public void trim() {
        this.name = new QName[10];
        this.nodeType = new byte[10];
        this.parent = new int[10];
        this.firstChild = new int[10];
        this.previousSibling = new int[10];
        this.nextSibling = new int[10];
        this.stringValue = new CharArray[10];
        this.indexStart = new int[10];
        this.indexEnd = new int[10];
        this.documentNodes = new int[10];
        this.buffer = new CharArray(100000, 100000);
        this.firstAttr = new int[10];
        this.RESIZE_STEP = this.capacity = 10;
    }

    void resize(int capacity1) {
        QName[] name1 = new QName[capacity1];
        System.arraycopy(this.name, 0, name1, 0, this.capacity);
        this.name = name1;
        byte[] nodeType1 = new byte[capacity1];
        System.arraycopy(this.nodeType, 0, nodeType1, 0, this.capacity);
        this.nodeType = nodeType1;
        int[] parent1 = new int[capacity1];
        System.arraycopy(this.parent, 0, parent1, 0, this.capacity);
        this.parent = parent1;
        int[] firstChild1 = new int[capacity1];
        System.arraycopy(this.firstChild, 0, firstChild1, 0, this.capacity);
        this.firstChild = firstChild1;
        int[] firstAttr1 = new int[capacity1];
        System.arraycopy(this.firstAttr, 0, firstAttr1, 0, this.capacity);
        this.firstAttr = firstAttr1;
        int[] previousSibling1 = new int[capacity1];
        System.arraycopy(this.previousSibling, 0, previousSibling1, 0, this.capacity);
        this.previousSibling = previousSibling1;
        int[] nextSibling1 = new int[capacity1];
        System.arraycopy(this.nextSibling, 0, nextSibling1, 0, this.capacity);
        this.nextSibling = nextSibling1;
        CharArray[] stringValue1 = new CharArray[capacity1];
        System.arraycopy(this.stringValue, 0, stringValue1, 0, this.capacity);
        this.stringValue = stringValue1;
        int[] indexStart1 = new int[capacity1];
        System.arraycopy(this.indexStart, 0, indexStart1, 0, this.capacity);
        this.indexStart = indexStart1;
        int[] indexEnd1 = new int[capacity1];
        System.arraycopy(this.indexEnd, 0, indexEnd1, 0, this.capacity);
        this.indexEnd = indexEnd1;
        this.capacity = capacity1;
        this.RESIZE_STEP = this.capacity / 2;
    }

    public String nodeTypeToString(int nt) {
        String[] s = new String[]{"", "ELEM", "ATTR", "TEXT", "CDTA", "EREF", "ENTY", "PROC", "COMM", "DOCU", "DCTP", "DCFR", "NOTN"};
        return s[nt];
    }

    public int getCapacity() {
        return this.capacity;
    }

    private int[] resizeIntArray(int[] a, int l) {
        int[] b = new int[l + a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    public void getStringValue(int index, CharArray ca) {
        int b = this.indexStart[index];
        if (b != -1) {
            int e = this.indexEnd[index];
            ca.substring(this.buffer, b, e);
        } else {
            ca.set(this.stringValue[index]);
        }
    }

    public void appendStringValue(int index, CharArray ca) {
        int b = this.indexStart[index];
        if (b != -1) {
            int e = this.indexEnd[index];
            ca.append(this.buffer.getData(), b, e - b);
        } else {
            ca.append(this.stringValue[index]);
        }
    }

    public CharArray getStringValue(int index) {
        int b = this.indexStart[index];
        if (b != -1) {
            int e = this.indexEnd[index];
            if (this.stringValue[index] == null) {
                this.stringValue[index] = this.carrPool.getObject().reuse();
            }
            this.stringValue[index].substring(this.buffer, b, e);
            this.indexStart[index] = -1;
            this.indexEnd[index] = -1;
            return this.stringValue[index];
        }
        return this.stringValue[index];
    }

    public Document getDocument() {
        this.initializeDOM();
        return this.doc;
    }

    public Node getFragment() {
        return this.frag;
    }

    public StringBuffer getLeadingText() {
        return this.leadingText;
    }

    public void reinitializeDOM(int[] $excluding) {
        this.reinitializeDOM($excluding, false, empty, false);
    }

    public void reinitializeDOM(int[] $excluding, String[] specialNamespaces) {
        this.reinitializeDOM($excluding, false, specialNamespaces, false);
    }

    public void reinitializeDOM(int[] $excluding, boolean retainParentNamespaces) {
        this.reinitializeDOM($excluding, retainParentNamespaces, null, false);
    }

    public void reinitializeDOM(int[] $excluding, boolean retainParentNamespaces, String[] specialNamespaces) {
        this.reinitializeDOM($excluding, retainParentNamespaces, specialNamespaces, false);
    }

    public void reinitializeDOM(int[] $excluding, boolean retainParentNamespaces, String[] specialNamespaces, boolean $visibleOnly) {
        this.retain = retainParentNamespaces;
        this.doc = new DocumentImpl();
        this.domtree = new Node[this.size];
        this.dangling = new boolean[this.size];
        this.initialized = new boolean[this.size];
        this.excluding = $excluding;
        this.inclusive = !$visibleOnly;
        this.specialPrefixes = specialNamespaces;
        int tempIndex = this.excluding.length == 0 || this.excluding[0] > 0 ? 0 : 1;
        this.danglingLength = 0;
        int i = 1;
        while (i < this.domtree.length) {
            if (tempIndex >= this.excluding.length || i < this.excluding[tempIndex]) {
                this.domtree[i] = this.subtree(i, null, null, null);
                this.dangling[i] = this.isDangling(i, this.excluding);
            } else {
                this.subtreeEx(i, null, null, null, null);
                ++tempIndex;
            }
            ++i;
        }
        i = 1;
        tempIndex = this.excluding.length == 0 || this.excluding[0] > 0 ? 0 : 1;
        boolean found = false;
        i = 1;
        while (i < this.size) {
            if (tempIndex >= this.excluding.length || i < this.excluding[tempIndex]) {
                found = false;
            } else {
                found = true;
                ++tempIndex;
            }
            if (!found && this.domtree[i] != null && this.domtree[i].getNodeType() == 3) {
                this.leadingText.append(this.stringValue[i].getData(), this.stringValue[i].getOffset(), this.stringValue[i].getSize());
                this.dangling[i] = false;
                --this.danglingLength;
            }
            if (!found) break;
            ++i;
        }
        if (i >= this.domtree.length) {
            return;
        }
        this.frag = this.doc.createDocumentFragment();
        if (this.danglingLength >= 1) {
            int j = i;
            while (j < this.size) {
                if (this.dangling[j]) {
                    this.frag.appendChild(this.domtree[j]);
                }
                ++j;
            }
        } else {
            this.frag = this.doc;
        }
        this.domtree[0] = this.doc;
        this.domInitialized = true;
    }

    public void setDOMInitialized(boolean domInitialized) {
        this.domInitialized = domInitialized;
    }

    public void initializeDOM() {
        if (!this.domInitialized) {
            this.doc = new DocumentImpl();
            this.domtree = new Node[this.size];
            this.initialized = new boolean[this.size];
            this.excluding = new int[0];
            this.specialPrefixes = empty;
            this.inclusive = true;
            int i = 1;
            while (i < this.domtree.length) {
                this.domtree[i] = this.subtree(i, null, null, null);
                ++i;
            }
            i = 1;
            while (i < this.domtree.length && this.domtree[i].getNodeType() == 3) {
                ++i;
            }
            this.doc.appendChild(this.domtree[i]);
            this.domtree[0] = this.doc;
            this.domInitialized = true;
        }
    }

    private boolean isDangling(int node, int[] excludeList) {
        int father = this.parent[node];
        if (this.nodeType[father] != 9) {
            if (Arrays.binarySearch(excludeList, father) >= 0) {
                return this.isDangling(father, excludeList);
            }
            return false;
        }
        ++this.danglingLength;
        return true;
    }

    private Node subtree(int index, Hashtable namespaces, Hashtable usedNamespaces, Hashtable xmlAttributes) {
        Node n;
        if (this.initialized[index]) {
            return this.domtree[index];
        }
        switch (this.nodeType[index]) {
            case 3: {
                n = this.doc.createTextNode(this.getStringValue(index).toString());
                break;
            }
            case 2: {
                n = this.doc.createAttributeNS(this.name[index].uri.toString(), this.name[index].rawname.toString());
                ((AttrImpl)n).setValue(this.getStringValue(index).toString());
                break;
            }
            case 7: {
                n = this.doc.createProcessingInstruction(this.name[index].rawname.toString(), this.getStringValue(index).toString());
                break;
            }
            case 13: {
                n = null;
                break;
            }
            case 8: {
                n = this.doc.createComment(this.getStringValue(index).toString());
                break;
            }
            case 4: {
                n = this.doc.createCDATASection(this.getStringValue(index).toString());
                break;
            }
            case 9: {
                DocumentImpl newDoc = new DocumentImpl();
                n = newDoc;
                DocumentImpl oldDoc = this.doc;
                this.doc = newDoc;
                try {
                    int child = this.firstChild[index];
                    while (child != -1) {
                        this.subtree(child, namespaces, null, xmlAttributes);
                        child = this.nextSibling[child];
                    }
                    break;
                }
                finally {
                    this.doc = oldDoc;
                }
            }
            case 1: {
                Object key;
                Enumeration enum1;
                boolean notCloned1 = true;
                this.hiddenXML.clear();
                this.ownXMLAttribs.clear();
                usedNamespaces = usedNamespaces == null ? new Hashtable() : usedNamespaces;
                n = this.doc.createElementNS(this.name[index].uri.toString(), this.name[index].rawname.toString());
                CharArray prefix = this.name[index].prefix;
                usedNamespaces.put(prefix == null || prefix.length() == 0 ? SignatureContext.DEFAULT : prefix, this.name[index].uri == null ? CharArray.EMPTY : this.name[index].uri);
                int x = index + 1;
                int i2 = Arrays.binarySearch(this.excluding, x);
                if (i2 < 0) {
                    i2 ^= 0xFFFFFFFF;
                }
                while (x < this.size) {
                    Attr ai;
                    QName q1;
                    if (i2 < this.excluding.length && this.excluding[i2] < x) {
                        ++i2;
                        continue;
                    }
                    if (i2 < this.excluding.length && this.excluding[i2] == x) {
                        q1 = this.name[x];
                        if (this.nodeType[x] == 2 && SignatureContext.XML.equals(q1.prefix) && this.inclusive) {
                            ai = this.doc.createAttributeNS(q1.uri.toString(), q1.rawname.toString());
                            ai.setValue(this.getStringValue(x).toString());
                            if (xmlAttributes == null || xmlAttributes.get(q1.localname) == null || !this.stringValue[x].equals(((Attr)xmlAttributes.get(q1.localname)).getNodeValue())) {
                                if (notCloned1) {
                                    xmlAttributes = xmlAttributes == null ? new Hashtable() : (Hashtable)xmlAttributes.clone();
                                    notCloned1 = false;
                                }
                                xmlAttributes.put(q1.localname, ai);
                            }
                            this.hiddenXML.put(q1.localname, ai);
                        }
                        this.domtree[x] = null;
                        this.initialized[x] = true;
                        ++i2;
                        ++x;
                        continue;
                    }
                    if (this.nodeType[x] != 2) {
                        if (this.nodeType[x] == 13) {
                            CharArray tempPrefix = this.name[x].localname;
                            if (tempPrefix == null || tempPrefix.length() == 0) {
                                tempPrefix = SignatureContext.DEFAULT;
                            }
                            if (this.retain || this.inclusive || this.specialPrefixes != null && Arrays.binarySearch(this.specialPrefixes, tempPrefix.toString()) >= 0) {
                                usedNamespaces.put(tempPrefix, this.stringValue[x]);
                            }
                        } else {
                            if (this.nodeType[x] != 8) break;
                            Comment comment = this.doc.createComment(this.getStringValue(index).toString());
                            ((Element)n).appendChild(comment);
                            this.domtree[x] = comment;
                        }
                    } else {
                        q1 = this.name[x];
                        if (q1.uri != null) {
                            ai = this.doc.createAttributeNS(q1.uri.toString(), q1.rawname.toString());
                            ai.setValue(this.getStringValue(x).toString());
                            if (SignatureContext.XML.equals(q1.prefix) && this.inclusive) {
                                if (xmlAttributes == null || xmlAttributes.get(q1.localname) == null || !this.stringValue[x].equals(((Attr)xmlAttributes.get(q1.localname)).getNodeValue())) {
                                    if (notCloned1) {
                                        xmlAttributes = xmlAttributes == null ? new Hashtable() : (Hashtable)xmlAttributes.clone();
                                        notCloned1 = false;
                                    }
                                    xmlAttributes.put(q1.localname, ai);
                                    this.ownXMLAttribs.put(q1.localname, ai);
                                }
                            } else {
                                ((Element)n).setAttributeNodeNS(ai);
                            }
                            this.domtree[x] = ai;
                            if (q1.prefix != null && q1.prefix.length() != 0) {
                                usedNamespaces.put(q1.prefix, q1.uri);
                            }
                        } else {
                            ai = this.doc.createAttribute(q1.rawname.toString());
                            ai.setValue(this.getStringValue(x).toString());
                            ((Element)n).setAttributeNode(ai);
                            this.domtree[x] = ai;
                        }
                    }
                    this.initialized[x] = true;
                    ++x;
                }
                Enumeration newNamespaces = usedNamespaces.keys();
                while (newNamespaces.hasMoreElements()) {
                    CharArray nextPrefix = (CharArray)newNamespaces.nextElement();
                    CharArray nextValue = namespaces == null ? null : (CharArray)namespaces.get(nextPrefix);
                    CharArray currentValue = (CharArray)usedNamespaces.get(nextPrefix);
                    if (currentValue.equals(nextValue)) continue;
                    Attr at = SignatureContext.DEFAULT.equals(nextPrefix) ? this.doc.createAttribute("xmlns") : this.doc.createAttribute("xmlns:".concat(nextPrefix.toString()));
                    at.setValue(currentValue.toString());
                    ((Element)n).setAttributeNode(at);
                }
                if (xmlAttributes != null) {
                    Attr atr;
                    if (this.domtree[this.parent[index]] == null) {
                        enum1 = xmlAttributes.keys();
                        while (enum1.hasMoreElements()) {
                            key = (CharArray)enum1.nextElement();
                            if (this.hiddenXML.containsKey(key)) continue;
                            atr = (Attr)((Attr)xmlAttributes.get(key)).cloneNode(true);
                            ((Element)n).setAttributeNodeNS(atr);
                        }
                    } else {
                        enum1 = this.ownXMLAttribs.keys();
                        while (enum1.hasMoreElements()) {
                            key = (CharArray)enum1.nextElement();
                            atr = (Attr)((Attr)this.ownXMLAttribs.get(key)).cloneNode(true);
                            ((Element)n).setAttributeNodeNS(atr);
                        }
                    }
                }
                if (namespaces != null) {
                    enum1 = namespaces.keys();
                    while (enum1.hasMoreElements()) {
                        key = enum1.nextElement();
                        if (usedNamespaces.get(key) != null) continue;
                        usedNamespaces.put(key, namespaces.get(key));
                    }
                }
                namespaces = usedNamespaces;
                int i1 = this.firstChild[index];
                this.domtree[index] = n;
                while (i1 != -1) {
                    if (Arrays.binarySearch(this.excluding, i1) < 0) {
                        n.appendChild(this.subtree(i1, namespaces, null, xmlAttributes));
                    } else {
                        this.subtreeEx(i1, namespaces, n, null, xmlAttributes);
                    }
                    i1 = this.nextSibling[i1];
                }
                break;
            }
            default: {
                return this.doc.createTextNode("");
            }
        }
        this.domtree[index] = n;
        this.initialized[index] = true;
        return n;
    }

    public void subtreeEx(int index, Hashtable namespaces, Node outputAncesstor, Hashtable usedNamespaces, Hashtable xmlAttributes) {
        if (this.nodeType[index] == 1) {
            boolean notCloned;
            if (this.inclusive) {
                notCloned = true;
                boolean notCloned1 = true;
                int x = index + 1;
                while (x < this.size) {
                    if (this.nodeType[x] == 13) {
                        CharArray tempPrefix = this.name[x].localname;
                        if (tempPrefix == null || tempPrefix.length() == 0) {
                            tempPrefix = SignatureContext.DEFAULT;
                        }
                        if (!(namespaces != null && this.stringValue[x].equals(namespaces.get(tempPrefix)) || usedNamespaces != null && this.stringValue[x].equals(usedNamespaces.get(tempPrefix)))) {
                            if (notCloned) {
                                usedNamespaces = usedNamespaces == null ? new Hashtable() : (Hashtable)usedNamespaces.clone();
                                notCloned = false;
                            }
                            usedNamespaces.put(tempPrefix, this.stringValue[x]);
                        }
                        this.domtree[x] = null;
                    } else if (this.nodeType[x] == 2) {
                        QName q1 = this.name[x];
                        if (q1.localname.equals("xmlns")) {
                            if (!(namespaces != null && this.stringValue[x].equals(namespaces.get(SignatureContext.DEFAULT)) || usedNamespaces != null && this.stringValue[x].equals(usedNamespaces.get(SignatureContext.DEFAULT)))) {
                                if (notCloned) {
                                    usedNamespaces = usedNamespaces == null ? new Hashtable() : (Hashtable)usedNamespaces.clone();
                                    notCloned = false;
                                }
                                usedNamespaces.put(SignatureContext.DEFAULT, this.stringValue[x]);
                            }
                            this.domtree[x] = null;
                        }
                        if (SignatureContext.XML.equals(q1.prefix) && (xmlAttributes == null || xmlAttributes.get(q1.localname) == null || !this.stringValue[x].equals(((Attr)xmlAttributes.get(q1.localname)).getNodeValue()))) {
                            if (notCloned1) {
                                xmlAttributes = xmlAttributes == null ? new Hashtable() : (Hashtable)xmlAttributes.clone();
                                notCloned1 = false;
                            }
                            Attr ai = this.doc.createAttributeNS(q1.uri.toString(), q1.rawname.toString());
                            ai.setValue(this.getStringValue(x).toString());
                            xmlAttributes.put(q1.localname, ai);
                            this.domtree[x] = ai;
                        }
                    } else if (this.nodeType[x] != 8) break;
                    this.initialized[x++] = true;
                }
            } else if (this.retain) {
                notCloned = true;
                int x = index + 1;
                while (x < this.size) {
                    if (this.nodeType[x] == 13) {
                        CharArray tempPrefix = this.name[x].localname;
                        if (tempPrefix == null || tempPrefix.length() == 0) {
                            tempPrefix = SignatureContext.DEFAULT;
                        }
                        if (!(namespaces != null && this.stringValue[x].equals(namespaces.get(tempPrefix)) || usedNamespaces != null && this.stringValue[x].equals(usedNamespaces.get(tempPrefix)))) {
                            if (notCloned) {
                                usedNamespaces = usedNamespaces == null ? new Hashtable() : (Hashtable)usedNamespaces.clone();
                                notCloned = false;
                            }
                            usedNamespaces.put(tempPrefix, this.stringValue[x]);
                        }
                        this.domtree[x] = null;
                    } else if (this.nodeType[x] == 2) {
                        QName q1 = this.name[x];
                        if (q1.localname.equals("xmlns")) {
                            if (!(namespaces != null && this.stringValue[x].equals(namespaces.get(SignatureContext.DEFAULT)) || usedNamespaces != null && this.stringValue[x].equals(usedNamespaces.get(SignatureContext.DEFAULT)))) {
                                if (notCloned) {
                                    usedNamespaces = usedNamespaces == null ? new Hashtable() : (Hashtable)usedNamespaces.clone();
                                    notCloned = false;
                                }
                                usedNamespaces.put(SignatureContext.DEFAULT, this.stringValue[x]);
                            }
                            this.domtree[x] = null;
                        }
                    } else if (this.nodeType[x] != 8) break;
                    this.initialized[x++] = true;
                }
            }
            int i1 = this.firstChild[index];
            while (i1 != -1) {
                if (Arrays.binarySearch(this.excluding, i1) < 0) {
                    if (outputAncesstor != null) {
                        outputAncesstor.appendChild(this.subtree(i1, namespaces, usedNamespaces, xmlAttributes));
                    } else {
                        this.subtree(i1, namespaces, usedNamespaces, xmlAttributes);
                    }
                } else {
                    this.subtreeEx(i1, namespaces, outputAncesstor, usedNamespaces, xmlAttributes);
                }
                i1 = this.nextSibling[i1];
            }
        }
        this.domtree[index] = null;
        this.initialized[index] = true;
    }

    public int getDocumentElement(int node) {
        int i = this.documentNodesCount - 1;
        while (i >= 0) {
            int docNode = this.documentNodes[i];
            if (docNode <= node) {
                return docNode;
            }
            --i;
        }
        return 0;
    }

    public int[] getAllElementsWithName(int documentElementId, QName name) {
        int[] lastElements = null;
        if (documentElementId == this.lastDocElID) {
            lastElements = (int[])this.lastElementsTable.get(name);
        } else {
            this.lastElementsTable.clear();
        }
        if (lastElements == null) {
            int[] tmp = new int[this.nodeType.length - documentElementId];
            int tmpSize = 0;
            int i = documentElementId;
            while (i < this.nodeType.length) {
                if (this.nodeType[i] == 1 && this.name[i].equals(name)) {
                    tmp[tmpSize++] = i;
                }
                ++i;
            }
            lastElements = new int[tmpSize];
            System.arraycopy(tmp, 0, lastElements, 0, tmpSize);
            this.lastElementsTable.put(name, lastElements);
            this.lastDocElID = documentElementId;
        }
        return lastElements;
    }
}

