/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xml.dom.AttrImpl;
import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xslt.QName;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DTMDOMBuilder {
    private DTM dtm;
    private boolean[] initialized = null;
    private static final String[] empty = new String[0];
    private boolean[] dangling = null;
    private boolean domInitialized = false;
    private DocumentImpl doc = null;
    private Node frag = null;
    private int danglingLength = 0;
    public Node[] domtree = null;
    private int[] excluding = null;
    private String[] specialPrefixes = null;
    private boolean inclusive = true;
    private Hashtable hiddenXML = new Hashtable();
    private Hashtable ownXMLAttribs = new Hashtable();
    boolean retain = true;

    public DTM getDTM() {
        return this.dtm;
    }

    public void setDTM(DTM dtm) {
        this.dtm = dtm;
    }

    public DTMDOMBuilder(DTM dtm) {
        this.dtm = dtm;
    }

    public Document getDocument() {
        this.initializeDOM();
        return this.doc;
    }

    public Node getFragment() {
        return this.frag;
    }

    public void reinitializeDOM(int[] $excluding) {
        this.reinitializeDOM($excluding, false, empty, false);
    }

    public void reinitializeDOM(int[] $excluding, String[] specialNamespaces) {
        this.reinitializeDOM($excluding, false, specialNamespaces, false);
    }

    public void reinitializeDOM(int[] $excluding, boolean retainParentNamespaces) {
        this.reinitializeDOM($excluding, retainParentNamespaces, null, false);
    }

    public void reinitializeDOM(int[] $excluding, boolean retainParentNamespaces, String[] specialNamespaces) {
        this.reinitializeDOM($excluding, retainParentNamespaces, specialNamespaces, false);
    }

    public void reinitializeDOM(int[] $excluding, boolean retainParentNamespaces, String[] specialNamespaces, boolean $visibleOnly) {
        this.retain = retainParentNamespaces;
        this.doc = new DocumentImpl();
        this.domtree = new Node[this.dtm.size];
        this.dangling = new boolean[this.dtm.size];
        this.initialized = new boolean[this.dtm.size];
        this.excluding = $excluding;
        this.inclusive = !$visibleOnly;
        this.specialPrefixes = specialNamespaces;
        int tempIndex = this.excluding.length == 0 || this.excluding[0] > 0 ? 0 : 1;
        this.danglingLength = 0;
        int i = 1;
        while (i < this.domtree.length) {
            if (tempIndex >= this.excluding.length || i < this.excluding[tempIndex]) {
                this.domtree[i] = this.subtree(i, null, null, null);
                this.dangling[i] = this.isDangling(i, this.excluding);
            } else {
                this.subtreeEx(i, null, null, null, null);
                ++tempIndex;
            }
            ++i;
        }
        i = 1;
        tempIndex = this.excluding.length == 0 || this.excluding[0] > 0 ? 0 : 1;
        boolean found = false;
        i = 1;
        while (i < this.dtm.size) {
            if (tempIndex >= this.excluding.length || i < this.excluding[tempIndex]) {
                found = false;
            } else {
                found = true;
                ++tempIndex;
            }
            if (!found && this.domtree[i] != null && this.domtree[i].getNodeType() == 3) {
                this.dtm.getLeadingText().append(this.dtm.stringValue[i].getData(), this.dtm.stringValue[i].getOffset(), this.dtm.stringValue[i].getSize());
                this.dangling[i] = false;
                --this.danglingLength;
            }
            if (!found) break;
            ++i;
        }
        if (i >= this.domtree.length) {
            return;
        }
        this.frag = this.doc.createDocumentFragment();
        if (this.danglingLength >= 1) {
            int j = i;
            while (j < this.dtm.size) {
                if (this.dangling[j]) {
                    this.frag.appendChild(this.domtree[j]);
                }
                ++j;
            }
        } else {
            this.frag = this.doc;
        }
        this.domtree[0] = this.doc;
        this.domInitialized = true;
    }

    public void initializeDOM() {
        if (!this.domInitialized) {
            this.doc = new DocumentImpl();
            this.domtree = new Node[this.dtm.size];
            this.initialized = new boolean[this.dtm.size];
            this.excluding = new int[0];
            this.specialPrefixes = empty;
            this.inclusive = true;
            int i = 1;
            while (i < this.domtree.length) {
                this.domtree[i] = this.subtree(i, null, null, null);
                ++i;
            }
            i = 1;
            while (i < this.domtree.length && this.domtree[i].getNodeType() == 3) {
                ++i;
            }
            this.doc.appendChild(this.domtree[i]);
            this.domtree[0] = this.doc;
            this.domInitialized = true;
        }
    }

    private boolean isDangling(int node, int[] excludeList) {
        int father = this.dtm.parent[node];
        if (this.dtm.nodeType[father] != 9) {
            if (Arrays.binarySearch(excludeList, father) >= 0) {
                return this.isDangling(father, excludeList);
            }
            return false;
        }
        ++this.danglingLength;
        return true;
    }

    public Node subtree(int index, Hashtable namespaces, Hashtable usedNamespaces, Hashtable xmlAttributes) {
        Node n;
        if (this.initialized[index]) {
            return this.domtree[index];
        }
        switch (this.dtm.nodeType[index]) {
            case 3: {
                n = this.doc.createTextNode(this.dtm.getStringValue(index).toString());
                break;
            }
            case 2: {
                n = this.doc.createAttributeNS(this.dtm.name[index].uri.toString(), this.dtm.name[index].rawname.toString());
                ((AttrImpl)n).setValue(this.dtm.getStringValue(index).toString());
                break;
            }
            case 7: {
                n = this.doc.createProcessingInstruction(this.dtm.name[index].rawname.toString(), this.dtm.getStringValue(index).toString());
                break;
            }
            case 13: {
                n = null;
                break;
            }
            case 8: {
                n = this.doc.createComment(this.dtm.getStringValue(index).toString());
                break;
            }
            case 4: {
                n = this.doc.createCDATASection(this.dtm.getStringValue(index).toString());
                break;
            }
            case 1: {
                Object key;
                Enumeration enum1;
                boolean notCloned1 = true;
                this.hiddenXML.clear();
                this.ownXMLAttribs.clear();
                usedNamespaces = usedNamespaces == null ? new Hashtable() : usedNamespaces;
                n = this.doc.createElementNS(this.dtm.name[index].uri.toString(), this.dtm.name[index].rawname.toString());
                CharArray prefix = this.dtm.name[index].prefix;
                usedNamespaces.put(prefix == null || prefix.length() == 0 ? SignatureContext.DEFAULT : prefix, this.dtm.name[index].uri == null ? CharArray.EMPTY : this.dtm.name[index].uri);
                int x = index + 1;
                int i2 = Arrays.binarySearch(this.excluding, x);
                if (i2 < 0) {
                    i2 ^= 0xFFFFFFFF;
                }
                while (x < this.dtm.size) {
                    Attr ai;
                    QName q1;
                    if (i2 < this.excluding.length && this.excluding[i2] < x) {
                        ++i2;
                        continue;
                    }
                    if (i2 < this.excluding.length && this.excluding[i2] == x) {
                        q1 = this.dtm.name[x];
                        if (this.dtm.nodeType[x] == 2 && SignatureContext.XML.equals(q1.prefix) && this.inclusive) {
                            ai = this.doc.createAttributeNS(q1.uri.toString(), q1.rawname.toString());
                            ai.setValue(this.dtm.getStringValue(x).toString());
                            if (xmlAttributes == null || xmlAttributes.get(q1.localname) == null || !this.dtm.stringValue[x].equals(((Attr)xmlAttributes.get(q1.localname)).getNodeValue())) {
                                if (notCloned1) {
                                    xmlAttributes = xmlAttributes == null ? new Hashtable() : (Hashtable)xmlAttributes.clone();
                                    notCloned1 = false;
                                }
                                xmlAttributes.put(q1.localname, ai);
                            }
                            this.hiddenXML.put(q1.localname, ai);
                        }
                        this.domtree[x] = null;
                        this.initialized[x] = true;
                        ++i2;
                        ++x;
                        continue;
                    }
                    if (this.dtm.nodeType[x] != 2) {
                        if (this.dtm.nodeType[x] == 13) {
                            CharArray tempPrefix = this.dtm.name[x].localname;
                            if (tempPrefix == null || tempPrefix.length() == 0) {
                                tempPrefix = SignatureContext.DEFAULT;
                            }
                            if (this.retain || this.inclusive || this.specialPrefixes != null && Arrays.binarySearch(this.specialPrefixes, tempPrefix.toString()) >= 0) {
                                usedNamespaces.put(tempPrefix, this.dtm.stringValue[x]);
                            }
                        } else {
                            if (this.dtm.nodeType[x] != 8) break;
                            Comment comment = this.doc.createComment(this.dtm.getStringValue(index).toString());
                            ((Element)n).appendChild(comment);
                            this.domtree[x] = comment;
                        }
                    } else {
                        q1 = this.dtm.name[x];
                        if (q1.uri != null) {
                            ai = this.doc.createAttributeNS(q1.uri.toString(), q1.rawname.toString());
                            ai.setValue(this.dtm.getStringValue(x).toString());
                            if (SignatureContext.XML.equals(q1.prefix) && this.inclusive) {
                                if (xmlAttributes == null || xmlAttributes.get(q1.localname) == null || !this.dtm.stringValue[x].equals(((Attr)xmlAttributes.get(q1.localname)).getNodeValue())) {
                                    if (notCloned1) {
                                        xmlAttributes = xmlAttributes == null ? new Hashtable() : (Hashtable)xmlAttributes.clone();
                                        notCloned1 = false;
                                    }
                                    xmlAttributes.put(q1.localname, ai);
                                    this.ownXMLAttribs.put(q1.localname, ai);
                                }
                            } else {
                                ((Element)n).setAttributeNodeNS(ai);
                            }
                            this.domtree[x] = ai;
                            if (q1.prefix != null && q1.prefix.length() != 0) {
                                usedNamespaces.put(q1.prefix, q1.uri);
                            }
                        } else {
                            ai = this.doc.createAttribute(q1.rawname.toString());
                            ai.setValue(this.dtm.getStringValue(x).toString());
                            ((Element)n).setAttributeNode(ai);
                            this.domtree[x] = ai;
                        }
                    }
                    this.initialized[x] = true;
                    ++x;
                }
                Enumeration newNamespaces = usedNamespaces.keys();
                while (newNamespaces.hasMoreElements()) {
                    CharArray nextPrefix = (CharArray)newNamespaces.nextElement();
                    CharArray nextValue = namespaces == null ? null : (CharArray)namespaces.get(nextPrefix);
                    CharArray currentValue = (CharArray)usedNamespaces.get(nextPrefix);
                    if (currentValue.equals(nextValue)) continue;
                    Attr at = SignatureContext.DEFAULT.equals(nextPrefix) ? this.doc.createAttribute("xmlns") : this.doc.createAttribute("xmlns:".concat(nextPrefix.toString()));
                    at.setValue(currentValue.toString());
                    ((Element)n).setAttributeNode(at);
                }
                if (xmlAttributes != null) {
                    Attr atr;
                    if (this.domtree[this.dtm.parent[index]] == null) {
                        enum1 = xmlAttributes.keys();
                        while (enum1.hasMoreElements()) {
                            key = (CharArray)enum1.nextElement();
                            if (this.hiddenXML.containsKey(key)) continue;
                            atr = (Attr)((Attr)xmlAttributes.get(key)).cloneNode(true);
                            ((Element)n).setAttributeNodeNS(atr);
                        }
                    } else {
                        enum1 = this.ownXMLAttribs.keys();
                        while (enum1.hasMoreElements()) {
                            key = (CharArray)enum1.nextElement();
                            atr = (Attr)((Attr)this.ownXMLAttribs.get(key)).cloneNode(true);
                            ((Element)n).setAttributeNodeNS(atr);
                        }
                    }
                }
                if (namespaces != null) {
                    enum1 = namespaces.keys();
                    while (enum1.hasMoreElements()) {
                        key = enum1.nextElement();
                        if (usedNamespaces.get(key) != null) continue;
                        usedNamespaces.put(key, namespaces.get(key));
                    }
                }
                namespaces = usedNamespaces;
                int i1 = this.dtm.firstChild[index];
                this.domtree[index] = n;
                while (i1 != -1) {
                    if (Arrays.binarySearch(this.excluding, i1) < 0) {
                        n.appendChild(this.subtree(i1, namespaces, null, xmlAttributes));
                    } else {
                        this.subtreeEx(i1, namespaces, n, null, xmlAttributes);
                    }
                    i1 = this.dtm.nextSibling[i1];
                }
                break;
            }
            default: {
                return this.doc.createTextNode("");
            }
        }
        this.domtree[index] = n;
        this.initialized[index] = true;
        return n;
    }

    public void subtreeEx(int index, Hashtable namespaces, Node outputAncesstor, Hashtable usedNamespaces, Hashtable xmlAttributes) {
        if (this.dtm.nodeType[index] == 1) {
            boolean notCloned;
            if (this.inclusive) {
                notCloned = true;
                boolean notCloned1 = true;
                int x = index + 1;
                while (x < this.dtm.size) {
                    if (this.dtm.nodeType[x] == 13) {
                        CharArray tempPrefix = this.dtm.name[x].localname;
                        if (tempPrefix == null || tempPrefix.length() == 0) {
                            tempPrefix = SignatureContext.DEFAULT;
                        }
                        if (!(namespaces != null && this.dtm.stringValue[x].equals(namespaces.get(tempPrefix)) || usedNamespaces != null && this.dtm.stringValue[x].equals(usedNamespaces.get(tempPrefix)))) {
                            if (notCloned) {
                                usedNamespaces = usedNamespaces == null ? new Hashtable() : (Hashtable)usedNamespaces.clone();
                                notCloned = false;
                            }
                            usedNamespaces.put(tempPrefix, this.dtm.stringValue[x]);
                        }
                        this.domtree[x] = null;
                    } else if (this.dtm.nodeType[x] == 2) {
                        QName q1 = this.dtm.name[x];
                        if (q1.localname.equals("xmlns")) {
                            if (!(namespaces != null && this.dtm.stringValue[x].equals(namespaces.get(SignatureContext.DEFAULT)) || usedNamespaces != null && this.dtm.stringValue[x].equals(usedNamespaces.get(SignatureContext.DEFAULT)))) {
                                if (notCloned) {
                                    usedNamespaces = usedNamespaces == null ? new Hashtable() : (Hashtable)usedNamespaces.clone();
                                    notCloned = false;
                                }
                                usedNamespaces.put(SignatureContext.DEFAULT, this.dtm.stringValue[x]);
                            }
                            this.domtree[x] = null;
                        }
                        if (SignatureContext.XML.equals(q1.prefix) && (xmlAttributes == null || xmlAttributes.get(q1.localname) == null || !this.dtm.stringValue[x].equals(((Attr)xmlAttributes.get(q1.localname)).getNodeValue()))) {
                            if (notCloned1) {
                                xmlAttributes = xmlAttributes == null ? new Hashtable() : (Hashtable)xmlAttributes.clone();
                                notCloned1 = false;
                            }
                            Attr ai = this.doc.createAttributeNS(q1.uri.toString(), q1.rawname.toString());
                            ai.setValue(this.dtm.getStringValue(x).toString());
                            xmlAttributes.put(q1.localname, ai);
                            this.domtree[x] = ai;
                        }
                    } else if (this.dtm.nodeType[x] != 8) break;
                    this.initialized[x++] = true;
                }
            } else if (this.retain) {
                notCloned = true;
                int x = index + 1;
                while (x < this.dtm.size) {
                    if (this.dtm.nodeType[x] == 13) {
                        CharArray tempPrefix = this.dtm.name[x].localname;
                        if (tempPrefix == null || tempPrefix.length() == 0) {
                            tempPrefix = SignatureContext.DEFAULT;
                        }
                        if (!(namespaces != null && this.dtm.stringValue[x].equals(namespaces.get(tempPrefix)) || usedNamespaces != null && this.dtm.stringValue[x].equals(usedNamespaces.get(tempPrefix)))) {
                            if (notCloned) {
                                usedNamespaces = usedNamespaces == null ? new Hashtable() : (Hashtable)usedNamespaces.clone();
                                notCloned = false;
                            }
                            usedNamespaces.put(tempPrefix, this.dtm.stringValue[x]);
                        }
                        this.domtree[x] = null;
                    } else if (this.dtm.nodeType[x] == 2) {
                        QName q1 = this.dtm.name[x];
                        if (q1.localname.equals("xmlns")) {
                            if (!(namespaces != null && this.dtm.stringValue[x].equals(namespaces.get(SignatureContext.DEFAULT)) || usedNamespaces != null && this.dtm.stringValue[x].equals(usedNamespaces.get(SignatureContext.DEFAULT)))) {
                                if (notCloned) {
                                    usedNamespaces = usedNamespaces == null ? new Hashtable() : (Hashtable)usedNamespaces.clone();
                                    notCloned = false;
                                }
                                usedNamespaces.put(SignatureContext.DEFAULT, this.dtm.stringValue[x]);
                            }
                            this.domtree[x] = null;
                        }
                    } else if (this.dtm.nodeType[x] != 8) break;
                    this.initialized[x++] = true;
                }
            }
            int i1 = this.dtm.firstChild[index];
            while (i1 != -1) {
                if (Arrays.binarySearch(this.excluding, i1) < 0) {
                    if (outputAncesstor != null) {
                        outputAncesstor.appendChild(this.subtree(i1, namespaces, usedNamespaces, xmlAttributes));
                    } else {
                        this.subtree(i1, namespaces, usedNamespaces, xmlAttributes);
                    }
                } else {
                    this.subtreeEx(i1, namespaces, outputAncesstor, usedNamespaces, xmlAttributes);
                }
                i1 = this.dtm.nextSibling[i1];
            }
        }
        this.domtree[index] = null;
        this.initialized[index] = true;
    }
}

