/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.Symbols;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XJavaObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.QName;
import java.util.Vector;

public final class ETFunction
implements ETItem {
    protected QName name;
    protected ETItem[] arguments;
    protected XObject[] argumentsToSend;
    protected XFunction xf = null;
    protected boolean isExtensionFunction = false;
    private static final ETItem[] EMPTY_ETITEM_ARRAY = new ETItem[0];

    protected ETFunction(QName name) {
        this.name = name;
        this.checkForExtensionFunction();
        this.arguments = new ETItem[0];
        this.argumentsToSend = new XObject[0];
    }

    protected ETFunction(QName name, ETItem a1) {
        this.name = name;
        this.checkForExtensionFunction();
        this.arguments = new ETItem[1];
        this.argumentsToSend = new XObject[1];
        this.arguments[0] = a1;
    }

    protected ETFunction(QName name, ETItem a1, ETItem a2) {
        this.name = name;
        this.checkForExtensionFunction();
        this.arguments = new ETItem[2];
        this.argumentsToSend = new XObject[2];
        this.arguments[0] = a1;
        this.arguments[1] = a2;
    }

    protected ETFunction(QName name, Vector argumentsVector) {
        this.name = name;
        this.checkForExtensionFunction();
        this.arguments = argumentsVector.toArray(EMPTY_ETITEM_ARRAY);
        this.argumentsToSend = new XObject[this.arguments.length];
    }

    @Override
    public String toString() {
        return "ETFunction('" + this.name + "' with " + this.arguments.length + " arguments)";
    }

    @Override
    public void print(int indent) {
        Symbols.printSpace(indent);
        int i = 0;
        while (i < this.arguments.length) {
            this.arguments[i].print(indent + 1);
            ++i;
        }
    }

    @Override
    public XObject evaluate(XPathContext context) throws XPathException {
        int i = 0;
        while (i < this.arguments.length) {
            this.argumentsToSend[i] = this.arguments[i].evaluate(context);
            if (this.argumentsToSend[i].getType() == 6) {
                ((XJavaObject)this.argumentsToSend[i]).setContext(context);
            }
            ++i;
        }
        if (this.xf == null) {
            this.xf = context.library.getFunction(this.name);
            if (this.xf == null) {
                throw new XPathException("Function with name '" + this.name + "' not found in context library.");
            }
        }
        if (!this.xf.confirmArgumentTypes(this.argumentsToSend)) {
            throw new XPathException("Illegal number of arguments or types of arguments in a call of function '" + this.name + "'.");
        }
        XObject xx = this.xf.execute(this.argumentsToSend, context);
        int i2 = 0;
        while (i2 < this.arguments.length) {
            if (xx != this.argumentsToSend[i2] && this.argumentsToSend[i2] != this.arguments[i2]) {
                context.getXFactCurrent().releaseXObject(this.argumentsToSend[i2]);
            }
            ++i2;
        }
        return xx;
    }

    @Override
    public boolean match(XPathContext context) throws XPathException {
        throw new XPathException("A Function cannot be matched in a Template Match Pattern.");
    }

    public XFunction getFunction() {
        return this.xf;
    }

    public QName getName() {
        return this.name;
    }

    public ETItem getArg(int idx) {
        return this.arguments[idx];
    }

    private void checkForExtensionFunction() {
        this.isExtensionFunction = this.name.uri.length() > 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ETFunction)) {
            return false;
        }
        ETFunction e = (ETFunction)o;
        if (e.name.equals(this.name) && e.arguments.length == this.arguments.length) {
            int i = 0;
            while (i < this.arguments.length) {
                if (!e.arguments[i].equals(this.arguments[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Not implemented for usage in hash-based collections");
    }
}

