/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import java.util.Hashtable;

public final class HashtableAsList
extends Hashtable {
    private int n = 0;
    private Object[] keys;
    private Object[] values;
    private int[] hashCodes;

    public HashtableAsList() {
        this(10);
    }

    public HashtableAsList(int l) {
        this.keys = new Object[l];
        this.values = new Object[l];
        this.hashCodes = new int[l];
    }

    @Override
    public Object put(Object k, Object v) {
        if (this.n == this.keys.length) {
            this.resize();
        }
        this.keys[this.n] = k;
        this.values[this.n] = v;
        this.hashCodes[this.n] = k.hashCode();
        ++this.n;
        return null;
    }

    @Override
    public boolean contains(Object o) {
        return this.containsKey(o);
    }

    @Override
    public boolean containsKey(Object k) {
        int h = k.hashCode();
        int i = 0;
        while (i < this.n) {
            if (this.hashCodes[i] == h && this.keys[i].equals(k)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object v) {
        int i = 0;
        while (i < this.n) {
            if (this.values[i].equals(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object get(Object k) {
        int h = k.hashCode();
        int i = 0;
        while (i < this.n) {
            if (this.hashCodes[i] == h && this.keys[i].equals(k)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    private void resize() {
        Object[] keysOld = this.keys;
        Object[] valuesOld = this.values;
        int[] hashCodesOld = this.hashCodes;
        int l = this.keys.length;
        this.keys = new Object[l * 2];
        this.values = new Object[l * 2];
        this.hashCodes = new int[l * 2];
        System.arraycopy(keysOld, 0, this.keys, 0, l);
        System.arraycopy(valuesOld, 0, this.values, 0, l);
        System.arraycopy(hashCodesOld, 0, this.hashCodes, 0, l);
    }
}

