/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.log.LogWriter;

public final class Symbols {
    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isInitialCharForQName(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_';
    }

    public static boolean isCharForQName(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '-' || ch == '.' || ch >= '0' && ch <= '9';
    }

    public static boolean isQName(String s) {
        if (!Symbols.isInitialCharForQName(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Symbols.isCharForQName(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t';
    }

    public static void printSpace(int n) {
        int i = 0;
        while (i < n) {
            LogWriter.getSystemLogWriter().print("  ");
            ++i;
        }
    }

    public static String trimWhitespace(String s) {
        if (s == null) {
            return null;
        }
        if (s.equals("")) {
            return s;
        }
        int l = s.length();
        int i = 0;
        while (i < l && Symbols.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i < l) {
            int j = l - 1;
            while (j >= 0 && Symbols.isWhitespace(s.charAt(j))) {
                --j;
            }
            return s.substring(i, j + 1);
        }
        return "";
    }
}

