/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.ETLocationStep;
import com.sap.engine.lib.xsl.xpath.ETObject;
import com.sap.engine.lib.xsl.xpath.ETPredicate;
import com.sap.engine.lib.xsl.xpath.ETSlash;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.VariableContext;
import org.w3c.dom.Document;

public class XPathProcessor {
    protected CharArray key = new CharArray();
    public DTM dtm;

    public XPathProcessor() {
    }

    public XPathProcessor(DTM dtm) {
        this.reuse(dtm);
    }

    public void reuse(DTM dtm) {
        this.dtm = dtm;
    }

    public XObject process(ETObject query, XPathContext context) throws XPathException {
        context.globalCurrentNode = context.node;
        context.setXFactProcess();
        XObject x = this.innerProcess(query, context);
        return x;
    }

    public XObject process(ETObject query, XPathContext context, VariableContext vc) throws XPathException {
        context.variableBindings = vc;
        vc.useXPathContext(context);
        return this.process(query, context);
    }

    private XObject innerProcess(ETObject q, XPathContext c) throws XPathException {
        try {
            return q.et.evaluate(c);
        }
        catch (NullPointerException e) {
            throw new XPathException("Error parsing query", e);
        }
    }

    public XObject process(ETObject query) throws XPathException {
        return this.process(query, this.dtm.getInitialContext());
    }

    public void init(Document doc) throws XPathException {
        throw new XPathException("Initializing the XPath processor through DOM is not supported.");
    }

    public DTM getDTM() {
        return this.dtm;
    }

    protected CharArray makeKey(XPathContext x, CharArray query, String mode) {
        this.key.reuse();
        this.key.set(query);
        this.key.append('[');
        this.key.append('[');
        this.key.appendInteger(x.node);
        this.key.append('[');
        this.key.append('[');
        this.key.append(mode);
        return this.key;
    }

    private int isSubset(ETObject root, ETObject child) throws XPathException {
        if (root == null) {
            return -1;
        }
        if (root.et instanceof ETSlash) {
            ETSlash et1 = (ETSlash)root.et;
            if (et1.left instanceof ETSlash) {
                ETSlash et2 = (ETSlash)et1.left;
                if (et2.isUnary && et2.right instanceof ETLocationStep && ((ETLocationStep)et2.right).axisType == 1003 && child.et instanceof ETPredicate) {
                    if (et1.right.equals(child.et)) {
                        return 1;
                    }
                    return 0;
                }
            }
        }
        return -1;
    }

    public boolean match(ETObject eo, XPathContext context0, String mode, ETObject select) throws XPathException {
        if (eo.squery.equals("/")) {
            return context0.node == 0;
        }
        if (eo.squery.equals("*|/")) {
            return context0.node == 0 || context0.dtm.nodeType[context0.node] == 1;
        }
        switch (this.isSubset(select, eo)) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
            case -1: {
                break;
            }
        }
        return eo.et.match(context0);
    }

    public void initializeProcess() {
    }

    public void finalizeLocal() {
    }
}

