/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.functions;

import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XJavaObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XObjectFactory;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;
import java.lang.reflect.Method;

public class BSFFunction
implements XFunction {
    private static String bsfEngine = "com.ibm.bsf.BSFEngine";
    private static Class bsfEngineClass = null;
    private Object bsfEngineObject = null;
    private String functionName = null;

    static {
        try {
            bsfEngineClass = Class.forName(bsfEngine);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public BSFFunction(Object eng, String name) {
        this.bsfEngineObject = eng;
        this.functionName = name;
    }

    @Override
    public boolean confirmArgumentTypes(XObject[] o) {
        return true;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public XObject execute(XObject[] arr, XPathContext ctx) throws XPathException {
        if (arr.length < 1) {
            throw new XPathException("At least one argument required!");
        }
        try {
            Object[] obs = this.prepareArguments(arr);
            XObjectFactory fact = ctx.getXFactCurrent();
            Object[] args = new Object[obs.length - 1];
            if (obs.length > 1) {
                System.arraycopy(obs, 1, args, 0, obs.length - 1);
            }
            Object toReturn = null;
            if (bsfEngineClass == null) {
                throw new XPathException("Could not initialize BSF Class. Perhaps the BSF Library is not in classpath");
            }
            Method callMethod = bsfEngineClass.getMethod("call", Class.forName("java.lang.Object"), Class.forName("java.lang.String"), new Object[0].getClass());
            toReturn = callMethod.invoke(this.bsfEngineObject, obs[0], this.functionName, args);
            return fact.getXJavaObject(toReturn);
        }
        catch (Exception e) {
            throw new XPathException(e);
        }
    }

    private Object[] prepareArguments(XObject[] arr) throws XPathException {
        int length = arr.length;
        Object[] result = new Object[length];
        int i = 0;
        while (i < length) {
            if (arr[i] == null) {
                result[i] = null;
            } else {
                switch (arr[i].getType()) {
                    case 3: {
                        result[i] = new Boolean(((XBoolean)arr[i]).getValue());
                        break;
                    }
                    case 2: {
                        result[i] = ((XString)arr[i]).getValue();
                        break;
                    }
                    case 1: {
                        result[i] = new Double(((XNumber)arr[i]).getValue());
                        break;
                    }
                    case 6: {
                        result[i] = ((XJavaObject)arr[i]).getObject();
                        break;
                    }
                    default: {
                        throw new XPathException("Argument type not supported!");
                    }
                }
            }
            ++i;
        }
        return result;
    }
}

