/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.functions;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.IntArrayIterator;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;

public abstract class ComparisonOperator
implements XFunction {
    public final boolean R(int x) throws XPathException {
        return false;
    }

    public abstract boolean requiresNumbers() throws XPathException;

    @Override
    public abstract String getFunctionName();

    protected abstract boolean rStrings(CharArray var1, CharArray var2);

    protected abstract boolean rDoubles(double var1, double var3);

    protected abstract boolean rBooleans(boolean var1, boolean var2);

    @Override
    public final XObject execute(XObject[] a, XPathContext context) throws XPathException {
        XNumber a0xn;
        XObject a0 = a[0];
        XObject a1 = a[1];
        if (a0.getType() == 4 && a1.getType() == 4) {
            IntArrayIterator i0 = ((XNodeSet)a0).iterator();
            while (i0.hasNext()) {
                CharArray s0 = context.dtm.getStringValue(i0.next());
                IntArrayIterator i1 = ((XNodeSet)a1).iterator();
                while (i1.hasNext()) {
                    CharArray s1 = context.dtm.getStringValue(i1.next());
                    if (ComparisonOperator.isDouble(s0) && ComparisonOperator.isDouble(s1)) {
                        try {
                            double d1 = Double.parseDouble(new String(s0.getChars()));
                            double d2 = Double.parseDouble(new String(s1.getChars()));
                            if (!this.rDoubles(d1, d2)) continue;
                            i0.close();
                            i1.close();
                            return context.getXFactCurrent().getXBoolean(true);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!this.rStrings(s0, s1)) continue;
                            i0.close();
                            i1.close();
                            return context.getXFactCurrent().getXBoolean(true);
                        }
                    }
                    if (!this.rStrings(s0, s1)) continue;
                    i0.close();
                    i1.close();
                    return context.getXFactCurrent().getXBoolean(true);
                }
            }
            i0.close();
            return context.getXFactCurrent().getXBoolean(false);
        }
        boolean swapped = false;
        if (a1.getType() == 4) {
            XObject h = a0;
            a0 = a1;
            a1 = h;
            swapped = true;
        }
        if (a0.getType() == 4) {
            if (a1.getType() == 1) {
                double d1 = ((XNumber)a1).getValue();
                IntArrayIterator i = ((XNodeSet)a0).iterator();
                while (i.hasNext()) {
                    XString xs = context.getXFactCurrent().getXString(context.dtm.getStringValue(i.next()));
                    XNumber xn = context.getXFactCurrent().getXNumber(xs);
                    double d0 = xn.getValue();
                    xs.close();
                    xn.close();
                    if (!(swapped ? this.rDoubles(d1, d0) : this.rDoubles(d0, d1))) continue;
                    i.close();
                    return context.getXFactCurrent().getXBoolean(true);
                }
                return context.getXFactCurrent().getXBoolean(false);
            }
            if (a1.getType() == 2) {
                CharArray s1 = ((XString)a1).getValue();
                IntArrayIterator i = ((XNodeSet)a0).iterator();
                while (i.hasNext()) {
                    int ii = i.next();
                    CharArray s0 = context.dtm.getStringValue(ii);
                    if (s0 == null) {
                        s0 = CharArray.EMPTY;
                    }
                    if (!(swapped ? this.rStrings(s1, s0) : this.rStrings(s0, s1))) continue;
                    i.close();
                    return context.getXFactCurrent().getXBoolean(true);
                }
                return context.getXFactCurrent().getXBoolean(false);
            }
            if (a1.getType() == 3) {
                boolean b0 = context.getXFactCurrent().getXBoolean((XNodeSet)a0).getValue();
                boolean b1 = ((XBoolean)a1).getValue();
                return context.getXFactCurrent().getXBoolean(swapped ? this.rBooleans(b1, b0) : this.rBooleans(b0, b1));
            }
        }
        if (this.requiresNumbers()) {
            a0xn = a0.toXNumber();
            XNumber a1xn = a1.toXNumber();
            double d0 = a0xn.getValue();
            double d1 = a1xn.getValue();
            if (a0xn != a0) {
                a0xn.close();
            }
            if (a1xn != a1) {
                a1xn.close();
            }
            return context.getXFactCurrent().getXBoolean(this.rDoubles(d0, d1));
        }
        if (a0.getType() == 3 || a1.getType() == 3) {
            boolean b0 = a0.toXBoolean().getValue();
            boolean b1 = a1.toXBoolean().getValue();
            return context.getXFactCurrent().getXBoolean(this.rBooleans(b0, b1));
        }
        if (a0.getType() == 1 || a1.getType() == 1) {
            a0xn = a0.toXNumber();
            XNumber a1xn = a1.toXNumber();
            double d0 = a0xn.getValue();
            double d1 = a1xn.getValue();
            if (a0xn != a0) {
                a0xn.close();
            }
            if (a1xn != a1) {
                a1xn.close();
            }
            return context.getXFactCurrent().getXBoolean(this.rDoubles(d0, d1));
        }
        XString a0xs = a0.toXString();
        XString a1xs = a1.toXString();
        CharArray s0 = a0xs.getValue();
        CharArray s1 = a1xs.getValue();
        try {
            XBoolean xBoolean = context.getXFactCurrent().getXBoolean(this.rStrings(s0, s1));
            return xBoolean;
        }
        finally {
            if (a0xs != a0) {
                a0xs.close();
            }
            if (a1xs != a1) {
                a1xs.close();
            }
        }
    }

    @Override
    public final boolean confirmArgumentTypes(XObject[] a) {
        return a.length == 2;
    }

    private static boolean isDouble(CharArray ch) {
        boolean hasDot;
        if (ch == null || ch.getSize() == 0) {
            return false;
        }
        char c = ch.charAt(0);
        if (c != '+' && c != '-' && c != '.' && !Character.isDigit(c)) {
            return false;
        }
        boolean bl = hasDot = c == '.';
        if (!Character.isDigit(c) && ch.getSize() == 1) {
            return false;
        }
        int i = 1;
        while (i < ch.getSize()) {
            c = ch.charAt(i);
            if (c == '.') {
                if (hasDot) {
                    return false;
                }
                hasDot = true;
            } else if (!Character.isDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

