/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.functions;

import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.IntArrayIterator;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;

public final class XFDump
implements XFunction {
    private StringBuffer buffer = new StringBuffer(100);
    private int[] temp = null;
    private int nTemp;
    private DTM dtm;

    public static String toString(DTM dtm, XObject xo) throws XPathException {
        return new XFDump().execute(new XObject[]{xo}, dtm.getInitialContext()).toString();
    }

    @Override
    public synchronized XObject execute(XObject[] a, XPathContext context) throws XPathException {
        int t = a[0].getType();
        if (t != 4) {
            XString r = a[0].toXString();
            return r;
        }
        this.dtm = context.dtm;
        XNodeSet xns = (XNodeSet)a[0];
        DTM cfr_ignored_0 = xns.dtm;
        if (this.temp == null) {
            this.temp = new int[100];
        }
        this.buffer.setLength(0);
        this.buffer.append("{\n");
        IntArrayIterator i = xns.sensitiveIterator();
        while (i.hasNext()) {
            int x = i.next();
            this.buffer.append("  ");
            if (x != 0) {
                this.pathTo(x);
            } else {
                this.buffer.append("/");
            }
            this.buffer.append('\n');
        }
        this.buffer.append("}");
        return context.getXFactCurrent().getXString(this.buffer.toString());
    }

    private void pathTo(int x) {
        String name;
        if (x == -1) {
            return;
        }
        if (x == 0) {
            return;
        }
        byte t = this.dtm.nodeType[x];
        int p = this.dtm.parent[x];
        try {
            name = this.dtm.name[x].rawname.getString();
        }
        catch (NullPointerException nullPointerException) {
            name = "";
        }
        if (t == 2) {
            this.pathTo(p);
            this.buffer.append("/@").append(name);
        } else if (t == 1) {
            this.pathTo(p);
            this.buffer.append("/").append(name);
        } else if (t == 8) {
            this.pathTo(p);
            this.buffer.append("/comment()");
        } else if (t == 7) {
            this.pathTo(p);
            this.buffer.append("/processing-instruction('").append(name).append("')");
        } else if (t == 3) {
            this.pathTo(p);
            this.buffer.append("/text()");
        } else {
            this.pathTo(p);
            this.buffer.append("/?");
        }
        int countSiblings = 0;
        int countPrecedingSiblings = 0;
        int y = this.dtm.previousSibling[x];
        while (y != -1) {
            try {
                if (name.equals(this.dtm.name[y].rawname.getString())) {
                    ++countSiblings;
                    ++countPrecedingSiblings;
                }
            }
            catch (NullPointerException nullPointerException) {}
            y = this.dtm.previousSibling[y];
        }
        y = this.dtm.nextSibling[x];
        while (y != -1) {
            try {
                if (name.equals(this.dtm.name[y].rawname.getString())) {
                    ++countSiblings;
                }
            }
            catch (NullPointerException nullPointerException) {}
            y = this.dtm.nextSibling[y];
        }
        if (countSiblings != 0) {
            this.buffer.append('[').append(countPrecedingSiblings + 1).append(']');
        }
    }

    @Override
    public boolean confirmArgumentTypes(XObject[] a) {
        return a.length == 1;
    }

    @Override
    public String getFunctionName() {
        return "dump";
    }
}

