/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.functions;

import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;

public final class XFOperatorMod
implements XFunction {
    @Override
    public XObject execute(XObject[] a, XPathContext context) throws XPathException {
        XNumber xa0 = a[0].toXNumber();
        XNumber xa1 = a[1].toXNumber();
        try {
            double a0 = xa0.getValue();
            double a1 = xa1.getValue();
            int sgn_a0 = a0 < 0.0 ? -1 : 1;
            a0 = Math.abs(a0);
            a1 = Math.abs(a1);
            XNumber xNumber = context.getXFactCurrent().getXNumber((a0 - Math.floor(a0 / a1) * a1) * (double)sgn_a0);
            return xNumber;
        }
        finally {
            if (xa0 != a[0]) {
                xa0.close();
            }
            if (xa1 != a[1]) {
                xa1.close();
            }
        }
    }

    @Override
    public boolean confirmArgumentTypes(XObject[] a) {
        return a.length == 2;
    }

    @Override
    public String getFunctionName() {
        return "mod";
    }
}

