/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.functions;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;

public final class XFStartsWith
implements XFunction {
    @Override
    public boolean confirmArgumentTypes(XObject[] a) {
        return a.length == 2;
    }

    @Override
    public XObject execute(XObject[] a, XPathContext context) throws XPathException {
        XString a0xs = a[0].toXString();
        XString a1xs = a[1].toXString();
        CharArray s0 = a0xs.getValue();
        CharArray s1 = a1xs.getValue();
        try {
            XBoolean xBoolean = context.getXFactCurrent().getXBoolean(s0.startsWith(s1));
            return xBoolean;
        }
        finally {
            if (a0xs != a[0]) {
                a0xs.close();
            }
            if (a1xs != a[1]) {
                a1xs.close();
            }
        }
    }

    @Override
    public String getFunctionName() {
        return "starts-with";
    }
}

