/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.functions;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;

public final class XFSubstring
implements XFunction {
    @Override
    public boolean confirmArgumentTypes(XObject[] a) {
        return a.length == 2 || a.length == 3;
    }

    @Override
    public XObject execute(XObject[] a, XPathContext context) throws XPathException {
        try {
            XString a0xs = a[0].toXString();
            XNumber a1xn = a[1].toXNumber();
            CharArray s = a0xs.getValue();
            int pStart = (int)a1xn.getValue();
            if (--pStart < 0) {
                pStart = 0;
            }
            if (a.length == 3) {
                XNumber a2xn = a[2].toXNumber();
                int sLength = (int)a2xn.getValue();
                XString ret = context.getXFactCurrent().getXString(s, pStart, pStart + sLength);
                if (a0xs != a[0]) {
                    a0xs.close();
                }
                if (a1xn != a[1]) {
                    a1xn.close();
                }
                if (a2xn != a[2]) {
                    a2xn.close();
                }
                return ret;
            }
            XString ret = context.getXFactCurrent().getXString(s, pStart, s.getSize());
            if (a0xs != a[0]) {
                a0xs.close();
            }
            if (a1xn != a[1]) {
                a1xn.close();
            }
            return ret;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return context.getXFactCurrent().getXStringEmpty();
        }
    }

    @Override
    public String getFunctionName() {
        return "substring";
    }
}

