/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.xobjects;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.Symbols;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.IntArrayIterator;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;
import com.sap.engine.lib.xsl.xslt.QName;
import java.util.Arrays;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XNodeSet
extends XObject
implements ETItem {
    public static final int TYPE = 4;
    private static final int INITIAL_SIZE = 16;
    public static final String AXIS_ANCESTOR = "ancestor";
    public static final String AXIS_ANCESTOR_OR_SELF = "ancestor-or-self";
    public static final String AXIS_ATTRIBUTE = "attribute";
    public static final String AXIS_CHILD = "child";
    public static final String AXIS_DESCEDANT = "descendant";
    public static final String AXIS_DESCEDANT_OR_SELF = "descendant-or-self";
    public static final String AXIS_FOLLOWING = "following";
    public static final String AXIS_FOLLOWING_SIBLING = "following-sibling";
    public static final String AXIS_NAMESPACE = "namespace";
    public static final String AXIS_PARENT = "parent";
    public static final String AXIS_PRECEDING = "preceding";
    public static final String AXIS_PRECEDING_SIBLING = "preceding-sibling";
    public static final String AXIS_SELF = "self";
    public static final CharArray NT_NODE = new CharArray("node");
    public static final CharArray NT_ELEMENT = new CharArray("element");
    public static final CharArray NT_ATTRIBUTE = new CharArray("attribute");
    public static final CharArray NT_TEXT = new CharArray("text");
    public static final CharArray NT_PROCESSING_INSTRUCTION = new CharArray("processing-instruction");
    public static final CharArray NT_COMMENT = new CharArray("comment");
    public static final CharArray NT_ALL = new CharArray("*");
    private static final Hashtable HASHTABLE = new Hashtable();
    public DTM dtm;
    private XPathContext xcont = null;
    private int RESIZE_STEP = 32;
    private int[] value = new int[16];
    private int n = 0;
    private boolean forward;
    private IntArrayIterator it = null;
    private CharArray fxres = null;

    static {
        HASHTABLE.put(new CharArray(NT_NODE), new Integer(100));
        HASHTABLE.put(new CharArray(NT_ELEMENT), new Integer(1));
        HASHTABLE.put(new CharArray(NT_ATTRIBUTE), new Integer(2));
        HASHTABLE.put(new CharArray(NT_PROCESSING_INSTRUCTION), new Integer(7));
        HASHTABLE.put(new CharArray(NT_TEXT), new Integer(3));
        HASHTABLE.put(new CharArray(NT_COMMENT), new Integer(8));
    }

    @Override
    public int getType() {
        return 4;
    }

    protected XNodeSet reuse(DTM dtm) {
        this.dtm = dtm;
        this.forward = true;
        this.n = 0;
        return this;
    }

    protected XNodeSet reuse(DTM dtm, int x) {
        this.dtm = dtm;
        this.forward = true;
        this.value[0] = x;
        this.n = 1;
        return this;
    }

    protected XNodeSet reuse(XNodeSet xns) {
        this.dtm = xns.dtm;
        this.n = xns.n;
        this.forward = xns.forward;
        this.ensureCapacity(xns.n);
        System.arraycopy(xns.value, 0, this.value, 0, this.n);
        return this;
    }

    public XNodeSet reuse(XPathContext xcont, String axis, QName nodeTest) throws XPathException {
        int s;
        int a;
        int y;
        DTM dtm = xcont.dtm;
        int x = xcont.node;
        this.xcont = xcont;
        this.dtm = dtm;
        int t = 1;
        String piTarget = null;
        this.n = 0;
        if (nodeTest.localname.charAt(nodeTest.localname.length() - 1) == ')') {
            int indexOfOpeningBracket = 0;
            this.factory.chXNodeSetInst.clear();
            int i = 0;
            while (i < nodeTest.localname.length() && nodeTest.localname.charAt(i) != '(') {
                ++indexOfOpeningBracket;
                this.factory.chXNodeSetInst.append(nodeTest.localname.charAt(i));
                ++i;
            }
            Integer tmp = (Integer)HASHTABLE.get(this.factory.chXNodeSetInst);
            if (tmp == null) {
                throw new XPathException("Node-test not recognized, '" + nodeTest + "'.");
            }
            t = tmp;
            if (t == 7 && indexOfOpeningBracket < nodeTest.localname.length() - 3) {
                piTarget = nodeTest.localname.getString().substring(indexOfOpeningBracket + 2, nodeTest.localname.length() - 2);
            }
            nodeTest = null;
        }
        if (axis.equals(AXIS_CHILD)) {
            int c = dtm.firstChild[x];
            while (c != -1) {
                if (this.checkNodeTypeAndNameOf(c, t, nodeTest, piTarget)) {
                    this.add(c);
                }
                c = dtm.nextSibling[c];
            }
            this.forward = true;
        } else if (axis.equals(AXIS_SELF)) {
            if (this.checkNodeTypeAndNameOf(x, t, nodeTest, piTarget)) {
                this.add(x);
            }
            this.forward = true;
        } else if (axis.equals(AXIS_PRECEDING)) {
            if (x > 1) {
                if (nodeTest != null && nodeTest.localname.charAt(0) != '*') {
                    int[] elements = dtm.getAllElementsWithName(dtm.getDocumentElement(x), nodeTest);
                    int i = 0;
                    while (i < elements.length) {
                        int element = elements[i];
                        if (element < x) {
                            this.add(element);
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else {
                    y = dtm.getDocumentElement(x);
                    while (y < x) {
                        if (this.checkNodeTypeAndNameOf(y, t, nodeTest, piTarget)) {
                            this.add(y);
                        }
                        ++y;
                    }
                }
                this.markAncestors(x);
                this.markNamespaceAndAttributeNodes();
                this.compact();
            }
            this.forward = false;
            this.revert();
        } else if (axis.equals(AXIS_FOLLOWING)) {
            if (x < dtm.size) {
                y = x + 1;
                while (y < dtm.size) {
                    if (this.checkNodeTypeAndNameOf(y, t, nodeTest, piTarget)) {
                        this.add(y);
                    }
                    ++y;
                }
                this.markDescendantsAndSelf(x);
                this.markNamespaceAndAttributeNodes();
                this.compact();
            }
            this.forward = true;
        } else if (axis.equals(AXIS_PARENT)) {
            int p = dtm.parent[x];
            if (p != -1 && this.checkNodeTypeAndNameOf(p, t, nodeTest, piTarget)) {
                this.add(p);
            }
            this.forward = false;
            this.revert();
        } else if (axis.equals(AXIS_DESCEDANT_OR_SELF)) {
            this.addDescendantsAndSelf(x, t, nodeTest, piTarget);
            this.forward = true;
        } else if (axis.equals(AXIS_DESCEDANT)) {
            this.addDescendantsAndSelf(x, t, nodeTest, piTarget);
            this.remove(x);
            this.forward = true;
        } else if (axis.equals(AXIS_ATTRIBUTE)) {
            t = 2;
            if (dtm.nodeType[x] == 1) {
                a = dtm.firstAttr[x];
                while (a > -1 && a < dtm.size && (dtm.nodeType[a] == 2 || dtm.nodeType[a] == 13)) {
                    if (this.checkNodeTypeAndNameOf(a, t, nodeTest, piTarget)) {
                        this.add(a);
                    }
                    if (a <= -1) continue;
                    a = dtm.nextSibling[a];
                }
            } else {
                byte cfr_ignored_0 = dtm.nodeType[x];
            }
            this.forward = true;
        } else if (axis.equals(AXIS_ANCESTOR)) {
            a = dtm.parent[x];
            while (a != -1) {
                if (this.checkNodeTypeAndNameOf(a, t, nodeTest, piTarget)) {
                    this.add(a);
                }
                a = dtm.parent[a];
            }
            this.forward = false;
            this.revert();
        } else if (axis.equals(AXIS_ANCESTOR_OR_SELF)) {
            a = x;
            while (a != -1) {
                if (this.checkNodeTypeAndNameOf(a, t, nodeTest, piTarget)) {
                    this.add(a);
                }
                a = dtm.parent[a];
            }
            this.forward = false;
            this.revert();
        } else if (axis.equals(AXIS_PRECEDING_SIBLING)) {
            s = dtm.previousSibling[x];
            while (s != -1) {
                if (this.checkNodeTypeAndNameOf(s, t, nodeTest, piTarget)) {
                    this.add(s);
                }
                s = dtm.previousSibling[s];
            }
            this.forward = false;
            this.revert();
        } else if (axis.equals(AXIS_FOLLOWING_SIBLING)) {
            s = dtm.nextSibling[x];
            while (s != -1) {
                if (this.checkNodeTypeAndNameOf(s, t, nodeTest, piTarget)) {
                    this.add(s);
                }
                s = dtm.nextSibling[s];
            }
            this.forward = true;
        } else if (axis.equals(AXIS_NAMESPACE)) {
            this.addNamespaces(x, nodeTest, piTarget);
        } else {
            throw new XPathException("Unknown axis, '" + axis + "::'.");
        }
        return this;
    }

    private void addNamespaces(int element, QName nodeTest, String piTarget) {
        if (this.dtm.nodeType[element] == 1) {
            int a = element + 1;
            while (a < this.dtm.size && (this.dtm.nodeType[a] == 2 || this.dtm.nodeType[a] == 13)) {
                if (this.checkNodeTypeAndNameOf(a, 13, nodeTest, piTarget)) {
                    this.add(a);
                }
                ++a;
            }
            int parentElement = this.dtm.parent[element];
            if (parentElement >= 0) {
                this.addNamespaces(parentElement, nodeTest, piTarget);
            }
        }
    }

    private boolean checkNodeTypeAndNameOf(int x, int t, QName name, String piTarget) {
        if (t == 3) {
            if (this.xcont == null) {
                this.xcont = this.dtm.getInitialContext();
            }
            if (this.xcont.owner != null && this.xcont.owner.doStripWhiteSpaceNode(this.xcont, x)) {
                return false;
            }
        }
        if (t != 100) {
            if (this.dtm.nodeType[x] != t) {
                return false;
            }
            if (t == 7 && piTarget != null && !this.dtm.name[x].localname.equals(piTarget)) {
                return false;
            }
        }
        if (name == null) {
            return true;
        }
        if (name.localname.charAt(0) == '*') {
            return name.prefix.equals("") || this.dtm.name[x].uri.equals(name.uri);
        }
        return this.dtm.name[x].localname.equals(name.localname) && this.dtm.name[x].uri.equals(name.uri);
    }

    private int findLastDescendant(int p) {
        int x = p;
        while (this.dtm.firstChild[p] != -1) {
            p = this.dtm.firstChild[p];
            while (p != -1) {
                x = p;
                p = this.dtm.nextSibling[p];
            }
            p = x;
        }
        return p;
    }

    private void addDescendantsAndSelf(int x, int t, QName name, String piTarget) {
        int lastDescendant = this.findLastDescendant(x);
        if (t == 100 && name == null) {
            this.ensureCapacity(lastDescendant - x + 100);
        }
        while (x <= lastDescendant) {
            if (this.checkNodeTypeAndNameOf(x, t, name, piTarget)) {
                this.add(x);
            }
            ++x;
        }
    }

    private void markDescendantsAndSelf(int x) {
        this.mark(x);
        int c = this.dtm.firstChild[x];
        while (c != -1) {
            this.markDescendantsAndSelf(c);
            c = this.dtm.nextSibling[c];
        }
    }

    private void markAncestors(int x) {
        int q = this.n - 1;
        int a = this.dtm.parent[x];
        while (a != -1) {
            while (true) {
                if (q < 0) {
                    return;
                }
                if (this.value[q] <= a) {
                    if (this.value[q] != a) break;
                    this.value[q] = -1;
                    break;
                }
                --q;
            }
            this.mark(a);
            a = this.dtm.parent[a];
        }
    }

    private void markNamespaceAndAttributeNodes() {
        int i = 0;
        while (i < this.n) {
            byte t;
            if (this.value[i] != -1 && ((t = this.dtm.nodeType[this.value[i]]) == 13 || t == 2)) {
                this.value[i] = -1;
            }
            ++i;
        }
    }

    public void uniteWith(XNodeSet xns) {
        this.uniteWithNoSort(xns);
        Arrays.sort(this.value, 0, this.n);
    }

    public void uniteWithNoSort(XNodeSet xns) {
        if (xns.n == 0) {
            return;
        }
        int size = this.n;
        int xnsSize = xns.n;
        int[] xnsValue = xns.value;
        if (this.value.length < size + xnsSize) {
            int[] newValue = new int[size + xnsSize];
            System.arraycopy(this.value, 0, newValue, 0, size);
            this.value = newValue;
        }
        this.n = size;
        int i = 0;
        while (i < xnsSize) {
            int v = xnsValue[i];
            boolean found = false;
            int j = 0;
            while (j < size) {
                if (this.value[j] == v) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.value[this.n++] = v;
            }
            ++i;
        }
    }

    public void add(int x) {
        this.ensureCapacity(this.n + 1);
        this.value[this.n] = x;
        ++this.n;
    }

    public void addInterval(int x, int y) {
        this.ensureCapacity(this.n + y - x + 1);
        int i = x;
        while (i <= y) {
            this.value[this.n] = i++;
            ++this.n;
        }
    }

    public void mark(int x) {
        int i = 0;
        while (i < this.n) {
            if (this.value[i] == x) {
                this.value[i] = -1;
                return;
            }
            ++i;
        }
    }

    public void remove(int x) {
        int i = 0;
        while (i < this.n) {
            if (this.value[i] == x) {
                --this.n;
                int j = i;
                while (j < this.n) {
                    this.value[j] = this.value[j + 1];
                    ++j;
                }
                return;
            }
            ++i;
        }
    }

    public void clear() {
        this.n = 0;
    }

    public IntArrayIterator sensitiveIterator() {
        return this.forward ? this.iterator() : this.backIterator();
    }

    public IntArrayIterator iterator() {
        this.ensureIterator();
        this.it.init(this.value, 0, this.n, 1);
        return this.it;
    }

    public IntArrayIterator backIterator() {
        this.ensureIterator();
        this.it.init(this.value, this.n - 1, -1, -1);
        return this.it;
    }

    public boolean isEmpty() {
        return this.n == 0;
    }

    public boolean contains(int x) {
        int i = 0;
        while (i < this.n) {
            if (x == this.value[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int count() {
        return this.n;
    }

    @Override
    public String toString() {
        StringBuffer r = new StringBuffer();
        r.append("[ ");
        int i = 0;
        while (i < this.n) {
            r.append(this.value[i]).append(' ');
            ++i;
        }
        r.append("]");
        return r.toString();
    }

    @Override
    public void print(int indent) {
        Symbols.printSpace(indent);
    }

    @Override
    public XObject evaluate(XPathContext context) {
        return this.factory.getXNodeSet(this);
    }

    public int firstInDocumentOrder() {
        return this.n == 0 ? -1 : this.value[0];
    }

    public int size() {
        return this.n;
    }

    public int getKth(int k) {
        return this.forward ? this.value[k - 1] : this.value[this.n - k];
    }

    public int[] getNodes(int[] nodes, int start) {
        if (nodes.length < start + this.n + 1) {
            int[] nodesOld = nodes;
            nodes = new int[start + this.n + 1];
            System.arraycopy(nodesOld, 0, nodes, 0, nodesOld.length);
        }
        System.arraycopy(this.value, 0, nodes, start, this.n);
        nodes[start + this.n] = -1;
        return nodes;
    }

    public CharArray fullStringValue() {
        if (this.n == 0) {
            return CharArray.EMPTY;
        }
        if (this.fxres == null) {
            this.fxres = new CharArray();
        } else {
            this.fxres.clear();
        }
        int i = 0;
        while (i < this.n) {
            this.fxres.append(this.dtm.getStringValue(this.value[i]));
            ++i;
        }
        return this.fxres;
    }

    public CharArray stringValue() {
        if (this.n == 0) {
            return CharArray.EMPTY;
        }
        return this.dtm.getStringValue(this.value[0]);
    }

    public void stringValue(CharArray ca) {
        if (this.n == 0) {
            ca.set(CharArray.EMPTY);
            return;
        }
        ca.clear();
        this.dtm.appendStringValue(this.value[0], ca);
    }

    @Override
    public boolean match(XPathContext c) throws XPathException {
        throw new XPathException(this.getClass() + " cannot be matched.");
    }

    @Override
    public XNumber toXNumber() throws XPathException {
        return this.factory.getXNumber(this);
    }

    @Override
    public XString toXString() throws XPathException {
        return this.factory.getXString(this);
    }

    public XString toFullXString() throws XPathException {
        return this.factory.getFullXString(this);
    }

    @Override
    public XBoolean toXBoolean() throws XPathException {
        return this.factory.getXBoolean(this);
    }

    @Override
    public XNodeSet toXNodeSet() throws XPathException {
        return this;
    }

    public boolean isForward() {
        return this.forward;
    }

    public void setForward(boolean b) {
        this.forward = b;
    }

    private void ensureCapacity(int x) {
        if (this.value.length < x) {
            if (x > this.RESIZE_STEP) {
                this.RESIZE_STEP = x + 50;
            }
            int[] valueOld = this.value;
            this.value = new int[this.RESIZE_STEP];
            System.arraycopy(valueOld, 0, this.value, 0, valueOld.length);
            this.RESIZE_STEP *= 2;
        }
    }

    private void ensureIterator() {
        if (this.it == null) {
            this.it = new IntArrayIterator();
        }
    }

    private void revert() {
        int i = 0;
        int j = this.n - 1;
        while (i < j) {
            int h = this.value[i];
            this.value[i] = this.value[j];
            this.value[j] = h;
            ++i;
            --j;
        }
    }

    public void compact() {
        int j = 0;
        int i = 0;
        while (i < this.n) {
            if (this.value[i] != -1) {
                this.value[j++] = this.value[i];
            }
            ++i;
        }
        this.n = j;
    }

    public void mark(IntArrayIterator i) {
        this.value[i.getCurrentPosition()] = -1;
    }

    public void sort() {
        Arrays.sort(this.value, 0, this.n);
    }

    public static int[] getAncestry(DTM dtm, int i) {
        if (dtm.parent[i] < 0) {
            return new int[1];
        }
        int count = 0;
        int temp = i;
        while (dtm.previousSibling[temp] >= 0) {
            temp = dtm.previousSibling[temp];
            ++count;
        }
        int[] upperBranch = XNodeSet.getAncestry(dtm, dtm.parent[i]);
        int[] result = new int[upperBranch.length + 1];
        System.arraycopy(upperBranch, 0, result, 0, upperBranch.length);
        result[result.length - 1] = count;
        return result;
    }

    public static int[] getAncestry(Node n) {
        Node parent = n.getParentNode();
        if (parent == null) {
            return new int[1];
        }
        int count = 0;
        Node temp = n;
        while (temp.getPreviousSibling() != null) {
            temp = temp.getPreviousSibling();
            ++count;
        }
        int[] upperBranch = XNodeSet.getAncestry(parent);
        int[] result = new int[upperBranch.length + 1];
        System.arraycopy(upperBranch, 0, result, 0, upperBranch.length);
        result[result.length - 1] = count;
        return result;
    }

    public static int getNodeFromAncestry(DTM dtm, int[] ancestry) {
        int rootNode = 0;
        int depth = ancestry.length;
        int next = rootNode;
        int i = 0;
        while (i < depth - 1) {
            int j = 0;
            while (j < ancestry[i]) {
                next = dtm.nextSibling[next];
                ++j;
            }
            next = dtm.firstChild[next];
            ++i;
        }
        if (ancestry.length > 0) {
            i = 0;
            while (i < ancestry[ancestry.length - 1]) {
                next = dtm.nextSibling[next];
                ++i;
            }
        }
        return next;
    }

    public static Node getNodeFromAncestry(Document doc, int[] ancestry) {
        Document rootNode = doc;
        int depth = ancestry.length;
        Node next = rootNode;
        int i = 0;
        while (i < depth - 1) {
            int j = 0;
            while (j < ancestry[i]) {
                next = next.getNextSibling();
                ++j;
            }
            next = next.getFirstChild();
            ++i;
        }
        if (ancestry.length > 0) {
            i = 0;
            while (i < ancestry[ancestry.length - 1]) {
                next = next.getNextSibling();
                ++i;
            }
        }
        return next;
    }
}

