/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.xobjects;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.Symbols;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XObjectFactory;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;

public final class XNumber
extends XObject
implements ETItem,
XFunction {
    public static final int TYPE = 1;
    protected double value;

    @Override
    public int getType() {
        return 1;
    }

    public double getValue() {
        return this.value;
    }

    protected XNumber reuse() {
        this.value = Double.NaN;
        return this;
    }

    protected XNumber reuse(double v) {
        this.value = v;
        return this;
    }

    protected XNumber reuse(XNumber xn) {
        this.value = xn.value;
        return this;
    }

    private void initWithCharArray(CharArray ca) {
        if (ca == null || ca.length() == 0) {
            this.value = Double.NaN;
        } else {
            char ch = ca.charAt(ca.length() - 1);
            if (ch == 'f' || ch == 'd' || ch == 'F' || ch == 'D') {
                this.value = Double.NaN;
            } else {
                try {
                    this.value = Double.parseDouble(new String(ca.getChars()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.value = Double.NaN;
                }
            }
        }
    }

    private void initWithXString(XString xs) {
        this.initWithCharArray(xs.value);
    }

    public XNumber reuse(XString xs) {
        this.initWithXString(xs);
        return this;
    }

    public XNumber reuse(XBoolean xb) {
        this.value = xb.value ? 1.0 : 0.0;
        return this;
    }

    public XNumber reuse(XNodeSet xns) {
        this.initWithCharArray(xns.stringValue());
        return this;
    }

    @Override
    public XNumber toXNumber() {
        return this;
    }

    @Override
    public XString toXString() {
        return this.factory.getXString(this);
    }

    @Override
    public XBoolean toXBoolean() {
        return this.factory.getXBoolean(this);
    }

    @Override
    public XObject evaluate(XPathContext context) {
        return this;
    }

    @Override
    public void print(int indent) {
        Symbols.printSpace(indent);
        LogWriter.getSystemLogWriter().println("XNumber(" + this.value + ")");
    }

    @Override
    public XObject execute(XObject[] a, XPathContext context) throws XPathException {
        if (a.length == 0) {
            XObjectFactory f = context.getXFactCurrent();
            return f.getXNumber(f.getXString(context.dtm.getStringValue(context.node)));
        }
        return a[0].toXNumber();
    }

    @Override
    public boolean confirmArgumentTypes(XObject[] a) {
        return a.length <= 1;
    }

    @Override
    public String getFunctionName() {
        return "number";
    }

    @Override
    public boolean match(XPathContext c) throws XPathException {
        throw new XPathException(this.getClass() + " cannot be matched.");
    }

    @Override
    public String toString() {
        return Double.toString(this.value);
    }
}

