/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.xobjects;

import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XJavaObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObjectFactory;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;
import com.sap.engine.lib.xsl.xslt.XSLApplyTemplates;
import com.sap.engine.lib.xsl.xslt.XSLCallTemplate;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLTemplate;
import java.util.Stack;

public abstract class XObject
implements ETItem {
    protected boolean isClosed = false;
    protected boolean isConstant = false;
    protected XObjectFactory factory = null;
    private boolean isTopVariableValue = false;
    private Stack parents = new Stack();

    public abstract int getType();

    public XNumber toXNumber() throws XPathException {
        throw new XPathException("Illegal conversion");
    }

    public XString toXString() throws XPathException {
        throw new XPathException("Illegal conversion");
    }

    public XBoolean toXBoolean() throws XPathException {
        throw new XPathException("Illegal conversion");
    }

    public XNodeSet toXNodeSet() throws XPathException {
        throw new XPathException("Illegal conversion");
    }

    public XJavaObject toXJavaObject() throws XPathException {
        throw new XPathException("Illegal conversion");
    }

    protected final boolean getClosed() {
        return this.isClosed;
    }

    public final XObject setClosed(boolean v) {
        this.isClosed = v;
        return this;
    }

    public final void close() throws XPathException {
        this.factory.releaseXObject(this);
    }

    public final XObjectFactory getParentFact() {
        return this.factory;
    }

    public final XObject setParentFact(XObjectFactory factory) {
        this.factory = factory;
        this.reset();
        return this;
    }

    public XSLNode getParentDeclared() {
        if (this.parents.isEmpty()) {
            return null;
        }
        return (XSLNode)this.parents.peek();
    }

    public void setParentDeclared(XSLNode parent) {
        this.parents.push(parent);
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public void setTopVariableValue(boolean isTopVariableValue) {
        this.isTopVariableValue = isTopVariableValue;
    }

    public boolean isTopVariableValue() {
        return this.isTopVariableValue;
    }

    public void closeAndRelease(XSLNode closingParent) throws XPathException {
        XSLTemplate templateDeclared;
        if (this.isConstant || this.isTopVariableValue) {
            return;
        }
        if (this.parents.isEmpty()) {
            return;
        }
        XSLNode parent = (XSLNode)this.parents.peek();
        if (parent instanceof XSLApplyTemplates || parent instanceof XSLCallTemplate ? closingParent != parent : (templateDeclared = parent.getTemplate()) == null || templateDeclared != closingParent) {
            return;
        }
        this.parents.pop();
        if (this.parents.isEmpty()) {
            this.setClosed(false);
            this.close();
        }
    }

    public XObject setConstant() {
        this.setClosed(true);
        this.isConstant = true;
        return this;
    }

    public void reset() {
        this.parents.clear();
        this.isTopVariableValue = false;
    }
}

