/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.xobjects;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.StaticInteger;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XJavaObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;
import com.sap.engine.lib.xsl.xslt.pool.ObjectPool;

public final class XObjectFactory {
    private ObjectPool xNodeSetPool = null;
    private ObjectPool xNumberPool = null;
    private ObjectPool xStringPool = null;
    private ObjectPool xJavaPool = null;
    private ObjectPool xNodeSetOverflow = null;
    private ObjectPool xNumberOverflow = null;
    private ObjectPool xStringOverflow = null;
    private ObjectPool xJavaOverflow = null;
    private XBoolean XBOOLEAN_TRUE;
    private XBoolean XBOOLEAN_FALSE;
    private XNumber XNUMBER_MINUS_ONE;
    private static final int XNUMBER_SMALL_LIMIT = 10;
    private XNumber[] XNUMBER_SMALL;
    private XString XSTRING_EMPTY;
    protected CharArray chXNodeSetInst = new CharArray(10);
    protected StaticInteger staticInteger = new StaticInteger();

    public XObjectFactory(int initsize) {
        this.xNodeSetPool = new ObjectPool(XNodeSet.class, initsize, initsize);
        this.xNumberPool = new ObjectPool(XNumber.class, initsize, initsize);
        this.xStringPool = new ObjectPool(XString.class, initsize, initsize);
        this.xJavaPool = new ObjectPool(XJavaObject.class, initsize, initsize);
        this.xNodeSetOverflow = new ObjectPool(XNodeSet.class, initsize, initsize);
        this.xNumberOverflow = new ObjectPool(XNumber.class, initsize, initsize);
        this.xStringOverflow = new ObjectPool(XString.class, initsize, initsize);
        this.xJavaOverflow = new ObjectPool(XJavaObject.class, initsize, initsize);
        this.initConstants();
        this.xNodeSetOverflow.setPos(-1);
        this.xNumberOverflow.setPos(-1);
        this.xStringOverflow.setPos(-1);
        this.xJavaOverflow.setPos(-1);
    }

    private void initConstants() {
        this.XBOOLEAN_TRUE = new XBoolean();
        this.XBOOLEAN_TRUE.setParentFact(this);
        this.XBOOLEAN_TRUE.setClosed(true);
        this.XBOOLEAN_TRUE.value = true;
        this.XBOOLEAN_TRUE.isConstant = true;
        this.XBOOLEAN_FALSE = new XBoolean();
        this.XBOOLEAN_FALSE.setParentFact(this);
        this.XBOOLEAN_FALSE.setClosed(true);
        this.XBOOLEAN_FALSE.value = false;
        this.XBOOLEAN_FALSE.isConstant = true;
        this.XNUMBER_MINUS_ONE = new XNumber();
        this.XNUMBER_MINUS_ONE.setParentFact(this);
        this.XNUMBER_MINUS_ONE.setClosed(true);
        this.XNUMBER_MINUS_ONE.value = -1.0;
        this.XNUMBER_MINUS_ONE.isConstant = true;
        this.XNUMBER_SMALL = new XNumber[10];
        int i = 0;
        while (i < 10) {
            this.XNUMBER_SMALL[i] = new XNumber();
            this.XNUMBER_SMALL[i].setParentFact(this);
            this.XNUMBER_SMALL[i].setClosed(true);
            this.XNUMBER_SMALL[i].value = i;
            this.XNUMBER_SMALL[i].isConstant = true;
            ++i;
        }
        this.XSTRING_EMPTY = new XString();
        this.XSTRING_EMPTY.setParentFact(this);
        this.XSTRING_EMPTY.setClosed(true);
        this.XSTRING_EMPTY.value = CharArray.EMPTY;
        this.XSTRING_EMPTY.isConstant = true;
    }

    public XNumber getXNumber() {
        return this.XNUMBER_SMALL[0];
    }

    public XNumber getXNumber(int x) {
        if (x == -1) {
            return this.XNUMBER_MINUS_ONE;
        }
        if (x >= 0 && x < 10) {
            return this.XNUMBER_SMALL[x];
        }
        return this.produceXNumber().reuse(x);
    }

    public XNumber getXNumber(double x) {
        if (x == (double)((int)x)) {
            return this.getXNumber((int)x);
        }
        return this.produceXNumber().reuse(x);
    }

    public XNumber getXNumber(XBoolean xb) {
        return xb.value ? this.XNUMBER_SMALL[1] : this.XNUMBER_SMALL[0];
    }

    public XNumber getXNumber(XString xs) {
        char ch;
        if (xs.value.length() == 1 && (ch = xs.value.charAt(0)) >= '\u0000' && ch <= '\t') {
            return this.getXNumber(ch - 48);
        }
        return this.produceXNumber().reuse(xs);
    }

    public XNumber getXNumber(XNodeSet xns) {
        return this.produceXNumber().reuse(xns);
    }

    public XString getXString() {
        return this.produceXString().reuse();
    }

    public XString getXString(String s) {
        if (s.length() == 0) {
            return this.XSTRING_EMPTY;
        }
        return this.produceXString().reuse(s);
    }

    public XString getXString(CharArray ca) {
        if (ca.length() == 0) {
            return this.XSTRING_EMPTY;
        }
        return this.produceXString().reuse(ca);
    }

    public XString getXString(CharArray ca, int b, int e) {
        if (b == e) {
            return this.XSTRING_EMPTY;
        }
        return this.produceXString().reuse(ca, b, e);
    }

    public XString getXString(XNumber xn) {
        return this.produceXString().reuse(xn);
    }

    public XString getXString(XBoolean xb) {
        return this.produceXString().reuse(xb);
    }

    public XString getXString(XNodeSet xns) {
        return this.produceXString().reuse(xns);
    }

    public XString getFullXString(XNodeSet xns) {
        return this.produceXString().reuseFull(xns);
    }

    public XString getXStringEmpty() {
        return this.XSTRING_EMPTY;
    }

    public XBoolean getXBoolean() {
        return this.XBOOLEAN_FALSE;
    }

    public XBoolean getXBoolean(boolean b) {
        return b ? this.XBOOLEAN_TRUE : this.XBOOLEAN_FALSE;
    }

    public XBoolean getXBoolean(XNumber xn) {
        return xn.value == 0.0 || Double.isNaN(xn.value) ? this.XBOOLEAN_FALSE : this.XBOOLEAN_TRUE;
    }

    public XBoolean getXBoolean(XString xs) {
        return xs.value.length() == 0 ? this.XBOOLEAN_FALSE : this.XBOOLEAN_TRUE;
    }

    public XBoolean getXBoolean(XBoolean xb) {
        return xb;
    }

    public XBoolean getXBoolean(XNodeSet xns) {
        return xns.isEmpty() ? this.XBOOLEAN_FALSE : this.XBOOLEAN_TRUE;
    }

    public XNodeSet getXNodeSet() {
        return this.produceXNodeSet();
    }

    public XNodeSet getXNodeSet(XNodeSet xns) {
        return this.produceXNodeSet().reuse(xns);
    }

    public XNodeSet getXNodeSet(DTM dtm, int a) {
        return this.produceXNodeSet().reuse(dtm, a);
    }

    public XNodeSet getXNodeSet(DTM dtm) {
        return this.produceXNodeSet().reuse(dtm);
    }

    public XJavaObject getXJavaObject(Object o) {
        return this.produceXJavaObject().reuse(o);
    }

    public void releaseXObject(XObject obj) {
        if (!obj.getClosed()) {
            obj.setClosed(true);
            int t = obj.getType();
            if (t == 2) {
                this.xStringOverflow.releaseObject((XString)obj);
            } else if (t == 1) {
                this.xNumberOverflow.releaseObject((XNumber)obj);
            } else if (t == 4) {
                this.xNodeSetOverflow.releaseObject((XNodeSet)obj);
            } else if (t == 6) {
                this.xJavaOverflow.releaseObject((XJavaObject)obj);
            }
        }
    }

    public void releaseXNodeSet() {
        this.xNodeSetPool.releaseAllObjects();
    }

    public void releaseOthers() {
        this.xNumberPool.releaseAllObjects();
        this.xStringPool.releaseAllObjects();
    }

    public void releaseAllPools() {
        this.xNodeSetPool.releaseAllObjects();
        this.xNumberPool.releaseAllObjects();
        this.xStringPool.releaseAllObjects();
        this.xJavaPool.releaseAllObjects();
        this.xNodeSetOverflow.setPos(-1);
        this.xNumberOverflow.setPos(-1);
        this.xStringOverflow.setPos(-1);
        this.xJavaOverflow.setPos(-1);
    }

    private XNumber produceXNumber() {
        if (this.xNumberOverflow.getPos() > -1) {
            return (XNumber)((XObject)this.xNumberOverflow.getObject()).setClosed(false).setParentFact(this);
        }
        return (XNumber)((XObject)this.xNumberPool.getObject()).setClosed(false).setParentFact(this);
    }

    private XString produceXString() {
        if (this.xStringOverflow.getPos() > -1) {
            return (XString)((XObject)this.xStringOverflow.getObject()).setClosed(false).setParentFact(this);
        }
        return (XString)((XObject)this.xStringPool.getObject()).setClosed(false).setParentFact(this);
    }

    private XNodeSet produceXNodeSet() {
        if (this.xNodeSetOverflow.getPos() > -1) {
            return (XNodeSet)((XNodeSet)this.xNodeSetOverflow.getObject()).setClosed(false).setParentFact(this);
        }
        return (XNodeSet)((XObject)this.xNodeSetPool.getObject()).setClosed(false).setParentFact(this);
    }

    private XJavaObject produceXJavaObject() {
        if (this.xJavaOverflow.getPos() > -1) {
            return (XJavaObject)((XJavaObject)this.xJavaOverflow.getObject()).setClosed(false).setParentFact(this);
        }
        return (XJavaObject)((XObject)this.xJavaPool.getObject()).setClosed(false).setParentFact(this);
    }
}

