/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.xobjects;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.Symbols;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;

public final class XString
extends XObject
implements ETItem,
XFunction {
    public static final int TYPE = 2;
    protected CharArray value = new CharArray(20);

    @Override
    public int getType() {
        return 2;
    }

    public CharArray getValue() {
        return this.value;
    }

    protected XString reuse() {
        this.value.clear();
        return this;
    }

    protected XString reuse(String v) {
        this.value.set(v);
        return this;
    }

    protected XString reuse(CharArray v, int b, int e) {
        this.value.set(v, b, e);
        return this;
    }

    protected XString reuse(CharArray v) {
        this.value.set(v);
        return this;
    }

    protected XString reuse(XNumber xn) {
        if (Double.isNaN(xn.value)) {
            this.value.set("NaN");
            return this;
        }
        if (xn.value == 0.0 || xn.value == -0.0) {
            this.value.set("0");
            return this;
        }
        if (xn.value == Double.POSITIVE_INFINITY) {
            this.value.set("Infinity");
            return this;
        }
        if (xn.value == Double.NEGATIVE_INFINITY) {
            this.value.set("-Infinity");
            return this;
        }
        if (xn.value == (double)((int)xn.value)) {
            this.factory.staticInteger.intToCharArray((int)xn.value, this.value);
        } else {
            String strVal = Double.toString(xn.value);
            this.value.set(strVal.toCharArray());
        }
        return this;
    }

    protected XString reuse(XBoolean xb) {
        this.value.set(xb.value ? "true" : "false");
        return this;
    }

    protected XString reuse(XNodeSet xns) {
        xns.stringValue(this.value);
        return this;
    }

    protected XString reuseFull(XNodeSet xns) {
        CharArray v = xns.fullStringValue();
        if (v == null) {
            v = CharArray.EMPTY;
        }
        this.value.set(v);
        return this;
    }

    @Override
    public XNumber toXNumber() throws XPathException {
        return this.factory.getXNumber(this);
    }

    @Override
    public XString toXString() throws XPathException {
        return this;
    }

    @Override
    public XBoolean toXBoolean() throws XPathException {
        return this.factory.getXBoolean(this);
    }

    @Override
    public XObject evaluate(XPathContext context) {
        return this;
    }

    @Override
    public void print(int indent) {
        Symbols.printSpace(indent);
        LogWriter.getSystemLogWriter().println("XString(" + this.value + ")");
    }

    @Override
    public XObject execute(XObject[] a, XPathContext context) throws XPathException {
        if (a.length == 0) {
            return context.getXFactCurrent().getXString(context.dtm.getStringValue(context.node));
        }
        return a[0].toXString();
    }

    @Override
    public boolean confirmArgumentTypes(XObject[] a) {
        return a.length <= 1;
    }

    @Override
    public String getFunctionName() {
        return "string";
    }

    @Override
    public String toString() {
        return this.value.getString();
    }

    @Override
    public boolean match(XPathContext c) throws XPathException {
        throw new XPathException(this.getClass() + " cannot be matched.");
    }

    public boolean equals(Object o) {
        if (!(o instanceof XString)) {
            return false;
        }
        XString x = (XString)o;
        return x.value.equals(this.value);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Not implemented for usage in hash-based collections");
    }
}

