/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;

public final class QName {
    public CharArray rawname = new CharArray();
    public CharArray localname = new CharArray();
    public CharArray prefix = new CharArray();
    public CharArray uri = null;
    public int uriId = -1;

    public QName reuse(QName q) {
        this.rawname.set(q.rawname);
        this.localname.set(q.localname);
        this.prefix.set(q.prefix);
        this.uri = q.uri;
        this.uriId = q.uriId;
        return this;
    }

    public QName reuse(CharArray ch, CharArray uri, int uriId) {
        this.reuse(ch);
        this.uri = uri;
        this.uriId = uriId;
        return this;
    }

    public void initFromRawname() {
        this.localname.clear();
        this.prefix.clear();
        int sep = this.rawname.indexOfColon();
        if (sep == -1) {
            sep = 0;
        }
        this.prefix.substring(this.rawname, 0, sep);
        if (sep > 0) {
            ++sep;
        }
        this.localname.substring(this.rawname, sep);
    }

    public QName reuse(CharArray ch) {
        this.rawname.set(ch);
        this.initFromRawname();
        return this;
    }

    public QName reuse(String ch, CharArray uri, int uriId) {
        this.reuse(ch);
        this.uri = uri;
        this.uriId = uriId;
        return this;
    }

    public QName reuse(String ch) {
        this.rawname.set(ch);
        this.initFromRawname();
        return this;
    }

    public void setURI(String u, NamespaceManager nsmanager) {
        this.uriId = nsmanager.put(u);
        this.uri = nsmanager.get(this.uriId);
    }

    public void setURI(CharArray u, NamespaceManager nsmanager) {
        this.uriId = nsmanager.put(u);
        this.uri = nsmanager.get(this.uriId);
    }

    public CharArray getRawName() {
        return this.rawname;
    }

    public CharArray getlocalname() {
        return this.localname;
    }

    public CharArray getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.rawname.getString();
    }

    public String print() {
        return "rawname=" + this.rawname + " prefix=" + this.prefix + " localname=" + this.localname + " uri=" + this.uri;
    }

    public boolean equals(Object o) {
        if (o instanceof QName) {
            QName q = (QName)o;
            if (q.localname == this.localname && q.prefix == this.prefix && q.rawname == this.rawname && q.uri == this.uri) {
                return true;
            }
            if (q.localname.equals(this.localname) && q.uri.equals(this.uri)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = this.rawname.hashCode() + 1;
        result *= this.localname.hashCode() + 1;
        return result *= this.prefix.hashCode() + 1;
    }
}

