/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xslt.AttributeValueTemplateHandler;
import com.sap.engine.lib.xsl.xslt.QName;
import com.sap.engine.lib.xsl.xslt.XSLContentNode;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import org.w3c.dom.Element;

public final class XSLAttribute
extends XSLContentNode {
    private CharArray value = new CharArray(20);
    private boolean bInsideValue = false;
    private boolean bProcessByElement = false;
    private QName instQName = new QName();
    private AttributeValueTemplateHandler nameTemplate = new AttributeValueTemplateHandler();
    private AttributeValueTemplateHandler valueTemplate = new AttributeValueTemplateHandler();
    private AttributeValueTemplateHandler namespaceTemplate = new AttributeValueTemplateHandler();
    public static final String[] REQPAR = new String[]{"name"};
    public static final String[] OPTPAR = new String[]{"namespace"};

    public XSLAttribute(XSLStylesheet owner, XSLNode parent) throws XSLException {
        super(owner, parent);
    }

    public XSLAttribute(XSLStylesheet owner, XSLNode parent, Element el) throws XSLException {
        super(owner, parent, el);
        this.instQName.rawname.set(el.getNodeName());
        this.instQName.rawname.trim();
        this.instQName.uri = new CharArray();
        this.instQName.uri.set(el.getNamespaceURI());
        this.instQName.uri.trim();
        if (el.getNamespaceURI() != null && el.getNamespaceURI().equals("http://www.w3.org/1999/XSL/Transform") && el.getLocalName() != null && el.getLocalName().equals("attribute")) {
            this.instQName.rawname.set(el.getAttribute("name"));
            this.instQName.rawname.trim();
            if (el.getAttribute("namespace").length() > 0) {
                this.instQName.uri.set(el.getAttribute("namespace"));
                this.instQName.uri.trim();
            } else {
                this.instQName.uri.clear();
            }
            this.nameTemplate.init(this.instQName.rawname, owner.etBuilder);
            this.namespaceTemplate.init(this.instQName.uri, owner.etBuilder);
            if (this.nameTemplate.countTokens() == 1 && this.instQName.rawname.indexOf(':') > -1) {
                String sname = this.instQName.rawname.toString();
                String prf = sname.substring(0, sname.indexOf(58));
                if (this.namespaceTemplate.countTokens() == 0) {
                    this.namespaceTemplate.init(owner.getNamespaceHandler().get(new CharArray(prf)), owner.etBuilder);
                }
            }
        }
    }

    public XSLAttribute(XSLStylesheet owner, XSLNode parent, Object uri, Object name, String value) throws XSLException {
        super(owner, parent, null);
        if (name instanceof CharArray) {
            this.instQName.rawname.set((CharArray)name);
        } else if (name instanceof String) {
            this.instQName.rawname.set((String)name);
        } else {
            throw new IllegalArgumentException("name must be either CharArray or String");
        }
        this.instQName.uri = new CharArray();
        if (uri instanceof CharArray) {
            this.instQName.uri.set((CharArray)uri);
        } else if (uri instanceof String) {
            this.instQName.uri.set((String)uri);
        } else if (uri == null) {
            this.instQName.uri.clear();
        } else {
            throw new IllegalArgumentException("uri must be either CharArray or String");
        }
        this.nameTemplate.init(this.instQName.rawname, owner.etBuilder);
        this.namespaceTemplate.init(this.instQName.uri, owner.etBuilder);
        this.bInsideValue = true;
        this.valueTemplate.init(new CharArray(value), owner.etBuilder);
    }

    public CharArray getName() {
        return this.instQName.rawname;
    }

    public QName getQName() {
        return this.instQName;
    }

    public CharArray getValue() throws XSLException {
        return this.value;
    }

    public CharArray getNamespaceURI() {
        return this.instQName.uri;
    }

    public void setProcessByElement() {
        this.bProcessByElement = true;
    }

    public void clearProcessByElement() {
        this.bProcessByElement = false;
    }

    @Override
    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        this.nameTemplate.processTo(this.instQName.rawname, this.owner.getXPathProcessor(), xcont, this.varContext);
        this.namespaceTemplate.processTo(this.instQName.uri, this.owner.getXPathProcessor(), xcont, this.varContext);
        this.instQName.initFromRawname();
        if (!this.bInsideValue) {
            this.value.clear();
            this.owner.getOutputProcessor().startAttributeValueProcessing(this.value);
            this.owner.getOutputProcessor().setDisableOutputEscaping(true);
            this.processFromFirst(xcont, node);
            this.owner.getOutputProcessor().setDisableOutputEscaping(false);
            this.owner.getOutputProcessor().stopAttributeValueProcessing();
        } else {
            this.owner.getOutputProcessor().setDisableOutputEscaping(true);
            this.valueTemplate.processTo(this.value, this.owner.getXPathProcessor(), xcont, this.varContext);
            this.owner.getOutputProcessor().setDisableOutputEscaping(false);
        }
        if (!this.bProcessByElement) {
            this.owner.getOutputProcessor().addAttribute(this.instQName.uri, this.instQName.getPrefix(), this.instQName.rawname, this.instQName.getlocalname(), this.value);
        } else {
            this.setProcessNext(false);
        }
    }

    @Override
    public void print(String ind) {
        LogWriter.getSystemLogWriter().println(String.valueOf(ind) + "#XSLAttribute: name = " + this.instQName.rawname);
        if (this.getFirst() != null) {
            this.getFirst().print(String.valueOf(ind) + "  ");
        }
    }

    @Override
    public String[] getRequiredParams() {
        return REQPAR;
    }

    @Override
    public String[] getOptionalParams() {
        return OPTPAR;
    }
}

