/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.dom.TextImpl;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xslt.XSLAttribute;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class XSLAttributeSet
extends XSLNode {
    public static final String[] REQPAR = new String[]{"name"};
    public static final String[] OPTPAR = new String[]{"use-attribute-sets"};
    private String name = null;
    protected Vector attributeSets = new Vector();
    protected Vector attrs = new Vector();

    public XSLAttributeSet(XSLStylesheet owner) throws XSLException {
        super(owner, null);
    }

    public XSLAttributeSet(XSLStylesheet owner, Element el) throws XSLException {
        super(owner, null);
        this.name = el.getAttribute("name");
        if (el.getAttribute("use-attribute-sets") != null) {
            StringTokenizer tok = new StringTokenizer(el.getAttribute("use-attribute-sets"), " \n\r\t");
            while (tok.hasMoreElements()) {
                this.attributeSets.add(owner.getAttributeSet(tok.nextToken()));
            }
        }
        int i = 0;
        while (i < this.attributeSets.size()) {
            XSLAttributeSet xslattrset = (XSLAttributeSet)this.attributeSets.get(i);
            Vector v = xslattrset.getAttributes();
            int j = 0;
            while (j < v.size()) {
                XSLAttribute xslattr = (XSLAttribute)v.get(j);
                xslattr.setProcessByElement();
                int b = this.findXSLAttribute(this.attrs, xslattr);
                if (b > -1) {
                    this.attrs.set(b, xslattr);
                } else {
                    this.attrs.add(xslattr);
                }
                ++j;
            }
            ++i;
        }
        NodeList nl = el.getChildNodes();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            block17: {
                XSLAttribute xslattr;
                int b;
                block16: {
                    block15: {
                        if (nl.item(i2).getNodeType() == 3 && !((TextImpl)nl.item(i2)).isWhiteSpace()) {
                            throw new XSLException("Text nodes are not allowed in Attribute-set definition");
                        }
                        if (nl.item(i2).getNodeType() != 1) break block15;
                        if (nl.item(i2).getNamespaceURI() == null || !nl.item(i2).getNamespaceURI().equals("http://www.w3.org/1999/XSL/Transform") || nl.item(i2).getLocalName() == null || !nl.item(i2).getLocalName().equals("attribute")) {
                            throw new XSLException("Only 'attribute' nodes from the XSL-namespace are allowed in attribute-set definition");
                        }
                        break block16;
                    }
                    if (nl.item(i2).getNodeType() != 1) break block17;
                }
                if ((b = this.findXSLAttribute(this.attrs, xslattr = new XSLAttribute(owner, (XSLNode)this, (Element)nl.item(i2)))) > -1) {
                    this.attrs.set(b, xslattr);
                } else {
                    this.attrs.add(xslattr);
                }
            }
            ++i2;
        }
    }

    public Vector getAttributes() {
        return this.attrs;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        this.processFromFirst(xcont, node);
        int i = 0;
        while (i < this.attributeSets.size()) {
            XSLAttributeSet attribSet = this.owner.getAttributeSet((String)this.attributeSets.get(i));
            attribSet.processStart();
            attribSet.process(xcont, node);
            attribSet.processEnd();
            ++i;
        }
    }

    @Override
    public void print(String ind) {
        LogWriter.getSystemLogWriter().println(String.valueOf(ind) + "#XSLAttributeSet  name = " + this.name);
        if (this.getFirst() != null) {
            this.getFirst().print(String.valueOf(ind) + "  ");
        }
        if (this.getNext() != null) {
            this.getNext().print(ind);
        }
    }

    @Override
    public String[] getRequiredParams() {
        return REQPAR;
    }

    @Override
    public String[] getOptionalParams() {
        return OPTPAR;
    }
}

