/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.XSLContentNode;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import com.sap.engine.lib.xsl.xslt.XSLVariable;
import com.sap.engine.lib.xsl.xslt.XSLWithParam;
import java.util.Vector;
import org.w3c.dom.Element;

public final class XSLCallTemplate
extends XSLContentNode {
    private String name = null;
    protected Vector params = null;
    protected Vector sendpar = null;
    protected Vector varvalues = null;
    public static final String[] REQPAR = new String[]{"name"};
    public static final String[] OPTPAR = new String[0];

    public XSLCallTemplate(XSLStylesheet owner, XSLNode parent) throws XSLException {
        super(owner, parent);
    }

    public XSLCallTemplate(XSLStylesheet owner, XSLNode parent, Element el) throws XSLException {
        super(owner, parent, el);
        this.name = el.getAttribute("name");
        this.params = new Vector();
        this.sendpar = new Vector();
        this.varvalues = new Vector();
        XSLNode node = this.getFirst();
        XSLNode ntmp = null;
        node = node.getNext();
        while (node != null) {
            if (node instanceof XSLWithParam) {
                ntmp = node.getNext();
                node.remove();
                node.setNext(null);
                node.setPrev(null);
                this.params.add(node);
                node = ntmp;
                continue;
            }
            node = node.getNext();
        }
    }

    @Override
    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        int i;
        this.processFromFirst(xcont, node);
        this.sendpar.clear();
        this.varvalues.clear();
        if (this.params != null && this.params.size() > 0) {
            i = 0;
            while (i < this.params.size()) {
                XSLVariable xv = (XSLVariable)this.params.get(i);
                XObject varvalue = xv.evaluate(xcont);
                if (varvalue != null) {
                    varvalue.setParentDeclared(this);
                    this.varvalues.addElement(varvalue);
                    this.sendpar.add(this.owner.getXSLVarEvalPool().getObject().reuse(xv.getName(), varvalue));
                }
                ++i;
            }
        }
        this.owner.callTemplate(this.name, xcont, this.sendpar);
        i = 0;
        while (i < this.varvalues.size()) {
            XObject xo = (XObject)this.varvalues.elementAt(i);
            if (xo != null) {
                xo.closeAndRelease(this);
            }
            ++i;
        }
        this.varvalues.clear();
    }

    @Override
    public void print(String ind) {
        LogWriter.getSystemLogWriter().println(String.valueOf(ind) + "#XSLCallTemplate: name = " + this.name);
        if (this.getFirst() != null) {
            this.getFirst().print(String.valueOf(ind) + "  ");
        }
        if (this.getNext() != null) {
            this.getNext().print(ind);
        }
    }

    public void addParam(XSLVariable var) {
        this.params.add(var);
    }

    @Override
    public String[] getRequiredParams() {
        return REQPAR;
    }

    @Override
    public String[] getOptionalParams() {
        return OPTPAR;
    }

    @Override
    public XSLNode changeOwner(XSLStylesheet newOwner) {
        super.changeOwner(newOwner);
        int i = 0;
        while (i < this.params.size()) {
            ((XSLNode)this.params.get(i)).changeOwner(newOwner);
            ++i;
        }
        return this;
    }
}

