/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xslt.InternalAttributeList;
import com.sap.engine.lib.xsl.xslt.XSLAttribute;
import com.sap.engine.lib.xsl.xslt.XSLAttributeSet;
import com.sap.engine.lib.xsl.xslt.XSLContentNode;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;

public final class XSLCopy
extends XSLContentNode {
    public static final String[] REQPAR = new String[0];
    public static final String[] OPTPAR = new String[]{"use-attribute-sets"};
    private Vector attributeSets = new Vector();
    private Vector attrs = new Vector();
    private InternalAttributeList intatt = new InternalAttributeList();

    public XSLCopy(XSLStylesheet owner, XSLNode parent) throws XSLException {
        super(owner, parent);
    }

    public XSLCopy(XSLStylesheet owner, XSLNode parent, Element el) throws XSLException {
        super(owner, parent, el);
        if (el.getAttribute("use-attribute-sets") != null) {
            StringTokenizer tok = new StringTokenizer(el.getAttribute("use-attribute-sets"), " \n\r\t");
            while (tok.hasMoreElements()) {
                this.attributeSets.add(owner.getAttributeSet(tok.nextToken()));
            }
        }
        int i = 0;
        while (i < this.attributeSets.size()) {
            XSLAttributeSet xslattrset = (XSLAttributeSet)this.attributeSets.get(i);
            Vector v = xslattrset.getAttributes();
            int j = 0;
            while (j < v.size()) {
                XSLAttribute xslattr = (XSLAttribute)v.get(j);
                xslattr.setProcessByElement();
                int b = this.findXSLAttribute(this.attrs, xslattr);
                if (b > -1) {
                    this.attrs.set(b, xslattr);
                } else {
                    this.attrs.add(xslattr);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        switch (xcont.dtm.nodeType[xcont.node]) {
            case 1: {
                CharArray nodeName = xcont.dtm.name[xcont.node].rawname;
                CharArray uri = xcont.dtm.name[xcont.node].uri;
                XSLAttribute xsatt = null;
                this.intatt.clear();
                int i = 0;
                while (i < this.attrs.size()) {
                    xsatt = (XSLAttribute)this.attrs.get(i);
                    xsatt.processStart();
                    xsatt.process(xcont, node);
                    xsatt.processEnd();
                    this.intatt.addAttribute(xsatt.getNamespaceURI(), EMPTY_CARR, xsatt.getName(), xsatt.getName(), xsatt.getValue());
                    ++i;
                }
                this.owner.getOutputProcessor().startElement(uri, nodeName, nodeName, this.intatt);
                this.processFromFirst(xcont, node);
                this.owner.getOutputProcessor().endElement(uri, nodeName, nodeName);
                break;
            }
            case 3: {
                this.owner.getOutputProcessor().characters(xcont.dtm.getStringValue(xcont.node), false);
                break;
            }
            case 7: {
                this.owner.getOutputProcessor().processingInstruction(xcont.dtm.name[xcont.node].rawname, xcont.dtm.getStringValue(xcont.node));
                break;
            }
            case 8: {
                this.owner.getOutputProcessor().comment(xcont.dtm.getStringValue(xcont.node));
                break;
            }
            case 2: {
                this.owner.getOutputProcessor().addAttribute(xcont.dtm.name[xcont.node].uri, xcont.dtm.name[xcont.node].prefix, xcont.dtm.name[xcont.node].rawname, xcont.dtm.name[xcont.node].localname, xcont.dtm.getStringValue(xcont.node));
                break;
            }
            case 9: {
                this.processFromFirst(xcont, node);
                break;
            }
        }
    }

    @Override
    public void print(String ind) {
        LogWriter.getSystemLogWriter().println(String.valueOf(ind) + "#XSLCopy");
        if (this.getFirst() != null) {
            this.getFirst().print(String.valueOf(ind) + "  ");
        }
        if (this.getNext() != null) {
            this.getNext().print(ind);
        }
    }

    public Vector getAttributes() {
        return this.attrs;
    }

    @Override
    public String[] getRequiredParams() {
        return REQPAR;
    }

    @Override
    public String[] getOptionalParams() {
        return OPTPAR;
    }

    @Override
    public XSLNode changeOwner(XSLStylesheet newOwner) {
        super.changeOwner(newOwner);
        if (this.attrs != null) {
            int i = 0;
            while (i < this.attrs.size()) {
                ((XSLNode)this.attrs.get(i)).changeOwner(newOwner);
                ++i;
            }
        }
        return this;
    }
}

