/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.XSLContentNode;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLMessage;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLParam;
import com.sap.engine.lib.xsl.xslt.XSLResult;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import com.sap.engine.lib.xsl.xslt.XSLVariable;
import java.util.Vector;
import org.w3c.dom.Element;

public class XSLFunction
extends XSLContentNode {
    public static final String[] REQPAR = new String[]{"name"};
    public static final String[] OPTPAR = new String[0];
    protected String name = null;
    protected XObject resValue = null;
    protected Vector functionParameters = new Vector();
    protected Vector functionVariables = new Vector();
    protected Vector functionMessages = new Vector();
    protected XSLResult functionResult = null;

    public XSLFunction(XSLStylesheet owner) throws XSLException {
        super(owner, null);
    }

    public XSLFunction(XSLStylesheet owner, Element el) throws XSLException {
        super(owner, null, el);
        this.name = el.getAttribute("name");
        XSLNode node = this.getFirst();
        XSLNode ntmp = null;
        node = node.getNext();
        while (node != null && node instanceof XSLParam) {
            ntmp = node.getNext();
            node.remove();
            node.setNext(null);
            node.setPrev(null);
            this.functionParameters.add(node);
            node = ntmp;
        }
        while (node != null && (node instanceof XSLVariable || node instanceof XSLMessage)) {
            ntmp = node.getNext();
            node.remove();
            node.setNext(null);
            node.setPrev(null);
            ((XSLVariable)node).processBeforeEvaluating = true;
            if (node instanceof XSLVariable) {
                this.functionVariables.add(node);
            } else {
                this.functionMessages.add(node);
            }
            node = ntmp;
        }
        this.functionResult = (XSLResult)node;
    }

    public XSLFunction(String name) throws XSLException {
        super(null, null, null);
        this.name = name;
    }

    public boolean isResultTree() {
        return this.getFirst().getNext() != null;
    }

    public String getName() {
        return this.name;
    }

    public XObject evaluate(XPathContext xcont, Vector params) throws XPathException, XSLException {
        if (params.size() != this.functionParameters.size()) {
            throw new XSLException("Stylesheet function invocation \"" + this.getName() + "\" : actual and formal parameter lists do not match.");
        }
        int i = 0;
        while (i < this.functionParameters.size()) {
            ((XSLParam)this.functionParameters.get(i)).setValue((XObject)params.get(i));
            ((XSLParam)this.functionParameters.get((int)i)).doNotEvaluate = true;
            this.setVariable(((XSLParam)this.functionParameters.get(i)).getName(), (XSLParam)this.functionParameters.get(i));
            ++i;
        }
        i = 0;
        while (i < this.functionVariables.size()) {
            this.functionResult.setVariable(((XSLVariable)this.functionVariables.get(i)).getName(), (XSLVariable)this.functionVariables.get(i));
            ++i;
        }
        this.functionResult.processStart();
        this.functionResult.process(xcont, 0);
        this.functionResult.processEnd();
        XObject result = this.functionResult.evaluate(xcont);
        return result;
    }

    @Override
    public void print(String ind) {
        LogWriter.getSystemLogWriter().println(String.valueOf(ind) + "#XSLFunction: name = " + this.name);
        if (this.getFirst() != null) {
            this.getFirst().print(String.valueOf(ind) + "  ");
        }
        if (this.getNext() != null) {
            this.getNext().print(ind);
        }
    }

    @Override
    public String[] getRequiredParams() {
        return REQPAR;
    }

    @Override
    public String[] getOptionalParams() {
        return OPTPAR;
    }

    public void close() throws XPathException {
    }
}

