/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.ETLocationStep;
import com.sap.engine.lib.xsl.xpath.ETObject;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.QName;
import com.sap.engine.lib.xsl.xslt.XSLContentNode;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLOutputException;
import com.sap.engine.lib.xsl.xslt.XSLOutputProcessor;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XSLNumber
extends XSLContentNode {
    public static final String[] REQPAR = new String[0];
    public static final String[] OPTPAR = new String[]{"level", "count", "from", "value", "format", "lang", "letter-value", "grouping-separator", "grouping-size"};
    public static final byte LEVEL_DEFAULT = 1;
    public static final byte LEVEL_SINGLE = 1;
    public static final byte LEVEL_MULTIPLE = 2;
    public static final byte LEVEL_ANY = 3;
    public static final byte FORMAT_DEFAULT = 1;
    public static final byte FORMAT_NUMERIC = 1;
    public static final byte FORMAT_ROMAN = 2;
    public static final byte FORMAT_ALPHABETIC = 3;
    public static final boolean WITH_CAPITALS = true;
    public static final byte LETTER_VALUE_ALPHABETIC = 1;
    public static final byte LETTER_VALUE_TRADITIONAL = 2;
    public static final boolean ALPHANUMERIC = true;
    public static final boolean NON_ALPHANUMERIC = false;
    public static final int ROOT_NODE = 0;
    private int rootelement = -1;
    private String value = null;
    private byte level = 1;
    private Vector formattokens;
    private ETObject etcount = null;
    private ETObject etfrom = null;
    private boolean separatorspecified = false;
    private boolean sizespecified = false;
    private boolean countspecified = false;
    private boolean fromspecified = false;
    private ETObject eto = null;

    private int determineRootElement(XPathContext xcont) {
        int node = xcont.dtm.firstChild[0];
        while (xcont.dtm.nodeType[node] != 1) {
            node = xcont.dtm.nextSibling[node];
        }
        return node;
    }

    public XSLNumber(XSLStylesheet owner, XSLNode parent) throws XSLException {
        super(owner, parent);
    }

    public XSLNumber(XSLStylesheet owner, XSLNode parent, Node content) throws XSLException {
        super(owner, parent, content);
        boolean formatspecified = false;
        NamedNodeMap attribs = content.getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            Attr att = (Attr)attribs.item(i);
            String attrname = att.getNodeName();
            if (attrname.equals("level")) {
                this.level = 1;
                if (att.getValue().equals("multiple")) {
                    this.level = (byte)2;
                } else if (att.getValue().equals("any")) {
                    this.level = (byte)3;
                }
            } else if (attrname.equals("count")) {
                this.countspecified = true;
                this.etcount = owner.etBuilder.process(new CharArray(att.getValue()));
            } else if (attrname.equals("from")) {
                this.fromspecified = true;
                this.etfrom = owner.etBuilder.process(new CharArray(att.getValue()));
            } else if (attrname.equals("value")) {
                this.value = att.getValue();
                this.eto = owner.etBuilder.process(new CharArray(this.value));
            } else if (attrname.equals("format")) {
                formatspecified = true;
                this.formattokens = new Vector();
                this.splitToAlphanumericTokens(att.getValue(), this.formattokens);
            } else if (attrname.equals("grouping-separator")) {
                if (att.getValue().length() > 0) {
                    this.separatorspecified = true;
                }
            } else if (attrname.equals("grouping-size")) {
                try {
                    this.sizespecified = true;
                }
                catch (NumberFormatException nfe) {
                    throw new XSLException("Non-numeric value of 'grouping-size'. ", nfe);
                }
            }
            ++i;
        }
        if (!formatspecified) {
            this.formattokens = new Vector();
            this.formattokens.add(new Alphanumeric());
        }
        this.sizespecified = this.separatorspecified = this.separatorspecified && this.sizespecified;
    }

    private Alphanumeric stringToAlphanumeric(String st) {
        Alphanumeric an = new Alphanumeric();
        char ch = st.charAt(st.length() - 1);
        if (ch == 'a') {
            an.capitals = false;
            an.type = (byte)3;
        } else if (ch == 'A') {
            an.capitals = true;
            an.type = (byte)3;
        } else if (ch == 'i') {
            an.capitals = false;
            an.type = (byte)2;
        } else if (ch == 'I') {
            an.capitals = true;
            an.type = (byte)2;
        } else {
            an.type = 1;
            an.minimallength = st.length();
        }
        return an;
    }

    private void splitToAlphanumericTokens(String fortokenizing, Vector tokens) {
        boolean iscurrentalphanumeric;
        if (fortokenizing == null || fortokenizing != null && fortokenizing.equals("")) {
            Alphanumeric an = new Alphanumeric();
            an.type = 1;
            tokens.add(an);
            return;
        }
        boolean islastalphanumeric = iscurrentalphanumeric = Character.isLetterOrDigit(fortokenizing.charAt(0));
        int substrstarts = 0;
        int substrends = 0;
        int i = 1;
        while (i < fortokenizing.length()) {
            iscurrentalphanumeric = Character.isLetterOrDigit(fortokenizing.charAt(i));
            if (iscurrentalphanumeric != islastalphanumeric) {
                substrstarts = substrends;
                substrends = i;
                if (islastalphanumeric) {
                    tokens.add(this.stringToAlphanumeric(fortokenizing.substring(substrstarts, substrends)));
                } else {
                    tokens.add(fortokenizing.substring(substrstarts, substrends));
                }
            }
            islastalphanumeric = iscurrentalphanumeric;
            ++i;
        }
        substrstarts = substrends;
        substrends = fortokenizing.length();
        if (islastalphanumeric) {
            tokens.add(this.stringToAlphanumeric(fortokenizing.substring(substrstarts, substrends)));
        } else {
            tokens.add(fortokenizing.substring(substrstarts, substrends));
            if (tokens.size() == 1) {
                tokens.add(0, new Alphanumeric());
            }
        }
    }

    @Override
    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        if (this.rootelement == -1) {
            this.rootelement = this.determineRootElement(xcont);
        }
        XSLOutputProcessor oprocessor = this.owner.getOutputProcessor();
        if (!this.countspecified) {
            this.etcount = this.owner.etBuilder.process(xcont.dtm.name[node].toString());
        }
        if (!this.fromspecified) {
            QName x = new QName();
            x.localname = xcont.dtm.name[this.rootelement].localname;
            x.prefix = xcont.dtm.name[this.rootelement].prefix;
            x.uri = xcont.dtm.name[this.rootelement].uri;
            ETLocationStep e = new ETLocationStep("child", x);
            this.etfrom = new ETObject(xcont.dtm.name[this.rootelement].toString(), (ETItem)e);
        }
        if (this.value != null) {
            XObject xo = this.owner.getXPathProcessor().process(this.eto, xcont, this.varContext);
            XNumber xn = xo.toXNumber();
            this.printSingleOrAny(oprocessor, (int)Math.round(xn.getValue()));
        } else if (this.level == 3) {
            int num = this.calculateAny(this.etcount, this.etfrom, xcont);
            this.printSingleOrAny(oprocessor, num);
        } else if (this.level == 1) {
            int num = this.calculateSingle(this.etcount, this.etfrom, xcont);
            this.printSingleOrAny(oprocessor, num);
        } else if (this.level == 2) {
            int lastalphanumeric;
            boolean hasendstring;
            int[] list = this.calculateMultiple(this.etcount, this.etfrom, xcont);
            int j = 0;
            if (this.formattokens.elementAt(0) instanceof String) {
                ++j;
                oprocessor.characters(new CharArray((String)this.formattokens.elementAt(0)), true);
            }
            if (this.formattokens.elementAt(this.formattokens.size() - 1) instanceof String) {
                hasendstring = true;
                lastalphanumeric = this.formattokens.size() - 2;
            } else {
                hasendstring = false;
                lastalphanumeric = this.formattokens.size() - 1;
            }
            int i = 0;
            while (i < list.length) {
                Alphanumeric an = j < this.formattokens.size() - 1 ? (Alphanumeric)this.formattokens.elementAt(j) : (Alphanumeric)this.formattokens.elementAt(lastalphanumeric);
                this.printAlphanumeric(an, list[i], oprocessor);
                ++j;
                if (hasendstring) {
                    if (i == list.length - 1) {
                        oprocessor.characters(new CharArray((String)this.formattokens.elementAt(this.formattokens.size() - 1)), true);
                    } else if (j >= this.formattokens.size() - 1) {
                        if (this.formattokens.size() < 4) {
                            oprocessor.characters(new CharArray("."), false);
                        } else {
                            oprocessor.characters(new CharArray((String)this.formattokens.elementAt(this.formattokens.size() - 3)), true);
                        }
                    } else {
                        oprocessor.characters(new CharArray((String)this.formattokens.elementAt(j)), true);
                    }
                } else if (i < list.length - 1) {
                    if (j >= this.formattokens.size() - 1) {
                        if (this.formattokens.size() < 3) {
                            oprocessor.characters(new CharArray("."), false);
                        } else {
                            oprocessor.characters(new CharArray((String)this.formattokens.elementAt(this.formattokens.size() - 2)), true);
                        }
                    } else {
                        oprocessor.characters(new CharArray((String)this.formattokens.elementAt(j)), true);
                    }
                }
                ++j;
                ++i;
            }
        }
    }

    @Override
    public void print(String ind) {
    }

    /*
     * Unable to fully structure code
     */
    private int[] calculateMultiple(ETObject matchETO, ETObject fromETO, XPathContext basecontext) throws XPathException {
        listlength = this.howManyItems(matchETO, fromETO, basecontext);
        tempnode = basecontext.node;
        list = new int[listlength];
        xcont = new XPathContext();
        xcont.reuse(basecontext);
        i = 0;
        ** GOTO lbl15
        {
            xcont.node = tempnode = xcont.dtm.parent[tempnode];
            do {
                if (!matchETO.et.match(xcont)) continue block0;
                list[listlength - i - 1] = tempnode;
                xcont.node = tempnode = basecontext.dtm.parent[tempnode];
                ++i;
lbl15:
                // 2 sources

            } while (i < listlength);
        }
        i = 0;
        while (i < listlength) {
            nodenumber = 0;
            tempnode = list[i];
            while (tempnode != -1) {
                if (basecontext.dtm.nodeType[tempnode] == 1) {
                    xcont.reuse(basecontext);
                    xcont.node = tempnode;
                    if (matchETO.et.match(xcont)) {
                        ++nodenumber;
                    }
                }
                xcont.node = tempnode = xcont.dtm.previousSibling[tempnode];
            }
            list[i] = nodenumber;
            ++i;
        }
        return list;
    }

    private int howManyItems(ETObject matchETO, ETObject fromETO, XPathContext basecontext) throws XPathException {
        int count = 0;
        int fromnode = basecontext.node;
        XPathContext xcont = new XPathContext();
        xcont.reuse(basecontext);
        while (!fromETO.et.match(xcont) && fromnode != xcont.dtm.parent[this.rootelement]) {
            if (matchETO.et.match(xcont)) {
                ++count;
            }
            xcont.node = fromnode = xcont.dtm.parent[fromnode];
        }
        return count;
    }

    private int calculateSingle(ETObject matchETO, ETObject fromETO, XPathContext basecontext) throws XPathException {
        int fromnode = basecontext.node;
        XPathContext xcont = new XPathContext();
        xcont.reuse(basecontext);
        while (!matchETO.et.match(xcont) && fromnode != xcont.dtm.parent[this.rootelement]) {
            xcont.node = fromnode = xcont.dtm.parent[fromnode];
        }
        if (fromnode == xcont.dtm.parent[this.rootelement]) {
            return -1;
        }
        int countnode = xcont.node;
        while (!fromETO.et.match(xcont) && countnode != fromnode) {
            xcont.node = countnode = xcont.dtm.parent[countnode];
        }
        int nodecount = 1;
        while (xcont.dtm.previousSibling[countnode] != -1) {
            xcont.node = countnode = xcont.dtm.previousSibling[countnode];
            if (xcont.dtm.nodeType[countnode] != 1 || !matchETO.et.match(xcont)) continue;
            ++nodecount;
        }
        return nodecount;
    }

    private int calculateAny(ETObject matchETO, ETObject fromETO, XPathContext basecontext) throws XPathException {
        int node;
        int nodecount = 0;
        XPathContext xcont = new XPathContext();
        xcont.reuse(basecontext);
        int i = node = xcont.node;
        while (i >= this.rootelement) {
            if (xcont.dtm.nodeType[i] == 1) {
                xcont.node = i;
                if (fromETO.et.match(xcont)) {
                    return nodecount;
                }
                if (matchETO.et.match(xcont)) {
                    ++nodecount;
                }
            }
            --i;
        }
        return nodecount;
    }

    /*
     * Unable to fully structure code
     */
    private String intToRoman(int i, boolean capitals) {
        block27: {
            st = "";
            if (i == 0) {
                return "0";
            }
            if (i >= 4000) break block27;
            if (!capitals) ** GOTO lbl52
            while (i >= 1000) {
                st = String.valueOf(st) + "M";
                i -= 1000;
            }
            if (i >= 900) {
                st = String.valueOf(st) + "CM";
                i -= 900;
            }
            if (i >= 500) {
                st = String.valueOf(st) + "D";
                i -= 500;
            }
            if (i >= 400) {
                st = String.valueOf(st) + "CD";
                i -= 400;
            }
            while (i >= 100) {
                st = String.valueOf(st) + "C";
                i -= 100;
            }
            if (i >= 90) {
                st = String.valueOf(st) + "XC";
                i -= 90;
            }
            if (i >= 50) {
                st = String.valueOf(st) + "L";
                i -= 50;
            }
            if (i >= 40) {
                st = String.valueOf(st) + "XL";
                i -= 40;
            }
            while (i >= 10) {
                st = String.valueOf(st) + "X";
                i -= 10;
            }
            if (i == 9) {
                st = String.valueOf(st) + "IX";
                i = 0;
            }
            if (i >= 5) {
                st = String.valueOf(st) + "V";
                i -= 5;
            }
            if (i == 4) {
                st = String.valueOf(st) + "IV";
                i = 0;
            }
            while (i >= 1) {
                st = String.valueOf(st) + "I";
                --i;
            }
            break block27;
lbl-1000:
            // 1 sources

            {
                st = String.valueOf(st) + "m";
                i -= 1000;
lbl52:
                // 2 sources

                ** while (i >= 1000)
            }
lbl53:
            // 1 sources

            if (i >= 900) {
                st = String.valueOf(st) + "cm";
                i -= 900;
            }
            if (i >= 500) {
                st = String.valueOf(st) + "d";
                i -= 500;
            }
            if (i >= 400) {
                st = String.valueOf(st) + "cd";
                i -= 400;
            }
            while (i >= 100) {
                st = String.valueOf(st) + "c";
                i -= 100;
            }
            if (i >= 90) {
                st = String.valueOf(st) + "xc";
                i -= 90;
            }
            if (i >= 50) {
                st = String.valueOf(st) + "l";
                i -= 50;
            }
            if (i >= 40) {
                st = String.valueOf(st) + "xl";
                i -= 40;
            }
            while (i >= 10) {
                st = String.valueOf(st) + "x";
                i -= 10;
            }
            if (i == 9) {
                st = String.valueOf(st) + "ix";
                i = 0;
            }
            if (i >= 5) {
                st = String.valueOf(st) + "v";
                i -= 5;
            }
            if (i == 4) {
                st = String.valueOf(st) + "iv";
                i = 0;
            }
            while (i >= 1) {
                st = String.valueOf(st) + "i";
                --i;
            }
        }
        return st;
    }

    /*
     * Unable to fully structure code
     */
    private String intToLetter(int i, boolean capitals) {
        block2: {
            block1: {
                if (i != 0) break block1;
                st = "0";
                break block2;
            }
            st = "";
            ref = '\u0000';
            ref = capitals != false ? 'A' : 'a';
            if (--i != 0) ** GOTO lbl13
            return String.valueOf(ref);
lbl-1000:
            // 1 sources

            {
                j = i % 26;
                st = String.valueOf((char)(ref + j)) + st;
                i /= 26;
lbl13:
                // 2 sources

                ** while (i > 0)
            }
        }
        return st;
    }

    private void printSingleOrAny(XSLOutputProcessor oprocessor, int num) throws XSLOutputException {
        if (num >= 0) {
            int i = 0;
            if (this.formattokens.elementAt(0) instanceof String) {
                ++i;
                oprocessor.characters(new CharArray((String)this.formattokens.elementAt(0)), true);
            }
            Alphanumeric an = (Alphanumeric)this.formattokens.elementAt(i);
            this.printAlphanumeric(an, num, oprocessor);
            if (this.formattokens.size() > ++i && this.formattokens.elementAt(this.formattokens.size() - 1) instanceof String) {
                oprocessor.characters(new CharArray((String)this.formattokens.elementAt(this.formattokens.size() - 1)), true);
            }
        }
    }

    private void printAlphanumeric(Alphanumeric an, int num, XSLOutputProcessor oprocessor) throws XSLOutputException {
        if (an.type == 2) {
            oprocessor.characters(new CharArray(this.intToRoman(num, an.capitals)), true);
        } else if (an.type == 3) {
            oprocessor.characters(new CharArray(this.intToLetter(num, an.capitals)), true);
        } else {
            String number = new Integer(num).toString();
            if (number.length() < an.minimallength) {
                CharArray zero = new CharArray("0");
                int j = 1;
                while (j <= an.minimallength - number.length()) {
                    oprocessor.characters(zero, true);
                    ++j;
                }
            }
            oprocessor.characters(new CharArray(number), true);
        }
    }

    @Override
    public String[] getRequiredParams() {
        return REQPAR;
    }

    @Override
    public String[] getOptionalParams() {
        return OPTPAR;
    }

    private class Alphanumeric {
        boolean capitals;
        byte type = 1;
        int minimallength = 1;

        private Alphanumeric() {
        }
    }
}

