/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.jaxp.InstanceManager;
import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.parser.DOMParser;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.URLLoader;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.handlers.NamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.pool.CharArrayPool;
import com.sap.engine.lib.xsl.xpath.BSFLibrary;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.DTMFactory;
import com.sap.engine.lib.xsl.xpath.ETBuilder;
import com.sap.engine.lib.xsl.xpath.ETFunction;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.ETObject;
import com.sap.engine.lib.xsl.xpath.JLBLibrary;
import com.sap.engine.lib.xsl.xpath.LibraryManager;
import com.sap.engine.lib.xsl.xpath.StylesheetFunctionLibrary;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.XPathProcessor;
import com.sap.engine.lib.xsl.xpath.xobjects.IntArrayIterator;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XObjectFactory;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import com.sap.engine.lib.xsl.xslt.WhiteSpaceElement;
import com.sap.engine.lib.xsl.xslt.XSLApplyTemplates;
import com.sap.engine.lib.xsl.xslt.XSLAttributeSet;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLFunction;
import com.sap.engine.lib.xsl.xslt.XSLKey;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLOutputNode;
import com.sap.engine.lib.xsl.xslt.XSLOutputProcessor;
import com.sap.engine.lib.xsl.xslt.XSLScript;
import com.sap.engine.lib.xsl.xslt.XSLTemplate;
import com.sap.engine.lib.xsl.xslt.XSLTemplateHeader;
import com.sap.engine.lib.xsl.xslt.XSLTopVariable;
import com.sap.engine.lib.xsl.xslt.XSLValueOf;
import com.sap.engine.lib.xsl.xslt.XSLVarEval;
import com.sap.engine.lib.xsl.xslt.XSLVariable;
import com.sap.engine.lib.xsl.xslt.pool.ObjectPool;
import com.sap.engine.lib.xsl.xslt.pool.XSLVarEvalPool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XSLStylesheet {
    public static final String sXSLNamespace = "http://www.w3.org/1999/XSL/Transform";
    protected Vector templates = new Vector();
    protected XPathProcessor xpath = new XPathProcessor();
    protected XSLOutputNode xslOutputNode = null;
    protected XSLOutputProcessor xslOutputProcessor = new XSLOutputProcessor();
    protected Hashtable decimalFormats = new Hashtable();
    protected Hashtable attributeSets = new Hashtable();
    protected Hashtable variables = new Hashtable();
    protected XSLVarEvalPool xslVarEvalPool = null;
    public boolean debug = false;
    public ETBuilder etBuilder = new ETBuilder();
    private int importLevel = 0;
    private int currentTemplatePosition = 0;
    private XSLTemplateHeader[] vTemplates = null;
    private Vector whiteSpaceElements = new Vector();
    private Vector vTemplateHeaders = new Vector();
    private String baseURI = null;
    private NamespaceManager nsmanager = null;
    private NamespaceHandler namespaceHandler = null;
    protected CharArrayPool crPoolXSLElement = new CharArrayPool(10, 15);
    protected URIResolver uriResolver;
    protected URIResolver defaultResolver = this.uriResolver = new URLLoader();
    private DTMFactory dtmFactory = null;
    private DTM dtm = null;
    private XObjectFactory xfactProcess = new XObjectFactory(5000);
    private int iWhiteSpaceElementsCount = 0;
    private boolean bIsIndentAllowed = true;
    private ErrorListener errorListener = null;
    private LibraryManager libraryManager = null;
    private boolean bIncludeUse = false;
    public final String SAP_JAVA_XSLT_EXT_CLASSLOADER = "http://sap.com/java/xslt/ext-classloader";
    private ObjectPool hashTablesPool = new ObjectPool(Hashtable.class, 100, 100);
    public Hashtable qnameTable = new Hashtable();
    public Hashtable keyArrays = new Hashtable();
    public Hashtable nodesetArrays = new Hashtable();
    public Hashtable keyValuesArrays = new Hashtable();
    public Hashtable stylesheetFunctions = new Hashtable();
    protected int[] stack = new int[100];
    protected int pStack = 0;
    protected int startDTMSize = -1;
    protected int startDTMDocumentNodesSize = -1;
    private Vector vTopVariablesToProcess = new Vector();
    private Vector vTopVariablesToProcessSave = new Vector();
    protected Hashtable parameters = null;
    private XSLStylesheet importedStylesheet = null;
    private Hashtable namespaceAliases = new Hashtable();
    private String sourceBaseURI = "";
    private ClassLoader extClassLoader = null;
    private Hashtable xfKeyHash = new Hashtable();
    private XMLParser xmlParser = null;
    private int initializeKeysDocumentNode = -1;
    public Runtime rt = Runtime.getRuntime();

    public XSLStylesheet() throws XSLException {
        this.xslVarEvalPool = new XSLVarEvalPool(100, 100);
        this.libraryManager = new LibraryManager(this);
    }

    public XSLVarEvalPool getXSLVarEvalPool() {
        return this.xslVarEvalPool;
    }

    public XPathProcessor getXPathProcessor() {
        return this.xpath;
    }

    public void reuseTemplate() {
        this.xslOutputProcessor.reuse();
    }

    protected void print() {
        this.print("");
    }

    protected void print(String ind) {
        int i = 0;
        while (i < this.templates.size()) {
            ((XSLTemplate)this.templates.get(i)).print(ind);
            ++i;
        }
    }

    protected XSLAttributeSet getAttributeSet(String name) {
        return (XSLAttributeSet)this.attributeSets.get(name);
    }

    protected boolean doStripWhiteSpaceNode(XPathContext xcont) {
        return this.doStripWhiteSpaceNode(xcont, xcont.node);
    }

    public boolean doStripWhiteSpaceNode(XPathContext xcont, int node) {
        this.iWhiteSpaceElementsCount = this.whiteSpaceElements.size() - 1;
        if (this.iWhiteSpaceElementsCount == -1) {
            return false;
        }
        if (xcont.dtm.nodeType[node] != 3) {
            return false;
        }
        int p = xcont.dtm.parent[node];
        CharArray parentname = xcont.dtm.name[p].rawname;
        WhiteSpaceElement ws = null;
        int i = this.iWhiteSpaceElementsCount;
        while (i >= 0) {
            ws = (WhiteSpaceElement)this.whiteSpaceElements.get(i);
            if (ws.match(parentname)) {
                if (!ws.isPreserve()) {
                    return xcont.dtm.getStringValue(node).isWhitespace();
                }
                return false;
            }
            --i;
        }
        return false;
    }

    public void process(Object output) throws XSLException {
        int[] nodes = new int[]{0};
        this.xfKeyHash.clear();
        this.xpath.initializeProcess();
        this.xfactProcess.releaseAllPools();
        this.crPoolXSLElement.releaseAllObjects();
        this.getDTM().setFactories(this.xfactProcess, null);
        this.xslVarEvalPool = new XSLVarEvalPool(100, 100);
        this.hashTablesPool.releaseAllObjects();
        this.initializeKeysDocumentNode = -1;
        this.xpath.reuse(this.dtm);
        this.startDTMSize = this.dtm.size;
        this.startDTMDocumentNodesSize = this.dtm.documentNodesCount;
        XPathContext xpc = this.dtm.getInitialContext(this);
        xpc.owner = this;
        this.libraryManager = new LibraryManager(this);
        try {
            Enumeration functionURIs = this.stylesheetFunctions.keys();
            while (functionURIs.hasMoreElements()) {
                String nextURI = (String)functionURIs.nextElement();
                this.libraryManager.registerLibrary(new StylesheetFunctionLibrary(nextURI, (Vector)this.stylesheetFunctions.get(nextURI)));
            }
        }
        catch (ClassNotFoundException e) {
            throw new XSLException("problem registring stylesheet function library ", e);
        }
        xpc.library = this.libraryManager;
        boolean throwExc = true;
        try {
            this.initializeKeys(xpc);
        }
        catch (Exception exception) {}
        int k = 0;
        while (this.vTopVariablesToProcess.size() > 0) {
            throwExc = k == this.vTopVariablesToProcess.size();
            k = this.vTopVariablesToProcess.size();
            try {
                int i = 0;
                while (i < this.vTopVariablesToProcess.size()) {
                    XSLVariable xv = (XSLVariable)this.vTopVariablesToProcess.get(i);
                    if (this.parameters != null && this.parameters.get(xv.getName()) != null) {
                        XObject varValue;
                        String key = xv.getName();
                        Object value = this.parameters.get(key);
                        if (value instanceof String) {
                            varValue = this.xfactProcess.getXString((String)value);
                        } else {
                            JLBLibrary lb = this.libraryManager.getByClassName(value.getClass().getName());
                            if (lb != null) {
                                lb.setUserClass(value.getClass());
                            }
                            varValue = this.xfactProcess.getXJavaObject(value);
                        }
                        varValue.setTopVariableValue(true);
                        xv = new XSLVarEval(key, varValue);
                    } else {
                        xv.processStart();
                        xv.process(xpc, 0);
                        xv.processEnd();
                    }
                    this.vTopVariablesToProcessSave.add(this.vTopVariablesToProcess.remove(i));
                    --i;
                    this.setVariable(xv.getName(), xv);
                    ++i;
                }
            }
            catch (Exception e) {
                Object x = this.vTopVariablesToProcess.remove(0);
                this.vTopVariablesToProcess.add(x);
                this.getOutputProcessor().clearAttributeValueProcessing();
                if (!throwExc) continue;
                throw new XSLException("", e);
            }
        }
        this.initializeKeys(xpc);
        this.setOutput(output);
        this.xslOutputProcessor.startDocument();
        try {
            this.process(xpc, nodes, 0, 1, new Vector(), "");
            this.xslOutputProcessor.endDocument();
        }
        finally {
            this.dtm.size = this.startDTMSize;
            this.dtm.documentNodesCount = this.startDTMDocumentNodesSize;
            this.dtm.xfDocumentCache.clear();
            this.dtm.trim();
            Vector o = this.vTopVariablesToProcess;
            this.vTopVariablesToProcess = this.vTopVariablesToProcessSave;
            this.vTopVariablesToProcessSave = o;
            this.vTopVariablesToProcessSave.clear();
            this.xpath.finalizeLocal();
            this.xfactProcess.releaseAllPools();
        }
    }

    protected void process(XPathContext xcont, int[] nodes, int beg, int len, Vector params, String mode) throws XSLException {
        this.process(xcont, nodes, beg, len, params, mode, null);
    }

    protected void process(XPathContext xcont, int[] nodes, int beg, int len, Vector params, String mode, ETObject select) throws XSLException {
        XPathContext x2 = new XPathContext();
        if (mode == null) {
            mode = "";
        }
        int k = 0;
        while (k < len) {
            x2.reuse(xcont, nodes[k + beg], k + 1, len);
            int i = this.vTemplates.length - 1;
            while (i >= 0) {
                XSLTemplateHeader tmpl = this.vTemplates[i];
                if (!this.doStripWhiteSpaceNode(x2) && tmpl.bMatchable && (tmpl.sMode.equals(mode) || tmpl.bIsDefault) && this.xpath.match(tmpl.match, x2, mode, select)) {
                    XSLTemplate template = tmpl.template;
                    template.processStart();
                    template.process(x2, x2.node, params);
                    template.processEnd();
                    break;
                }
                --i;
            }
            ++k;
        }
    }

    public static synchronized String mkPath(String path) {
        return path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public void init(String xsldoc, URIResolver uriResolver, int importLevel) throws XSLException {
        Source src = null;
        try {
            if (uriResolver == null) {
                uriResolver = new URLLoader();
            }
            if ((src = uriResolver.resolve(xsldoc, this.baseURI)) != null && src.getSystemId() == null && src != null) {
                src.setSystemId(xsldoc);
            }
        }
        catch (Exception e) {
            throw new XSLException("Could not load stylesheet from: " + xsldoc, e);
        }
        String a = xsldoc;
        int index = 0;
        if (a.toLowerCase(Locale.ENGLISH).startsWith("file:")) {
            index = 5;
        }
        while (a.charAt(index) == '/') {
            ++index;
        }
        if (a.length() > index + 1 && a.charAt(index + 1) != ':') {
            --index;
        }
        a = a.substring(index);
        a = XSLStylesheet.mkPath(a);
        this.baseURI = a.substring(0, a.lastIndexOf(File.separator) + 1);
        this.init(src, uriResolver, importLevel);
    }

    public void init(Source src, URIResolver uriResolver, int importLevel) throws XSLException {
        if (src.getSystemId() != null) {
            this.baseURI = src.getSystemId();
        }
        if (src instanceof StreamSource) {
            Reader r = ((StreamSource)src).getReader();
            InputStream in = ((StreamSource)src).getInputStream();
            if (r != null) {
                this.init(r, uriResolver, importLevel);
            } else if (in != null) {
                this.init(in, src.getSystemId(), uriResolver, importLevel);
            } else {
                this.init(((StreamSource)src).getSystemId(), uriResolver, importLevel);
            }
        } else if (src instanceof DOMSource) {
            this.init(((DOMSource)src).getNode(), uriResolver, importLevel);
        } else {
            if (src instanceof SAXSource) {
                throw new XSLException("SAXSource is not supported for loading stylesheets");
            }
            throw new XSLException("This type of source is not supported for loading stylesheets: " + src);
        }
    }

    public void init(InputStream in, String systemID, URIResolver uriResolver, int importLevel) throws XSLException {
        Document doc = null;
        try {
            DOMParser parser = new DOMParser();
            parser.setFeature("http://inqmy.org/dom/features/trim-white-spaces", false);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            InputSource source = new InputSource(in);
            if (systemID != null) {
                source.setSystemId(systemID);
            }
            doc = parser.parse(source);
        }
        catch (Exception e) {
            throw new XSLException("Exception while parsing stylesheet", e);
        }
        this.init(doc.getDocumentElement(), uriResolver, importLevel);
    }

    public void init(Reader r, URIResolver uriResolver, int importLevel) throws XSLException {
        Document doc = null;
        try {
            DOMParser parser = new DOMParser();
            parser.setFeature("http://inqmy.org/dom/features/trim-white-spaces", false);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            doc = parser.parse(new InputSource(r));
        }
        catch (Exception e) {
            throw new XSLException("Exception while parsing stylesheet", e);
        }
        this.init(doc.getDocumentElement(), uriResolver, importLevel);
    }

    public void init(Node nd, URIResolver uriResolver, int importLevel) throws XSLException {
        if (nd.getNodeType() == 9) {
            this.init((Document)nd, uriResolver, importLevel);
        } else if (nd.getNodeType() == 1) {
            this.init((Element)nd, uriResolver, importLevel);
        } else {
            throw new XSLException("Cannot initialize  stylesheet with a not Document or Element node");
        }
    }

    public void init(Document doc, URIResolver uriResolver, int importLevel) throws XSLException {
        this.init(doc.getDocumentElement(), uriResolver, importLevel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(Element root, URIResolver userURIResolver, int il) throws XSLException {
        this.xpath.initializeProcess();
        this.decimalFormats.clear();
        this.attributeSets.clear();
        this.variables.clear();
        this.importLevel = il;
        this.currentTemplatePosition = 0;
        this.whiteSpaceElements.clear();
        this.vTemplateHeaders.clear();
        this.nsmanager = new NamespaceManager();
        this.namespaceHandler = new NamespaceHandler(null);
        this.bIsIndentAllowed = true;
        this.libraryManager.reuse();
        this.etBuilder.setNamespaceStuff(this.nsmanager, this.namespaceHandler);
        this.etBuilder.setParentStylesheet(this);
        this.templates.clear();
        this.xslOutputProcessor.reuse();
        this.xfactProcess.releaseAllPools();
        this.namespaceAliases.clear();
        this.qnameTable.clear();
        this.uriResolver = userURIResolver != null ? userURIResolver : new URLLoader();
        this.namespaceHandler.findNamespaceNodes(root, this.nsmanager);
        this.namespaceHandler.levelUp();
        this.vTopVariablesToProcess.clear();
        if (this.parameters != null) {
            this.parameters.clear();
        }
        this.keyValuesArrays.clear();
        this.nodesetArrays.clear();
        this.keyArrays.clear();
        NodeList nl = root.getChildNodes();
        if (root.getNamespaceURI() == null || !root.getNamespaceURI().equals(sXSLNamespace)) {
            this.processLiteralResultElement(root);
        } else {
            if (!root.getLocalName().equals("stylesheet") && !root.getLocalName().equals("transform")) {
                throw new XSLException("Root element of stylesheet must be either 'transform' or 'stylesheet' in the xsl namespace - http://www.w3.org/1999/XSL/Transform");
            }
            int i = 0;
            while (i < nl.getLength()) {
                if (nl.item(i).getNodeType() == 1) {
                    Element node = (Element)nl.item(i);
                    this.namespaceHandler.findNamespaceNodes(node, this.nsmanager);
                    this.namespaceHandler.levelUp();
                    if (node.getNamespaceURI() == null) {
                        throw new XSLException("All top level elements in a stylesheet must be namespace qualified. Bad Element: " + node.getNodeName());
                    }
                    if (node.getNamespaceURI().equals(sXSLNamespace)) {
                        String localName = node.getLocalName();
                        if (localName.equals("import")) {
                            this.processTopLevelImport(node);
                        } else if (localName.equals("include")) {
                            this.processTopLevelInclude(node);
                        } else if (localName.equals("strip-space")) {
                            this.processTopLevelStripSpace(node);
                        } else if (localName.equals("preserve-space")) {
                            this.processTopLevelPreserveSpace(node);
                        } else if (localName.equals("output")) {
                            this.processTopLevelOutput(node);
                        } else if (localName.equals("key")) {
                            this.processTopLevelKey(node);
                        } else if (localName.equals("decimal-format")) {
                            this.processTopLevelDecimalFormat(node);
                        } else if (localName.equals("namespace-alias")) {
                            this.processTopLevelNamespaceAlias(node);
                        } else if (localName.equals("attribute-set")) {
                            this.processTopLevelAttributeSet(node);
                        } else if (localName.equals("variable")) {
                            this.processTopLevelVariable(node);
                        } else if (localName.equals("param")) {
                            this.processTopLevelParam(node);
                        } else if (localName.equals("template")) {
                            this.processTopLevelTemplate(node);
                        } else if (localName.equals("script")) {
                            this.processTopLevelScript(node);
                        } else if (localName.equals("message")) {
                            if (node.getAttribute("terminate").equalsIgnoreCase("yes")) {
                                LogWriter.getSystemLogWriter().println("Received xsl:message with terminate = yes");
                                System.exit(0);
                            }
                        } else {
                            if (!localName.equals("function")) throw new XSLException("Error: bad toplevel element int the XSLT Namespace: " + node.getNodeName());
                            this.processTopLevelFunction(node);
                        }
                    } else {
                        XSLTemplate xsltemp = new XSLTemplate(this, node, Integer.MIN_VALUE, Integer.MIN_VALUE);
                        this.templates.add(xsltemp);
                    }
                    try {
                        this.namespaceHandler.levelDown();
                    }
                    catch (Exception e) {
                        throw new XSLException("Exception while processing namespaces", e);
                    }
                }
                ++i;
            }
        }
        try {
            this.namespaceHandler.levelDown();
        }
        catch (Exception e) {
            throw new XSLException("Exception while processing namespaces for the root node of the stylesheet.", e);
        }
        if (this.bIncludeUse) {
            return;
        }
        XSLTemplate xsltemp = new XSLTemplate(this, "*|/", "", Double.NEGATIVE_INFINITY, "", true, Integer.MIN_VALUE, Integer.MIN_VALUE);
        xsltemp.append(new XSLApplyTemplates(this, xsltemp, "", ""));
        this.templates.add(xsltemp);
        xsltemp = new XSLTemplate(this, "text()", "", Double.NEGATIVE_INFINITY, "", true, Integer.MIN_VALUE, Integer.MIN_VALUE);
        xsltemp.append(new XSLValueOf(this, (XSLNode)xsltemp, "."));
        this.templates.add(xsltemp);
        xsltemp = new XSLTemplate(this, "@*", "", Double.NEGATIVE_INFINITY, "", true, Integer.MIN_VALUE, Integer.MIN_VALUE);
        xsltemp.append(new XSLValueOf(this, (XSLNode)xsltemp, "."));
        this.templates.add(xsltemp);
        xsltemp = new XSLTemplate(this, "processing-instruction()", "", Double.NEGATIVE_INFINITY, "", true, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.templates.add(xsltemp);
        xsltemp = new XSLTemplate(this, "comment()", "", Double.NEGATIVE_INFINITY, "", true, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.templates.add(xsltemp);
        this.makeTemplateHeaders(this.templates, this.vTemplateHeaders);
        this.vTemplates = new XSLTemplateHeader[this.vTemplateHeaders.size()];
        this.vTemplateHeaders.toArray(this.vTemplates);
        Arrays.sort(this.vTemplates);
    }

    private void makeTemplateHeaders(Vector templates, Vector vTemplateHeaders) throws XSLException {
        String s = null;
        ETItem et = null;
        Vector<ETItem> vETItem = new Vector<ETItem>();
        vTemplateHeaders.clear();
        int i = 0;
        while (i < templates.size()) {
            XSLTemplate templ = (XSLTemplate)templates.get(i);
            s = templ.match.squery;
            et = templ.match.et;
            vETItem.clear();
            while (et instanceof ETFunction && ((ETFunction)et).getName().localname.equals("|")) {
                vETItem.add(0, ((ETFunction)et).getArg(1));
                et = ((ETFunction)et).getArg(0);
            }
            if (vETItem.size() > 0) {
                vETItem.add(0, et);
            }
            boolean bInQuotes = false;
            int openBrackets = 0;
            int tokens = 0;
            int laststroke = 0;
            int r = 0;
            r = 0;
            while (r < s.length()) {
                char ch = s.charAt(r);
                if (ch == '(' && !bInQuotes) {
                    ++openBrackets;
                } else if (ch == ')' && !bInQuotes) {
                    --openBrackets;
                } else if (ch == '\'' || ch == '\"') {
                    bInQuotes = !bInQuotes;
                } else if (ch == '|' && !bInQuotes && openBrackets == 0) {
                    ETObject etobj = new ETObject(s.substring(laststroke, r), (ETItem)vETItem.get(tokens));
                    vTemplateHeaders.add(new XSLTemplateHeader(etobj, templ, vTemplateHeaders.size()));
                    laststroke = r + 1;
                    ++tokens;
                }
                ++r;
            }
            String laststr = s.substring(laststroke, r);
            ETObject etobj = null;
            etobj = vETItem.size() > 0 ? new ETObject(laststr, (ETItem)vETItem.get(tokens)) : new ETObject(laststr, templ.match.et);
            vTemplateHeaders.add(new XSLTemplateHeader(etobj, templ, vTemplateHeaders.size()));
            ++i;
        }
    }

    public void processLiteralResultElement(Element el) throws XSLException {
        XSLTemplate xsltemp = new XSLTemplate(this, "/", "", 0.0, "", true, Integer.MIN_VALUE, Integer.MIN_VALUE);
        xsltemp.scanNode(el);
        this.templates.add(xsltemp);
        this.makeTemplateHeaders(this.templates, this.vTemplateHeaders);
        this.vTemplates = new XSLTemplateHeader[this.vTemplateHeaders.size()];
        this.vTemplateHeaders.toArray(this.vTemplates);
        Arrays.sort(this.vTemplates);
    }

    public void processTopLevelTemplate(Element el) throws XSLException {
        this.templates.add(new XSLTemplate(this, el, this.importLevel, this.currentTemplatePosition++));
    }

    public void processTopLevelImport(Element el) throws XSLException {
        int tempstart;
        String uri = el.getAttribute("href");
        this.importedStylesheet = InstanceManager.getXSLStylesheet();
        try {
            Source source = this.uriResolver.resolve(uri, this.baseURI);
            if (source != null) {
                if (source.getSystemId() == null && uri != null) {
                    source.setSystemId(uri);
                }
                this.importedStylesheet.init(source, this.uriResolver, this.importLevel - 1);
            }
        }
        catch (TransformerException exc) {
            throw new XSLException("Could not resolve: '" + uri + "', base: '" + this.baseURI + "'", exc);
        }
        Vector v = this.importedStylesheet.getTemplates();
        int i = tempstart = this.templates.size() - 1;
        while (i >= 0) {
            XSLTemplate told = (XSLTemplate)this.templates.get(i);
            int j = 0;
            while (j < v.size()) {
                XSLTemplate timp = (XSLTemplate)v.get(j);
                if (timp.isSameMatch(told)) {
                    timp.setOverloadByMatch(told);
                }
                if (timp.isSameName(told)) {
                    timp.setOverloadByName(told);
                }
                ++j;
            }
            --i;
        }
        i = 0;
        while (i < v.size()) {
            this.templates.add(((XSLNode)v.get(i)).changeOwner(this));
            ++i;
        }
        Enumeration importedVars = this.importedStylesheet.getVariables().elements();
        while (importedVars.hasMoreElements()) {
            XSLVariable xv = (XSLVariable)importedVars.nextElement();
            this.setVariable(xv.getName(), (XSLVariable)xv.changeOwner(this));
        }
        Vector importedTopVars = this.importedStylesheet.getTopVariablesToProcess();
        int i2 = 0;
        while (i2 < importedTopVars.size()) {
            XSLVariable xv = (XSLVariable)importedTopVars.get(i2);
            this.vTopVariablesToProcess.add((XSLVariable)xv.changeOwner(this));
            ++i2;
        }
        Enumeration imortedDecimalFormats = this.importedStylesheet.decimalFormats.keys();
        while (imortedDecimalFormats.hasMoreElements()) {
            String key = (String)imortedDecimalFormats.nextElement();
            if (this.decimalFormats.containsKey(key)) continue;
            this.decimalFormats.put(key, this.importedStylesheet.decimalFormats.get(key));
        }
        Enumeration importedAttributeSets = this.importedStylesheet.attributeSets.elements();
        while (importedAttributeSets.hasMoreElements()) {
            XSLAttributeSet set = (XSLAttributeSet)importedAttributeSets.nextElement();
            this.attributeSets.put(set.getName(), (XSLAttributeSet)set.changeOwner(this));
        }
        Enumeration importedKeys = this.importedStylesheet.keyArrays.keys();
        while (importedKeys.hasMoreElements()) {
            CharArray keyname = (CharArray)importedKeys.nextElement();
            XSLKey[] imported = (XSLKey[])this.importedStylesheet.keyArrays.get(keyname);
            if (this.keyArrays.containsKey(keyname)) {
                XSLKey[] current = (XSLKey[])this.keyArrays.get(keyname);
                XSLKey[] newKeys = new XSLKey[current.length + imported.length];
                System.arraycopy(current, 0, newKeys, 0, current.length);
                System.arraycopy(imported, 0, newKeys, current.length, imported.length);
                continue;
            }
            this.keyArrays.put(new CharArray(keyname), imported);
        }
        Enumeration importedFunctionNames = this.importedStylesheet.stylesheetFunctions.keys();
        while (importedFunctionNames.hasMoreElements()) {
            String funcUri = (String)importedFunctionNames.nextElement();
            Vector next = (Vector)this.importedStylesheet.stylesheetFunctions.get(funcUri);
            if (this.stylesheetFunctions.containsKey(funcUri)) {
                ((Vector)this.stylesheetFunctions.get(funcUri)).addAll(next);
                continue;
            }
            this.stylesheetFunctions.put(funcUri, next);
        }
    }

    public void processTopLevelInclude(Element el) throws XSLException {
        String uri = el.getAttribute("href");
        if (this.importedStylesheet == null) {
            this.importedStylesheet = InstanceManager.getXSLStylesheet();
        }
        try {
            StreamSource ss;
            Source src = this.uriResolver.resolve(uri, this.baseURI);
            if (src != null && src.getSystemId() == null && uri != null) {
                src.setSystemId(uri);
            }
            if (src instanceof StreamSource && (ss = (StreamSource)src).getInputStream() == null && ss.getReader() == null && ss.getSystemId() != null) {
                ss.setInputStream(new FileInputStream(ss.getSystemId()));
            }
            if (src != null) {
                this.importedStylesheet.init(src, this.uriResolver, this.importLevel);
            }
            this.importedStylesheet.setIncludeUse(true);
            this.importedStylesheet.setIncludeUse(false);
        }
        catch (TransformerException exc) {
            throw new XSLException("Could not resolve: '" + uri + "' base: '" + this.baseURI + "'", exc);
        }
        catch (IOException e) {
            throw new XSLException("Could not resolve: '" + uri + "' base: '" + this.baseURI + "'", e);
        }
        Vector v = this.importedStylesheet.getTemplates();
        int i = 0;
        while (i < v.size()) {
            if (!((XSLTemplate)v.get(i)).isDefault()) {
                this.templates.add(((XSLNode)v.get(i)).changeOwner(this));
            }
            ++i;
        }
        Enumeration importedVars = this.importedStylesheet.getVariables().elements();
        while (importedVars.hasMoreElements()) {
            XSLVariable xv = (XSLVariable)importedVars.nextElement();
            this.setVariable(xv.getName(), (XSLVariable)xv.changeOwner(this));
        }
        Vector importedTopVars = this.importedStylesheet.getTopVariablesToProcess();
        int i2 = 0;
        while (i2 < importedTopVars.size()) {
            XSLVariable xv = (XSLVariable)importedTopVars.get(i2);
            this.vTopVariablesToProcess.add((XSLVariable)xv.changeOwner(this));
            ++i2;
        }
        Enumeration imortedDecimalFormats = this.importedStylesheet.decimalFormats.keys();
        while (imortedDecimalFormats.hasMoreElements()) {
            String key = (String)imortedDecimalFormats.nextElement();
            if (this.decimalFormats.containsKey(key)) continue;
            this.decimalFormats.put(key, this.importedStylesheet.decimalFormats.get(key));
        }
        Enumeration importedKeys = this.importedStylesheet.keyArrays.keys();
        while (importedKeys.hasMoreElements()) {
            CharArray keyname = (CharArray)importedKeys.nextElement();
            XSLKey[] imported = (XSLKey[])this.importedStylesheet.keyArrays.get(keyname);
            if (this.keyArrays.containsKey(keyname)) {
                XSLKey[] current = (XSLKey[])this.keyArrays.get(keyname);
                XSLKey[] newKeys = new XSLKey[current.length + imported.length];
                System.arraycopy(current, 0, newKeys, 0, current.length);
                System.arraycopy(imported, 0, newKeys, current.length, imported.length);
                continue;
            }
            this.keyArrays.put(new CharArray(keyname), imported);
        }
        Enumeration importedAttributeSets = this.importedStylesheet.attributeSets.elements();
        while (importedAttributeSets.hasMoreElements()) {
            XSLAttributeSet set = (XSLAttributeSet)importedAttributeSets.nextElement();
            this.attributeSets.put(set.getName(), (XSLAttributeSet)set.changeOwner(this));
        }
        Enumeration importedFunctionNames = this.importedStylesheet.stylesheetFunctions.keys();
        while (importedFunctionNames.hasMoreElements()) {
            String funcUri = (String)importedFunctionNames.nextElement();
            Vector next = (Vector)this.importedStylesheet.stylesheetFunctions.get(funcUri);
            if (this.stylesheetFunctions.containsKey(funcUri)) {
                ((Vector)this.stylesheetFunctions.get(funcUri)).addAll(next);
                continue;
            }
            this.stylesheetFunctions.put(funcUri, next);
        }
    }

    public void processTopLevelStripSpace(Element el) throws XSLException {
        this.processWhiteSpaceElement(el.getAttribute("elements"), false);
    }

    public void processWhiteSpaceElement(String elements, boolean preserve) {
        StringTokenizer tok = new StringTokenizer(elements, " \n\r\t");
        while (tok.hasMoreElements()) {
            this.whiteSpaceElements.add(new WhiteSpaceElement(tok.nextToken(), preserve));
        }
    }

    public void processTopLevelPreserveSpace(Element el) throws XSLException {
        this.processWhiteSpaceElement(el.getAttribute("elements"), true);
    }

    public void processTopLevelOutput(Element el) throws XSLException {
        this.xslOutputNode = new XSLOutputNode(this, el);
        this.getOutputProcessor().setOutputMode(this.xslOutputNode);
    }

    public void processTopLevelKey(Element el) throws XSLException {
        XSLKey key = new XSLKey(this, el);
        CharArray keyName = new CharArray(key.getName());
        if (!this.keyArrays.containsKey(keyName)) {
            this.keyArrays.put(keyName, new XSLKey[]{key});
        } else {
            XSLKey[] oldKeys = (XSLKey[])this.keyArrays.get(keyName);
            XSLKey[] newKeys = new XSLKey[oldKeys.length + 1];
            System.arraycopy(oldKeys, 0, newKeys, 0, oldKeys.length);
            this.keyArrays.put(keyName, newKeys);
        }
    }

    public void processTopLevelFunction(Element el) throws XSLException {
        String name = el.getAttribute("name");
        int colonIndex = name.indexOf(58);
        if (colonIndex < 0) {
            throw new XSLException("Stylesheet functions must have namespace-qualified names.");
        }
        String prefix = name.substring(0, name.indexOf(58));
        String uri = this.namespaceHandler.get(new CharArray(prefix)).toString();
        Vector<XSLFunction> related = (Vector<XSLFunction>)this.stylesheetFunctions.get(uri);
        if (related == null) {
            related = new Vector<XSLFunction>();
            this.stylesheetFunctions.put(uri, related);
        }
        XSLFunction func = new XSLFunction(this, el);
        related.add(func);
    }

    public void processTopLevelDecimalFormat(Element el) throws XSLException {
        DecimalFormat dform = new DecimalFormat();
        DecimalFormatSymbols df = new DecimalFormatSymbols();
        if (el.getAttribute("infinity").length() > 0) {
            df.setInfinity(el.getAttribute("infinity"));
        }
        if (el.getAttribute("NaN").length() > 0) {
            df.setNaN(el.getAttribute("NaN"));
        }
        if (el.getAttribute("decimal-separator").length() > 0) {
            df.setDecimalSeparator(el.getAttribute("decimal-separator").charAt(0));
        }
        if (el.getAttribute("grouping-separator").length() > 0) {
            df.setGroupingSeparator(el.getAttribute("grouping-separator").charAt(0));
        }
        if (el.getAttribute("minus-sign").length() > 0) {
            df.setMinusSign(el.getAttribute("minus-sign").charAt(0));
        }
        if (el.getAttribute("precent").length() > 0) {
            df.setPercent(el.getAttribute("precent").charAt(0));
        }
        if (el.getAttribute("per-mille").length() > 0) {
            df.setPerMill(el.getAttribute("per-mille").charAt(0));
        }
        if (el.getAttribute("zero-digit").length() > 0) {
            df.setZeroDigit(el.getAttribute("zero-digit").charAt(0));
        }
        if (el.getAttribute("digit").length() > 0) {
            df.setDigit(el.getAttribute("digit").charAt(0));
        }
        if (el.getAttribute("pattern-separator").length() > 0) {
            df.setPatternSeparator(el.getAttribute("pattern-separator").charAt(0));
        }
        dform.setDecimalFormatSymbols(df);
        this.decimalFormats.put(el.getAttribute("name"), dform);
    }

    public void processTopLevelNamespaceAlias(Element el) throws XSLException {
        String stylesheetPrefix = el.getAttribute("stylesheet-prefix");
        String resultPrefix = el.getAttribute("result-prefix");
        this.namespaceAliases.put(stylesheetPrefix, resultPrefix);
    }

    public void processTopLevelAttributeSet(Element el) throws XSLException {
        XSLAttributeSet set = new XSLAttributeSet(this, el);
        this.attributeSets.put(set.getName(), set);
    }

    public void processTopLevelVariable(Element el) throws XSLException {
        this.vTopVariablesToProcess.add(new XSLTopVariable(this, el));
    }

    public void processTopLevelParam(Element el) throws XSLException {
        this.vTopVariablesToProcess.add(new XSLTopVariable(this, el));
    }

    public void processTopLevelScript(Element el) throws XSLException {
        XSLScript xs = new XSLScript(el);
        try {
            if (xs.getLanguage().equals("java")) {
                this.libraryManager.registerLibrary(new JLBLibrary(this.namespaceHandler.get(new CharArray(xs.getPrefix())).toString(), xs.getSrc(), xs.getArchive(), this.getExtClassLoader()));
            } else {
                this.libraryManager.registerLibrary(new BSFLibrary(this.namespaceHandler.get(new CharArray(xs.getPrefix())).toString(), xs.getLanguage(), xs.getData()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new XSLException("Could not load class: " + xs.getSrc() + " required for extension library.", e);
        }
    }

    public XSLVariable getVariable(String name) throws XSLException {
        XSLVariable xv = (XSLVariable)this.variables.get(name);
        if (xv == null) {
            throw new XSLException("Variable <" + name + "> undefined");
        }
        return xv;
    }

    public void setVariable(String name, XSLVariable var) {
        this.variables.put(name, var);
    }

    public void callTemplate(String name, XPathContext xcont, Vector params) throws XSLException, XPathException {
        int i = this.vTemplates.length - 1;
        while (i >= 0) {
            if (name.equals(this.vTemplates[i].sName)) {
                XSLTemplate template = this.vTemplates[i].template;
                template.processStart();
                template.process(xcont, xcont.node, params);
                template.processEnd();
                return;
            }
            --i;
        }
        throw new XSLException("Transformer: Could not find specified template in xsl:call-template '" + name + "'");
    }

    public XSLOutputProcessor getOutputProcessor() {
        return this.xslOutputProcessor;
    }

    public void setOPByteStream(OutputStream o) throws XSLException {
        this.xslOutputProcessor.reuse();
        this.getOutputProcessor().setByteStream(o);
    }

    public XSLOutputNode getOutputProperties() {
        return this.xslOutputNode;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getSourceBaseURI() {
        return this.sourceBaseURI;
    }

    public void setSourceBaseURI(String uri) {
        this.sourceBaseURI = uri;
    }

    public NamespaceManager getNamespaceManager() {
        return this.nsmanager;
    }

    public void setOutput(Object output) throws XSLException {
        if (output == null) {
            throw new IllegalArgumentException("Output cannot be null.");
        }
        this.xslOutputProcessor.reuse();
        if (output instanceof String) {
            try {
                this.setOPByteStream(new FileOutputStream((String)output));
            }
            catch (FileNotFoundException e) {
                throw new XSLException("Exception while configuring output", e);
            }
        } else if (output instanceof OutputStream) {
            this.setOPByteStream((OutputStream)output);
        } else if (output instanceof DocHandler) {
            this.xslOutputProcessor.setDocHandler((DocHandler)output);
        } else {
            throw new IllegalArgumentException("Output through " + output.getClass().getName() + " not supported.");
        }
    }

    private Vector getTemplates() {
        return this.templates;
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public DocHandler getInputHandler() throws XSLException {
        this.getDTMFactory().initialize(this.getDTM(), this.nsmanager);
        return this.dtmFactory;
    }

    public DocHandler getInputHandler(String s) throws XSLException {
        this.getDTMFactory().approximateAndInitialize(this.getDTM(), this.nsmanager, s);
        return this.dtmFactory;
    }

    public void init(Node node, URIResolver uriResolver, String systemId) throws XSLException {
        if (systemId != null) {
            this.baseURI = systemId;
        }
        this.init(node, uriResolver, 0);
    }

    public void init(Node node, URIResolver uriResolver) throws XSLException {
        this.init(node, uriResolver, 0);
    }

    public DTM getDTM() {
        if (this.dtm == null) {
            this.dtm = new DTM();
        }
        return this.dtm;
    }

    public DTMFactory getDTMFactory() {
        if (this.dtmFactory == null) {
            this.dtmFactory = new DTMFactory();
        }
        return this.dtmFactory;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public URIResolver getDefaultResolver() {
        return this.defaultResolver;
    }

    public void setInputXML(String uri) throws XSLException {
        try {
            Source src = this.uriResolver.resolve(uri, null);
            if (!(src instanceof StreamSource)) {
                throw new XSLException("Reslolved uri must be a StreamSource");
            }
            this.setInputXML(((StreamSource)src).getInputStream(), this.getInputHandler(uri));
        }
        catch (Exception e) {
            throw new XSLException("Could not load input XML file", e);
        }
    }

    public void setInputXML(InputStream in, DocHandler fact) throws XSLException {
        try {
            if (this.xmlParser == null) {
                this.xmlParser = new XMLParser();
            }
            this.xmlParser.setValidation(false);
            this.xmlParser.setNamespaces(true);
            this.xmlParser.setNamespacePrefixes(true);
            this.xmlParser.parse(in, fact);
        }
        catch (Exception e) {
            throw new XSLException("Error while parsing input xml", e);
        }
    }

    public NamespaceHandler getNamespaceHandler() {
        return this.namespaceHandler;
    }

    public Hashtable getVariables() {
        return this.variables;
    }

    public Vector getTopVariablesToProcess() {
        return this.vTopVariablesToProcess;
    }

    public boolean isIndentAllowed() {
        return this.bIsIndentAllowed;
    }

    public void setIsIndentAllowed(boolean value) {
        this.bIsIndentAllowed = value;
    }

    public void setParameters(Hashtable parameters) {
        if (parameters.get("http://sap.com/java/xslt/ext-classloader") != null) {
            this.setExtClassLoader((ClassLoader)parameters.get("http://sap.com/java/xslt/ext-classloader"));
            parameters.remove("http://sap.com/java/xslt/ext-classloader");
        }
        this.parameters = parameters;
    }

    public void clearParameters() {
        this.parameters = null;
    }

    public DecimalFormat getDecimalFormat(String name) {
        return (DecimalFormat)this.decimalFormats.get(name);
    }

    public void initializeKeys(XPathContext context) throws XPathException {
        int currentNode = context.node;
        int documentNode = context.dtm.getDocumentElement(currentNode);
        if (this.initializeKeysDocumentNode == documentNode) {
            return;
        }
        context = context.dtm.getInitialContext(context.owner);
        context.node = documentNode;
        Enumeration e = this.keyArrays.keys();
        while (e.hasMoreElements()) {
            CharArray sc = (CharArray)e.nextElement();
            XSLKey[] keys = (XSLKey[])this.keyArrays.get(sc);
            XNodeSet[] nodeSets = new XNodeSet[keys.length];
            CharArray[][] keyValues = new CharArray[keys.length][];
            int i = 0;
            while (i < keys.length) {
                XSLKey key = keys[i];
                XNodeSet xo = (XNodeSet)this.xpath.process(key.getETMatch(), context);
                keyValues[i] = new CharArray[xo.size()];
                XPathContext c = new XPathContext(context);
                CharArray x = new CharArray(10000);
                int pos = 0;
                int m = 0;
                IntArrayIterator k = xo.iterator();
                while (k.hasNext()) {
                    c.position = ++pos;
                    c.node = k.next();
                    XObject pr = this.getXPathProcessor().process(key.getETUse(), c);
                    XString xstr = pr.toXString();
                    this.freeMem();
                    int sz = x.length();
                    int l = xstr.getValue().length();
                    x.append(xstr.getValue());
                    CharArray ca = new CharArray();
                    ca.substring(x, sz, sz + l);
                    keyValues[i][m] = ca;
                    pr.close();
                    xstr.close();
                    ++m;
                }
                nodeSets[i] = xo;
                ++i;
            }
            this.nodesetArrays.put(sc, nodeSets);
            this.keyValuesArrays.put(sc, keyValues);
        }
        this.initializeKeysDocumentNode = documentNode;
    }

    public void setErrorListener(ErrorListener e) {
        this.errorListener = e;
    }

    public void sendWarning(String msg) throws XSLException {
        try {
            if (this.errorListener != null) {
                this.errorListener.warning(new TransformerException(msg));
            } else {
                LogWriter.getSystemLogWriter().println(msg);
            }
        }
        catch (TransformerException e) {
            throw new XSLException("Exception while sending warning", e);
        }
    }

    public Hashtable getNamespaceAliases() {
        return this.namespaceAliases;
    }

    public boolean getIncludeUse() {
        return this.bIncludeUse;
    }

    public void setIncludeUse(boolean value) {
        this.bIncludeUse = value;
    }

    public void reuseLastSource() {
    }

    public ClassLoader getExtClassLoader() {
        return this.extClassLoader;
    }

    public void setExtClassLoader(ClassLoader cl) {
        this.extClassLoader = cl;
    }

    public void freeMem() {
        try {
            if (this.rt.freeMemory() < 20000L) {
                while (this.rt.freeMemory() < 20000L) {
                    System.gc();
                    Thread.sleep(500L);
                }
            }
        }
        catch (Exception exception) {}
    }

    public Hashtable getXFKeyHash() {
        return this.xfKeyHash;
    }

    public ObjectPool getHashTablesPool() {
        return this.hashTablesPool;
    }
}

