/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xsl.xslt.XSLTestInfo;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class XSLTMarkTester {
    protected Vector infos = new Vector();

    public Vector getTests() {
        return this.infos;
    }

    public XSLTMarkTester(String fname) throws Exception {
        this.init(fname);
    }

    private Vector init(String fname) throws FileNotFoundException {
        BufferedReader in = new BufferedReader(new FileReader(fname));
        String basedir = fname.substring(0, fname.lastIndexOf("\\") + 1);
        try {
            String line;
            XSLTestInfo ti = null;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (line.charAt(0) == '[') {
                    if (ti != null) {
                        this.infos.add(ti);
                    }
                    ti = new XSLTestInfo();
                    ti.name = line.substring(1, line.length() - 1);
                    continue;
                }
                if (this.getKey(line).equals("input")) {
                    ti.xml = String.valueOf(basedir) + this.getValue(line);
                    continue;
                }
                if (this.getKey(line).equals("stylesheet")) {
                    ti.xsl = String.valueOf(basedir) + this.getValue(line);
                    continue;
                }
                if (this.getKey(line).equals("output")) {
                    ti.out = String.valueOf(basedir) + this.getValue(line);
                    continue;
                }
                if (this.getKey(line).equals("comment")) {
                    ti.comment = this.getValue(line);
                    continue;
                }
                if (this.getKey(line).equals("reference")) {
                    ti.ref = String.valueOf(basedir) + this.getValue(line);
                    continue;
                }
                if (!this.getKey(line).equals("skipdriver")) continue;
                boolean bl = ti.skip = this.getValue(line).indexOf("inqmy") > -1;
            }
            if (ti != null) {
                this.infos.add(ti);
            }
            return this.infos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.infos;
        }
    }

    private String getValue(String line) {
        return line.substring(line.indexOf("=") + 1).trim();
    }

    private String getKey(String line) {
        return line.substring(0, line.indexOf("=")).trim();
    }

    public XSLTestInfo getTest(String name) throws Exception {
        int i = 0;
        while (i < this.infos.size()) {
            if (((XSLTestInfo)this.infos.get((int)i)).name.equals(name)) {
                return (XSLTestInfo)this.infos.get(i);
            }
            ++i;
        }
        throw new Exception("Could not fine test named: " + name);
    }
}

