/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xsl.xpath.ETLocationStep;
import com.sap.engine.lib.xsl.xpath.ETObject;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.XSLContentNode;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLParam;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import com.sap.engine.lib.xsl.xslt.XSLVarEval;
import com.sap.engine.lib.xsl.xslt.XSLVariable;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Element;

public final class XSLTemplate
extends XSLContentNode
implements Comparable {
    public static final String[] REQPAR = new String[0];
    public static final String[] OPTPAR = new String[]{"match", "name", "priority", "mode"};
    public static final String EMPTYSTRING = "";
    public ETObject match = null;
    public String name = null;
    public double priority = 0.0;
    public boolean bSpecifiedPriority = false;
    public String mode = null;
    protected boolean def = false;
    protected int importPrecedence = -1;
    protected int position = -1;
    private XSLTemplate ovrName = null;
    private XSLTemplate ovrMatch = null;
    private Stack templateVariables = new Stack();
    private String varSeparator = "<>";
    protected Vector templateParams = new Vector();
    private Hashtable fakeParams = new Hashtable();

    public void setPriority(String p) throws XSLException {
        if (p != null && p.length() > 0) {
            this.priority = Double.parseDouble(p);
            this.bSpecifiedPriority = true;
        } else if (this.match.et instanceof ETLocationStep) {
            ETLocationStep loc = (ETLocationStep)this.match.et;
            this.priority = loc.getNodeTest().rawname.equals("*") ? -0.25 : (loc.getNodeTest().localname.equals("*") ? -0.12 : (loc.getNodeTest().localname.equals("node()") || loc.getNodeTest().localname.equals("text()") || loc.getNodeTest().localname.equals("comment()") ? -0.5 : 0.0));
        } else {
            this.priority = 0.5;
        }
    }

    public XSLTemplate(XSLStylesheet owner) throws XSLException {
        super(owner, null);
        this.TYPE = 1;
    }

    public XSLTemplate(XSLStylesheet owner, Element el, int ip, int pos) throws XSLException {
        super(owner, null, el);
        this.TYPE = 1;
        this.owner = owner;
        this.match = owner.etBuilder.process(el.getAttribute("match"));
        this.name = el.getAttribute("name");
        this.mode = el.getAttribute("mode");
        this.setPriority(el.getAttribute("priority"));
        this.importPrecedence = ip;
        this.position = pos;
        XSLNode node = this.getFirst();
        XSLNode ntmp = null;
        node = node.getNext();
        while (node != null && node instanceof XSLParam) {
            ntmp = node.getNext();
            node.remove();
            node.setNext(null);
            node.setPrev(null);
            this.templateParams.add(node);
            this.getTemplateParamsStack().put(((XSLParam)node).getName(), new Stack());
            node = ntmp;
        }
    }

    public XSLTemplate(XSLStylesheet owner, String match, String name, double priority, String mode, boolean def, int ip, int pos) throws XSLException {
        super(owner, null, null);
        this.TYPE = 1;
        this.match = owner.etBuilder.process(match);
        this.name = name;
        this.priority = priority;
        this.bSpecifiedPriority = true;
        this.mode = mode;
        this.def = def;
        this.importPrecedence = ip;
        this.position = pos;
    }

    public String toString() {
        return "#XSLTemplate: match = " + this.match.squery + " name = " + this.name;
    }

    @Override
    public void print(String ind) {
        LogWriter.getSystemLogWriter().println(String.valueOf(ind) + "#XSLTemplate: match = " + this.match.squery + " name = " + this.name);
        this.getFirst().print(String.valueOf(ind) + "  ");
    }

    @Override
    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        this.process(xcont, node, null);
    }

    public void pushTemplateVarStart() {
        this.templateVariables.push(this.varSeparator);
    }

    public void popTemplateVars() throws XSLException {
        String a = null;
        while (!(a = (String)this.templateVariables.pop()).equals(this.varSeparator)) {
            XSLVarEval xv = (XSLVarEval)this.popVar(a);
            xv.close(this);
            this.owner.getXSLVarEvalPool().releaseObject(xv);
        }
    }

    public void process(XPathContext xcont, int node, Vector params) throws XSLException, XPathException {
        this.pushTemplateVarStart();
        int i = 0;
        while (i < this.templateParams.size()) {
            XObject varvalue;
            XSLVariable xv = (XSLVariable)this.templateParams.get(i);
            int j = 0;
            while (params != null && j < params.size()) {
                String name = ((XSLVariable)params.get(j)).getName();
                if (name.equals(xv.getName())) {
                    XObject varvalue2 = ((XSLVariable)params.get(j)).evaluate(xcont);
                    if (varvalue2 == null) break;
                    varvalue2.setParentDeclared(this);
                    this.setVariable(name, this.owner.getXSLVarEvalPool().getObject().reuse(name, varvalue2));
                    break;
                }
                ++j;
            }
            if ((params == null || j == params.size()) && (varvalue = xv.evaluate(xcont)) != null) {
                varvalue.setParentDeclared(this);
                this.setVariable(xv.getName(), this.owner.getXSLVarEvalPool().getObject().reuse(xv.getName(), varvalue));
            }
            ++i;
        }
        this.processFromFirst(xcont, node);
        this.popTemplateVars();
    }

    @Override
    public void setVariable(String name, XSLVariable var) {
        this.setVariableFromTemplate(name, var);
        this.templateVariables.push(name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isMatchable() {
        return this.match.squery != null && this.match.squery.length() != 0;
    }

    public double getPriority() {
        return this.priority;
    }

    public String getMode() {
        if (this.mode == null) {
            return EMPTYSTRING;
        }
        return this.mode;
    }

    public boolean isDefault() {
        return this.def;
    }

    public int compareTo(Object o) {
        XSLTemplate t = (XSLTemplate)o;
        if (this.importPrecedence != t.importPrecedence) {
            if (this.importPrecedence < t.importPrecedence) {
                return -1;
            }
            return 1;
        }
        if (this.priority != t.priority) {
            if (this.priority < t.priority) {
                return -1;
            }
            return 1;
        }
        return this.position - t.position;
    }

    public boolean isSameMatch(XSLTemplate t) {
        return t.match.squery.equals(this.match.squery) && (t.mode == null && this.mode == null || t.mode != null && t.mode.equals(this.mode));
    }

    public boolean isSameName(XSLTemplate t) {
        return this.name != null && this.name.length() > 0 && this.name.equals(t.name);
    }

    public void setOverloadByMatch(XSLTemplate t) {
        this.ovrMatch = t;
    }

    public void setOverloadByName(XSLTemplate t) {
        this.ovrName = t;
    }

    public void setPosition(int pos) {
        this.position = pos;
    }

    @Override
    public String[] getRequiredParams() {
        return REQPAR;
    }

    @Override
    public String[] getOptionalParams() {
        return OPTPAR;
    }

    @Override
    public XSLNode changeOwner(XSLStylesheet newOwner) {
        super.changeOwner(newOwner);
        if (this.templateParams != null) {
            int i = 0;
            while (i < this.templateParams.size()) {
                ((XSLNode)this.templateParams.get(i)).changeOwner(newOwner);
                ++i;
            }
        }
        return this;
    }

    public void setBackwardsCompatibilityVar(String name, XSLVariable variable) {
        this.fakeParams.put(name, variable);
    }

    public Hashtable getBackwardsCompatibilityVar() {
        return this.fakeParams;
    }
}

