/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.output;

import com.sap.engine.lib.xsl.xslt.output.CanonicalDocHandlerSerializer;
import com.sap.engine.lib.xsl.xslt.output.OutputException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;

public class CanonicalDocHandlerSerializerPool {
    protected Vector freePool = new Vector(10, 10);
    protected int maxCount = 400;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CanonicalDocHandlerSerializer get(OutputStream os, Properties ps) throws OutputException {
        CanonicalDocHandlerSerializer serializer;
        Vector vector = this.freePool;
        synchronized (vector) {
            int size = this.freePool.size();
            if (size > 0) {
                serializer = (CanonicalDocHandlerSerializer)this.freePool.remove(size - 1);
                serializer.init(os, ps);
            } else {
                serializer = new CanonicalDocHandlerSerializer(os, ps);
            }
        }
        return serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(CanonicalDocHandlerSerializer enc) {
        if (enc == null) {
            return;
        }
        enc.release();
        Vector vector = this.freePool;
        synchronized (vector) {
            if (this.freePool.size() < this.maxCount) {
                this.freePool.addElement(enc);
            }
        }
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxCount(int value) {
        if (value < 0) {
            throw new RuntimeException("No negative pool size allowed!");
        }
        Vector vector = this.freePool;
        synchronized (vector) {
            int k;
            while (value < (k = this.freePool.size())) {
                this.freePool.removeElementAt(k - 1);
            }
        }
        this.maxCount = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        Vector vector = this.freePool;
        synchronized (vector) {
            this.freePool.clear();
        }
    }
}

