/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.output;

import com.sap.engine.lib.xml.dom.BinaryTextImpl;
import com.sap.engine.lib.xml.parser.handlers.EmptyDocHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xsl.xslt.output.Encoder;
import com.sap.engine.lib.xsl.xslt.output.Indenter;
import com.sap.engine.lib.xsl.xslt.output.InstanceHolder;
import com.sap.engine.lib.xsl.xslt.output.Method;
import com.sap.engine.lib.xsl.xslt.output.Options;
import com.sap.engine.lib.xsl.xslt.output.OutputException;
import com.sap.engine.lib.xsl.xslt.output.OutputIllegalOptionException;
import com.sap.engine.lib.xsl.xslt.output.Tools;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Properties;

public class DocHandlerSerializer
extends EmptyDocHandler {
    protected InstanceHolder holder = new InstanceHolder();
    protected Method method = this.holder.getMethodXML();
    protected Encoder encoder;
    protected Indenter indenter = this.holder.getIndenterEmpty();
    protected HashSet cDataSectionElements = new HashSet();
    protected Properties outputProperties = null;
    protected HashSet options = new HashSet();
    protected boolean firstElementReached = false;
    protected boolean bMustCloseOnEnd = false;
    protected boolean escapingSaver;

    public DocHandlerSerializer() {
        this.encoder = new Encoder();
        this.options.addAll(Options.DEFAULT);
        this.encoder.setOwner(this);
        this.method.setOwner(this);
        this.bMustCloseOnEnd = false;
    }

    public DocHandlerSerializer(Writer writer, Properties outputProperties) throws OutputException {
        this();
        this.setOutputProperties(outputProperties);
        this.setWriter(writer);
    }

    public DocHandlerSerializer(OutputStream outputStream, Properties outputProperties) throws OutputException {
        this();
        this.setOutputProperties(outputProperties);
        this.setOutputStream(outputStream);
    }

    public void setOutputProperties(Properties x) {
        this.outputProperties = x;
    }

    public void setOutputStream(OutputStream outputStream) throws OutputException {
        this.encoder.init(outputStream, this.outputProperties.getProperty("encoding"));
    }

    public void setWriter(Writer writer) throws OutputException {
        this.encoder.init(writer, this.outputProperties.getProperty("encoding"));
    }

    @Override
    public void startDocument() throws Exception {
        this.firstElementReached = false;
        String s = this.outputProperties.getProperty("indent");
        this.indenter = Tools.isYes(s) ? this.holder.getIndenterImpl() : this.holder.getIndenterEmpty();
        this.indenter.setOwner(this);
    }

    protected void startDocument_internal(String rootElementLocalName) throws Exception {
        Tools.parseNMTOKENS(this.outputProperties.getProperty("cdata-section-elements"), this.cDataSectionElements);
        String s = this.outputProperties.getProperty("method");
        this.method = Tools.notEmpty(s) ? ((s = s.trim()).equalsIgnoreCase("html") ? this.holder.getMethodHTML() : (s.equalsIgnoreCase("text") ? this.holder.getMethodText() : (s.equalsIgnoreCase("dump") ? this.holder.getMethodDump() : this.holder.getMethodXML()))) : (rootElementLocalName.equalsIgnoreCase("html") ? this.holder.getMethodHTML() : this.holder.getMethodXML());
        this.method.setOwner(this);
        this.encoder.setOwner(this);
        this.options.clear();
        String omit = this.outputProperties.getProperty("omit-xml-declaration");
        String version = this.outputProperties.getProperty("version");
        String encoding = this.encoder.getEncodingName();
        String standalone = this.outputProperties.getProperty("standalone");
        this.indenter.startDocument(omit, version, encoding, standalone);
        String doctypePublic = this.outputProperties.getProperty("doctype-public");
        String doctypeSystem = this.outputProperties.getProperty("doctype-system");
        if (Tools.notEmpty(doctypePublic) || Tools.notEmpty(doctypeSystem)) {
            this.indenter.startDTD(rootElementLocalName, doctypePublic, doctypeSystem);
            this.indenter.endDTD();
        }
    }

    @Override
    public void endDocument() throws Exception {
        this.indenter.endDocument();
        this.encoder.flush();
        if (this.bMustCloseOnEnd) {
            this.encoder.close();
        }
    }

    protected void characters(char[] ch, int start, int length) throws Exception {
        if (!this.firstElementReached) {
            this.firstElementReached = true;
            this.startDocument_internal("");
        }
        this.indenter.characters(ch, start, length);
    }

    private void comment(char[] ch, int start, int length) throws Exception {
        if (!this.firstElementReached) {
            this.firstElementReached = true;
            this.startDocument_internal("");
        }
        this.indenter.comment(ch, start, length);
    }

    public void startDTD(String name, String publicId, String systemId) throws Exception {
        this.method.startDTD(name, publicId, systemId);
    }

    @Override
    public void endDTD() throws Exception {
        this.method.endDTD();
    }

    @Override
    public void onXMLDecl(String version, String encoding, String ssdecl) {
    }

    @Override
    public void startElementStart(CharArray uri, CharArray localName, CharArray qName) throws Exception {
        if (!this.firstElementReached) {
            this.firstElementReached = true;
            this.startDocument_internal(qName.getString());
        }
        this.indenter.startElement0(uri, localName, qName);
    }

    @Override
    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        this.indenter.attribute(uri, localName, qname, value);
    }

    @Override
    public void startElementEnd(boolean b) throws Exception {
        this.indenter.startElement1(b);
    }

    @Override
    public void endElement(CharArray uri, CharArray localName, CharArray qName, boolean b) throws Exception {
        this.indenter.endElement(uri, localName, qName, b);
    }

    @Override
    public void charData(CharArray carr, boolean disableOutputEscaping) throws Exception {
        this.characters(carr.getData(), carr.getOffset(), carr.length());
    }

    @Override
    public void onPI(CharArray target, CharArray data) throws Exception {
        if (!this.firstElementReached) {
            this.firstElementReached = true;
            this.startDocument_internal("");
        }
        if (target.equals("javax.xml.transform.disable-output-escaping")) {
            this.encoder.disableOutputEscaping();
            return;
        }
        if (target.equals("javax.xml.transform.enable-output-escaping")) {
            this.encoder.enableOutputEscaping();
            return;
        }
        this.indenter.processingInstruction(target, data);
    }

    @Override
    public void onComment(CharArray text) throws Exception {
        this.comment(text.getData(), text.getOffset(), text.length());
    }

    @Override
    public void onCDSect(CharArray text) throws Exception {
        this.indenter.startCDATA();
        this.encoder.disableOutputEscaping();
        this.indenter.characters(text.getData(), text.getOffset(), text.length());
        this.encoder.enableOutputEscaping();
        this.indenter.endCDATA();
    }

    @Override
    public void onDTDEntity(Entity entity) throws Exception {
        this.method.onDTDEntity(entity);
    }

    @Override
    public void startDTD(CharArray name, CharArray pub, CharArray sys) throws Exception {
        this.method.startDTD(name.toString(), pub.toString(), sys.toString());
    }

    public void setOption(String name, boolean value) throws OutputException {
        if (name == null) {
            throw new OutputIllegalOptionException("The name of the option is null.");
        }
        if (!Options.ALLOWED.contains(name)) {
            throw new OutputIllegalOptionException("Option '" + name + "' not recognized");
        }
        if (value) {
            this.options.add(name);
        } else {
            this.options.remove(name);
        }
    }

    public boolean getOption(String name) throws OutputException {
        if (name == null) {
            throw new OutputIllegalOptionException("The name of the option is null.");
        }
        if (!Options.ALLOWED.contains(name)) {
            throw new OutputIllegalOptionException("Option '" + name + "' not recognized");
        }
        return this.options.contains(name);
    }

    Encoder getEncoder() {
        return this.encoder;
    }

    Indenter getIndenter() {
        return this.indenter;
    }

    Method getMethod() {
        return this.method;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    HashSet getCDataSectionElements() {
        return this.cDataSectionElements;
    }

    public void setCloseOnEnd(boolean value) {
        this.bMustCloseOnEnd = value;
    }

    @Override
    public void onStartContentEntity(CharArray name, boolean isExpandingReferences) throws OutputException {
        this.escapingSaver = this.encoder.isEscapingEnabled();
        this.encoder.disableOutputEscaping();
        this.indenter.startContentReference(name);
    }

    @Override
    public void onEndContentEntity(CharArray name) throws OutputException {
        this.indenter.endContentReference(name);
        this.encoder.setEscaping(this.escapingSaver);
    }

    @Override
    public void onCustomEvent(int eventId, Object obj) throws Exception {
        BinaryTextImpl text;
        byte[] b;
        if (eventId == 3411 && (b = (text = (BinaryTextImpl)obj).getBinaryData()) != null) {
            int i = 0;
            while (i < b.length) {
                this.encoder.out((char)b[i]);
                ++i;
            }
        }
    }
}

