/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.output;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xslt.output.Indenter;
import com.sap.engine.lib.xsl.xslt.output.Method;
import com.sap.engine.lib.xsl.xslt.output.MethodHTML;
import com.sap.engine.lib.xsl.xslt.output.MethodXML;
import com.sap.engine.lib.xsl.xslt.output.OutputException;

final class IndenterImpl1
extends Indenter {
    private static final boolean SPLIT_LONG_LINES = false;
    private static final int INDENT_STEP = 2;
    private static final int INDENT_INITIAL = 0;
    private int indent;
    private static final int MAX_LENGTH_OF_LINE = Integer.MAX_VALUE;
    private int last = 0;
    private static final int LAST_TEXT = 0;
    private static final int LAST_MARKUP = 1;
    private CharArray buffer = new CharArray();
    private boolean isInCDATA;
    private boolean isInContentReference;
    private boolean allowUnindentedClosingTag = false;
    private boolean lastTagWasOpening = false;
    private boolean hadFirstElement = false;

    IndenterImpl1() {
    }

    @Override
    void startDocument(String omit, String version, String encoding, String isStandalone) throws OutputException {
        this.indent = 0;
        this.indent = 0;
        this.last = 1;
        this.owner.getMethod().startDocument(omit, version, encoding, isStandalone);
        this.isInCDATA = false;
        this.isInContentReference = false;
        this.hadFirstElement = false;
        this.buffer.clear();
    }

    @Override
    void startElement0(CharArray uri, CharArray localName, CharArray qName) throws OutputException {
        this.emptyBuffer();
        if (this.hadFirstElement) {
            this.markupStarts();
        } else {
            this.markupStartsFirstEl();
            this.hadFirstElement = true;
        }
        this.owner.getMethod().startElement0(uri, localName, qName);
    }

    @Override
    void attribute(CharArray uri, CharArray localName, CharArray qName, CharArray value) throws OutputException {
        this.owner.getMethod().attribute(uri, localName, qName, value);
    }

    @Override
    void startElement1(boolean isEmpty) throws OutputException {
        this.owner.getMethod().startElement1(isEmpty);
        this.indent += 2;
        this.lastTagWasOpening = true;
    }

    @Override
    void endElement(CharArray uri, CharArray localName, CharArray qName, boolean isEmpty) throws OutputException {
        this.allowUnindentedClosingTag = true;
        this.emptyBuffer();
        this.indent -= 2;
        boolean bl = this.allowUnindentedClosingTag = this.allowUnindentedClosingTag && this.lastTagWasOpening;
        if (!this.allowUnindentedClosingTag && !isEmpty) {
            this.markupStarts();
        }
        this.allowUnindentedClosingTag = false;
        this.owner.getMethod().endElement(uri, localName, qName, isEmpty);
        this.lastTagWasOpening = false;
    }

    @Override
    void characters(char[] ch, int start, int length) throws OutputException {
        if (this.isInContentReference) {
            return;
        }
        if (this.encoder.isEscapingEnabled()) {
            Method method = this.owner.getMethod();
            if (method instanceof MethodXML) {
                this.buffer.appendEscapedNo13(ch, start, length);
            } else if (method instanceof MethodHTML && ((MethodHTML)method).isInScriptSection == 0) {
                this.buffer.appendBasicEscaped(ch, start, length);
            } else {
                this.buffer.append(ch, start, length);
            }
        } else {
            this.buffer.append(ch, start, length);
        }
    }

    @Override
    void processingInstruction(CharArray target, CharArray data) throws OutputException {
        this.emptyBuffer();
        this.specialMarkupStarts();
        this.owner.getMethod().processingInstruction(target, data);
    }

    @Override
    void comment(char[] ch, int start, int length) throws OutputException {
        this.emptyBuffer();
        this.markupStarts();
        this.owner.getMethod().comment(ch, start, length);
    }

    @Override
    void endDocument() throws OutputException {
        this.emptyBuffer();
        this.owner.getMethod().endDocument();
        this.encoder.outln();
    }

    @Override
    void startDTD(String name, String publicId, String systemId) throws OutputException {
        this.emptyBuffer();
        this.markupStarts();
        this.owner.getMethod().startDTD(name, publicId, systemId);
        this.indent += 2;
    }

    @Override
    void endDTD() throws OutputException {
        this.emptyBuffer();
        this.markupStarts();
        this.owner.getMethod().endDTD();
        this.indent -= 2;
    }

    @Override
    void startCDATA() throws OutputException {
        this.emptyBuffer();
        this.owner.getMethod().startCDATA();
        this.isInCDATA = true;
    }

    @Override
    void endCDATA() throws OutputException {
        this.emptyBuffer();
        this.owner.getMethod().endCDATA();
        this.isInCDATA = false;
    }

    protected void markupStarts() throws OutputException {
        this.emptyBuffer();
        this.encoder.outln();
        this.encoder.outSpace(this.indent);
        this.last = 1;
        this.allowUnindentedClosingTag = false;
    }

    protected void markupStartsFirstEl() throws OutputException {
        this.emptyBuffer();
        this.last = 1;
        this.allowUnindentedClosingTag = false;
    }

    private void specialMarkupStarts() throws OutputException {
        this.emptyBuffer();
        int indentSave = this.indent;
        this.indent = 0;
        this.markupStarts();
        this.indent = indentSave;
    }

    private void emptyBuffer() throws OutputException {
        this.buffer.trimNo13();
        int lBuffer = this.buffer.length();
        if (lBuffer == 0) {
            this.allowUnindentedClosingTag = false;
            return;
        }
        boolean escapingSaver = this.encoder.isEscapingEnabled();
        this.encoder.setEscaping(false);
        int l = Integer.MAX_VALUE - this.indent;
        if (lBuffer < l && this.allowUnindentedClosingTag) {
            this.owner.getMethod().characters(this.buffer.getData(), this.buffer.getOffset(), this.buffer.length());
            this.allowUnindentedClosingTag = true;
        } else {
            this.encoder.outln();
            this.encoder.outSpace(this.indent);
            this.owner.getMethod().characters(this.buffer.getData(), this.buffer.getOffset(), this.buffer.length());
            this.allowUnindentedClosingTag = false;
        }
        this.buffer.clear();
        this.encoder.setEscaping(escapingSaver);
    }

    @Override
    void startContentReference(CharArray name) throws OutputException {
        this.emptyBuffer();
        this.encoder.out("&");
        this.encoder.out(name);
        this.encoder.out(";");
        this.isInContentReference = true;
    }

    @Override
    void endContentReference(CharArray name) throws OutputException {
        this.isInContentReference = false;
    }
}

