/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.output;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xsl.xslt.output.Method;
import com.sap.engine.lib.xsl.xslt.output.OutputException;
import com.sap.engine.lib.xsl.xslt.output.Tools;
import java.util.HashSet;
import java.util.Locale;

final class MethodHTML
extends Method {
    public static HashSet HTML_TAGS = new HashSet(128);
    public static HashSet HTML_EMPTYTAGS = new HashSet(16);
    public static HashSet HTML_SCRIPTTAGS = new HashSet(4);
    public static HashSet HTML_BOOLEANATTR = new HashSet(16);
    public static HashSet HTML_URIATTR = new HashSet(16);
    private boolean isInCDATASection;
    protected int isInScriptSection = 0;
    private boolean isHTMLTag;
    private String encoding;
    private boolean isHeadTag;
    private HashSet cDataSectionElements;
    private CharArray lastUri = null;
    private boolean bMustBeEmpty = false;
    protected static boolean staticInit = false;
    private boolean hasDTDEntity;
    private CharArray caSe0 = new CharArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MethodHTML() {
        Class<MethodHTML> clazz = MethodHTML.class;
        synchronized (MethodHTML.class) {
            if (!staticInit) {
                staticInit = true;
                HTML_EMPTYTAGS.add(new CharArray("AREA"));
                HTML_EMPTYTAGS.add(new CharArray("BASE"));
                HTML_EMPTYTAGS.add(new CharArray("BASEFONT"));
                HTML_EMPTYTAGS.add(new CharArray("BR"));
                HTML_EMPTYTAGS.add(new CharArray("COL"));
                HTML_EMPTYTAGS.add(new CharArray("FRAME"));
                HTML_EMPTYTAGS.add(new CharArray("HR"));
                HTML_EMPTYTAGS.add(new CharArray("IMG"));
                HTML_EMPTYTAGS.add(new CharArray("INPUT"));
                HTML_EMPTYTAGS.add(new CharArray("ISINDEX"));
                HTML_EMPTYTAGS.add(new CharArray("LINK"));
                HTML_EMPTYTAGS.add(new CharArray("META"));
                HTML_EMPTYTAGS.add(new CharArray("PARAM"));
                HTML_SCRIPTTAGS.add(new CharArray("SCRIPT"));
                HTML_SCRIPTTAGS.add(new CharArray("STYLE"));
                HTML_BOOLEANATTR.add(new CharArray("CHECKED"));
                HTML_BOOLEANATTR.add(new CharArray("COMPACT"));
                HTML_BOOLEANATTR.add(new CharArray("DECLARE"));
                HTML_BOOLEANATTR.add(new CharArray("DEFER"));
                HTML_BOOLEANATTR.add(new CharArray("DISABLED"));
                HTML_BOOLEANATTR.add(new CharArray("ISMAP"));
                HTML_BOOLEANATTR.add(new CharArray("MULTIPLE"));
                HTML_BOOLEANATTR.add(new CharArray("NOHREF"));
                HTML_BOOLEANATTR.add(new CharArray("NORESIZE"));
                HTML_BOOLEANATTR.add(new CharArray("NOSHADE"));
                HTML_BOOLEANATTR.add(new CharArray("NOWRAP"));
                HTML_BOOLEANATTR.add(new CharArray("READONLY"));
                HTML_BOOLEANATTR.add(new CharArray("SELECTED"));
                HTML_URIATTR.add(new CharArray("ACTION"));
                HTML_URIATTR.add(new CharArray("BACKGROUND"));
                HTML_URIATTR.add(new CharArray("CITE"));
                HTML_URIATTR.add(new CharArray("CLASSID"));
                HTML_URIATTR.add(new CharArray("CODEBASE"));
                HTML_URIATTR.add(new CharArray("DATA"));
                HTML_URIATTR.add(new CharArray("HREF"));
                HTML_URIATTR.add(new CharArray("LONGDESC"));
                HTML_URIATTR.add(new CharArray("PROFILE"));
                HTML_URIATTR.add(new CharArray("SRC"));
                HTML_URIATTR.add(new CharArray("USEMAP"));
                HTML_TAGS.add(new CharArray("!DOCTYPE"));
                HTML_TAGS.add(new CharArray("A"));
                HTML_TAGS.add(new CharArray("ABBR"));
                HTML_TAGS.add(new CharArray("ACRONYM"));
                HTML_TAGS.add(new CharArray("ADDRESS"));
                HTML_TAGS.add(new CharArray("APPLET"));
                HTML_TAGS.add(new CharArray("AREA"));
                HTML_TAGS.add(new CharArray("B"));
                HTML_TAGS.add(new CharArray("BASE"));
                HTML_TAGS.add(new CharArray("BASEFONT"));
                HTML_TAGS.add(new CharArray("BGSOUND"));
                HTML_TAGS.add(new CharArray("BDO"));
                HTML_TAGS.add(new CharArray("BIG"));
                HTML_TAGS.add(new CharArray("BLINK"));
                HTML_TAGS.add(new CharArray("BLOCKQUOTE"));
                HTML_TAGS.add(new CharArray("BODY"));
                HTML_TAGS.add(new CharArray("BR"));
                HTML_TAGS.add(new CharArray("BUTTON"));
                HTML_TAGS.add(new CharArray("CAPTION"));
                HTML_TAGS.add(new CharArray("CENTER"));
                HTML_TAGS.add(new CharArray("CITE"));
                HTML_TAGS.add(new CharArray("CODE"));
                HTML_TAGS.add(new CharArray("COL"));
                HTML_TAGS.add(new CharArray("COLGROUP"));
                HTML_TAGS.add(new CharArray("COMMENT"));
                HTML_TAGS.add(new CharArray("DD"));
                HTML_TAGS.add(new CharArray("DEL"));
                HTML_TAGS.add(new CharArray("DFN"));
                HTML_TAGS.add(new CharArray("DIR"));
                HTML_TAGS.add(new CharArray("DIV"));
                HTML_TAGS.add(new CharArray("DL"));
                HTML_TAGS.add(new CharArray("DT"));
                HTML_TAGS.add(new CharArray("EM"));
                HTML_TAGS.add(new CharArray("EMBED"));
                HTML_TAGS.add(new CharArray("FIELDSET"));
                HTML_TAGS.add(new CharArray("FONT"));
                HTML_TAGS.add(new CharArray("FORM"));
                HTML_TAGS.add(new CharArray("FRAME"));
                HTML_TAGS.add(new CharArray("FRAMESET"));
                HTML_TAGS.add(new CharArray("H"));
                HTML_TAGS.add(new CharArray("H1"));
                HTML_TAGS.add(new CharArray("H2"));
                HTML_TAGS.add(new CharArray("H3"));
                HTML_TAGS.add(new CharArray("H4"));
                HTML_TAGS.add(new CharArray("H5"));
                HTML_TAGS.add(new CharArray("H6"));
                HTML_TAGS.add(new CharArray("HEAD"));
                HTML_TAGS.add(new CharArray("HR"));
                HTML_TAGS.add(new CharArray("HTML"));
                HTML_TAGS.add(new CharArray("I"));
                HTML_TAGS.add(new CharArray("IFRAME"));
                HTML_TAGS.add(new CharArray("IMG"));
                HTML_TAGS.add(new CharArray("INPUT"));
                HTML_TAGS.add(new CharArray("INS"));
                HTML_TAGS.add(new CharArray("ISINDEX"));
                HTML_TAGS.add(new CharArray("KBD"));
                HTML_TAGS.add(new CharArray("LABEL"));
                HTML_TAGS.add(new CharArray("LEGEND"));
                HTML_TAGS.add(new CharArray("LI"));
                HTML_TAGS.add(new CharArray("LINK"));
                HTML_TAGS.add(new CharArray("LISTING"));
                HTML_TAGS.add(new CharArray("MAP"));
                HTML_TAGS.add(new CharArray("MARQUEE"));
                HTML_TAGS.add(new CharArray("MENU"));
                HTML_TAGS.add(new CharArray("META"));
                HTML_TAGS.add(new CharArray("MULTICOL"));
                HTML_TAGS.add(new CharArray("NEXTID"));
                HTML_TAGS.add(new CharArray("NOBR"));
                HTML_TAGS.add(new CharArray("NOFRAMES"));
                HTML_TAGS.add(new CharArray("NOSCRIPT"));
                HTML_TAGS.add(new CharArray("OBJECT"));
                HTML_TAGS.add(new CharArray("OL"));
                HTML_TAGS.add(new CharArray("OPTGROUP"));
                HTML_TAGS.add(new CharArray("OPTION"));
                HTML_TAGS.add(new CharArray("P"));
                HTML_TAGS.add(new CharArray("PARAM"));
                HTML_TAGS.add(new CharArray("PLAINTEXT"));
                HTML_TAGS.add(new CharArray("PRE"));
                HTML_TAGS.add(new CharArray("Q"));
                HTML_TAGS.add(new CharArray("S"));
                HTML_TAGS.add(new CharArray("SAMP"));
                HTML_TAGS.add(new CharArray("SCRIPT"));
                HTML_TAGS.add(new CharArray("SELECT"));
                HTML_TAGS.add(new CharArray("SERVER"));
                HTML_TAGS.add(new CharArray("SMALL"));
                HTML_TAGS.add(new CharArray("SOUND"));
                HTML_TAGS.add(new CharArray("SPACER"));
                HTML_TAGS.add(new CharArray("SPAN"));
                HTML_TAGS.add(new CharArray("STRIKE"));
                HTML_TAGS.add(new CharArray("STRONG"));
                HTML_TAGS.add(new CharArray("STYLE"));
                HTML_TAGS.add(new CharArray("SUB"));
                HTML_TAGS.add(new CharArray("SUP"));
                HTML_TAGS.add(new CharArray("TABLE"));
                HTML_TAGS.add(new CharArray("TBODY"));
                HTML_TAGS.add(new CharArray("TD"));
                HTML_TAGS.add(new CharArray("TEXTAREA"));
                HTML_TAGS.add(new CharArray("TEXTFLOW"));
                HTML_TAGS.add(new CharArray("TFOOT"));
                HTML_TAGS.add(new CharArray("TH"));
                HTML_TAGS.add(new CharArray("THEAD"));
                HTML_TAGS.add(new CharArray("TITLE"));
                HTML_TAGS.add(new CharArray("TR"));
                HTML_TAGS.add(new CharArray("TT"));
                HTML_TAGS.add(new CharArray("U"));
                HTML_TAGS.add(new CharArray("UL"));
                HTML_TAGS.add(new CharArray("VAR"));
                HTML_TAGS.add(new CharArray("WBR"));
                HTML_TAGS.add(new CharArray("XMP"));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    void startDocument(String omit, String version, String encoding, String isStandalone) throws OutputException {
        this.encoding = encoding.toLowerCase(Locale.ENGLISH);
        this.isInCDATASection = false;
        this.cDataSectionElements = this.owner.getCDataSectionElements();
    }

    @Override
    void endDocument() throws OutputException {
    }

    @Override
    void startElement0(CharArray uri, CharArray localName, CharArray qName) throws OutputException {
        this.lastUri = uri;
        if (!Tools.notEmpty(uri) && HTML_TAGS.contains(qName.toUpperCase(this.caSe0))) {
            this.isHTMLTag = true;
            this.encoder.out('<');
            this.encoder.out(qName);
            if (this.cDataSectionElements.contains(qName.toUpperCase(this.caSe0))) {
                this.isInCDATASection = true;
            }
            if (HTML_SCRIPTTAGS.contains(qName.toUpperCase(this.caSe0))) {
                ++this.isInScriptSection;
            }
            this.isHeadTag = qName.equalsIgnoreCase("HEAD");
        } else {
            this.isHTMLTag = false;
            this.encoder.out('<');
            this.encoder.out(qName);
            if (this.cDataSectionElements.contains(qName.toUpperCase(this.caSe0))) {
                this.isInCDATASection = true;
            }
        }
        this.bMustBeEmpty = !Tools.notEmpty(this.lastUri) && HTML_EMPTYTAGS.contains(qName.toUpperCase(this.caSe0));
    }

    @Override
    void attribute(CharArray uri, CharArray localName, CharArray qName, CharArray value) throws OutputException {
        boolean hasDoubleQuotes;
        boolean bl = hasDoubleQuotes = value.indexOf('\"') != -1;
        if (!this.isHTMLTag) {
            this.encoder.out(' ');
            this.encoder.out(qName);
            this.encoder.out("=");
            this.encoder.out(hasDoubleQuotes ? (char)'\'' : '\"');
            this.encoder.outEscaped(value);
            this.encoder.out(hasDoubleQuotes ? (char)'\'' : '\"');
        } else {
            this.encoder.out(' ');
            this.encoder.out(qName);
            boolean htmlbooleanattr = HTML_BOOLEANATTR.contains(qName.toUpperCase(this.caSe0));
            boolean uriattr = HTML_URIATTR.contains(qName.toUpperCase(this.caSe0));
            if (!htmlbooleanattr) {
                this.encoder.out("=");
                char delimiter = hasDoubleQuotes ? (char)'\'' : '\"';
                this.encoder.out(delimiter);
                this.encoder.outHTMLAttribute(value, uriattr, delimiter);
                this.encoder.out(delimiter);
            }
        }
    }

    @Override
    void startElement1(boolean isEmpty) throws OutputException {
        this.encoder.out('>');
        if (this.isHTMLTag && this.isHeadTag) {
            if (!Tools.notEmpty(this.encoding)) {
                this.encoding = "utf-8";
            }
            this.encoder.out("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
            this.encoder.out(this.encoding);
            this.encoder.out("\">");
        }
    }

    @Override
    void endElement(CharArray uri, CharArray localName, CharArray qName, boolean isEmpty) throws OutputException {
        if (this.isHeadTag) {
            this.encoder.out("</").out(qName).out(">");
        } else if (isEmpty) {
            if (!this.bMustBeEmpty) {
                this.encoder.out("</").out(qName).out(">");
            }
        } else {
            if (!Tools.notEmpty(uri) && HTML_EMPTYTAGS.contains(qName.toUpperCase(this.caSe0))) {
                return;
            }
            this.encoder.out("</");
            this.encoder.out(qName);
            this.encoder.out('>');
        }
        if (this.cDataSectionElements.contains(qName.toUpperCase(this.caSe0))) {
            this.isInCDATASection = false;
        }
        if (!Tools.notEmpty(uri) && HTML_SCRIPTTAGS.contains(qName.toUpperCase(this.caSe0))) {
            --this.isInScriptSection;
        }
    }

    @Override
    void startCDATA() throws OutputException {
        this.isInCDATASection = true;
    }

    @Override
    void processingInstruction(CharArray target, CharArray data) throws OutputException {
        this.encoder.out("<?");
        this.encoder.out(target);
        this.encoder.out(' ');
        this.encoder.out(data);
        this.encoder.out(">");
    }

    @Override
    void endCDATA() throws OutputException {
        this.isInCDATASection = false;
    }

    @Override
    void startDTD(String name, String publicId, String systemId) throws OutputException {
        this.encoder.out("<!DOCTYPE ").out(name);
        if (Tools.notEmpty(publicId)) {
            this.encoder.out(" PUBLIC '").out(publicId).out('\'');
            if (Tools.notEmpty(systemId)) {
                this.encoder.out(" '").out(systemId).out('\'');
            }
        } else if (Tools.notEmpty(systemId)) {
            this.encoder.out(" SYSTEM '").out(systemId).out('\'');
        }
        this.hasDTDEntity = false;
    }

    @Override
    void endDTD() throws OutputException {
        if (this.hasDTDEntity) {
            this.encoder.out("]>").outln();
        } else {
            this.encoder.out(">").outln();
        }
    }

    @Override
    void characters(char[] ch, int start, int length) throws OutputException {
        if (this.isInCDATASection) {
            this.encoder.outCDATA(ch, start, length);
        } else if (this.isInScriptSection != 0) {
            this.encoder.out(ch, start, length);
        } else {
            this.encoder.outEscaped(ch, start, length);
        }
    }

    @Override
    void comment(char[] ch, int start, int length) throws OutputException {
        this.encoder.out("<!--").out(ch, start, length).out("-->").flush();
    }

    @Override
    void onDTDEntity(Entity ent) throws OutputException {
        if (!this.hasDTDEntity) {
            this.encoder.out(" [\n");
            this.hasDTDEntity = true;
        }
        this.encoder.out("<!ENTITY ").out(ent.getName());
        if (ent.isInternal()) {
            try {
                this.encoder.out(" \"").out(ent.getValue()).out("\">\n");
            }
            catch (Exception exception) {}
        } else {
            if (ent.getPub().length() > 0) {
                this.encoder.out(" PUBLIC '").out(ent.getPub()).out("' '").out(ent.getSys()).out('\'');
            } else if (ent.getSys().length() > 0) {
                this.encoder.out(" SYSTEM '").out(ent.getSys()).out('\'');
            }
            this.encoder.out(">\n");
        }
    }
}

