/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.pool;

public final class ObjectPool {
    private static final int MAX_SIZE = 1000;
    private int initialSize;
    private int resizeStep = 100;
    private int pos;
    private Object[] arrayOfObjects;
    private Class objectClass;

    public int getPos() {
        return this.pos;
    }

    public void releasePool() {
        this.pos = this.arrayOfObjects.length - 1;
    }

    public ObjectPool(Class objectClass, int initSize, int step) {
        if (initSize > 1000) {
            initSize = 1000;
        }
        if (step < 1 || initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initialSize or resizeStep parameter");
        }
        this.initialSize = initSize;
        this.resizeStep = step;
        this.arrayOfObjects = new Object[this.initialSize];
        this.objectClass = objectClass;
        int i = 0;
        while (i < this.initialSize) {
            this.arrayOfObjects[i] = null;
            ++i;
        }
        this.pos = this.initialSize - 1;
    }

    public Object getObject() {
        if (this.pos < 0) {
            if (this.arrayOfObjects.length >= 1000) {
                try {
                    return this.objectClass.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            this.autoResize();
        }
        if (this.arrayOfObjects[this.pos] == null) {
            try {
                this.arrayOfObjects[this.pos] = this.objectClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.arrayOfObjects[this.pos--];
    }

    public void releaseObject(Object obj) {
        if (this.pos < this.arrayOfObjects.length - 1) {
            ++this.pos;
            this.arrayOfObjects[this.pos] = obj;
        }
    }

    public void setResizeStep(int step) {
        if (step < 1) {
            throw new IllegalArgumentException("Wrong value of resizeStep parameter");
        }
        this.resizeStep = step;
    }

    public int getResizeStep() {
        return this.resizeStep;
    }

    public void setInitialSize(int initSize) {
        if (initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initSize parameter");
        }
        this.initialSize = initSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void release() {
        int i = 0;
        while (i < this.pos) {
            this.arrayOfObjects[i] = null;
            ++i;
        }
    }

    public void forceShrink() {
        int usedElements = this.arrayOfObjects.length - this.pos - 1;
        if (usedElements >= this.initialSize) {
            if (this.pos >= 0) {
                this.arrayOfObjects = new Object[usedElements];
                this.pos = -1;
            }
        } else if (this.arrayOfObjects.length != this.initialSize) {
            Object[] tempArr = new Object[this.initialSize];
            int newPos = this.initialSize - usedElements - 1;
            if (newPos <= this.pos) {
                System.arraycopy(this.arrayOfObjects, 0, tempArr, 0, newPos + 1);
            } else {
                if (this.pos >= 0) {
                    System.arraycopy(this.arrayOfObjects, 0, tempArr, 0, this.pos + 1);
                }
                int i = this.pos + 1;
                while (i < newPos) {
                    tempArr[i] = new Object();
                    ++i;
                }
            }
            this.arrayOfObjects = tempArr;
            this.pos = newPos;
        }
    }

    private void autoResize() {
        Object[] tempArr = new Object[this.arrayOfObjects.length + this.resizeStep];
        int i = 0;
        while (i < this.arrayOfObjects.length) {
            tempArr[i + this.resizeStep] = this.arrayOfObjects[i];
            ++i;
        }
        this.arrayOfObjects = tempArr;
        this.pos = this.resizeStep - 1;
        this.resizeStep *= 2;
    }

    public void forceResize(int newsize) {
        Object[] tempArr = new Object[newsize];
        int count = this.arrayOfObjects.length - this.pos - 1;
        int tindex = newsize - count;
        int i = 0;
        while (i < count) {
            tempArr[tindex + i] = this.arrayOfObjects[i];
            ++i;
        }
        this.arrayOfObjects = tempArr;
        this.pos = newsize - count - 1;
    }

    public void check() throws Exception {
        int i = 0;
        while (i < this.arrayOfObjects.length) {
            int j = i + 1;
            while (j < this.arrayOfObjects.length) {
                if (this.arrayOfObjects[i] == this.arrayOfObjects[j]) {
                    throw new Exception("they are equal:" + i + "," + j + " " + this.arrayOfObjects[i] + ", " + this.arrayOfObjects[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public void releaseAllObjects() {
        this.pos = this.arrayOfObjects.length - 1;
    }

    public int getUsed() {
        return this.arrayOfObjects.length - this.pos + 1;
    }

    public int getSize() {
        return this.arrayOfObjects.length;
    }

    public Object[] getPool() {
        return this.arrayOfObjects;
    }

    public void setPos(int v) {
        this.pos = v;
    }
}

