/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.commons.exception;

import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class ExceptionReceiver {
    private String exceptionType;
    private String message;

    public ExceptionReceiver() {
    }

    public ExceptionReceiver(CertManagerException e) {
        this.exceptionType = e.getClass().getCanonicalName();
        this.message = e.getMessage();
    }

    public void receiveException() {
        CertManagerException certManagerException = new CertManagerException("Failed to deserialize actual exception!");
        try {
            Class<?> exceptionClass = Class.forName(this.exceptionType);
            certManagerException = (CertManagerException)exceptionClass.newInstance();
            certManagerException.setMessage(this.message);
        }
        catch (Exception e) {
            throw new CertManagerException("Error occured while handling error!", e);
        }
        throw certManagerException;
    }

    @XmlElement
    public String getExceptionType() {
        return this.exceptionType;
    }

    @XmlElement
    public String getMessage() {
        return this.message;
    }
}

