/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.commons.model;

import com.sap.core.certificate.manager.commons.model.CustomDomainUrlsDTO;
import com.sap.core.certificate.manager.commons.model.SslHost;
import java.util.Date;

public class CustomDomainUrls {
    private static final String TENANT_SEPARATOR = "-";
    private static final String ALIAS_SEPARATOR = "/";
    private static final String DOT = ".";
    private SslHost sslHost;
    private String customUrl;
    private String platformUrl;
    private String tenantAlias;
    private String ipWhiteList;
    private String alias;
    private String userName;
    private boolean disablePlatformUrlForSubscription;
    private Date lastModified;

    public CustomDomainUrls() {
    }

    public CustomDomainUrls(CustomDomainUrlsDTO url) {
        this.sslHost = new SslHost();
        this.sslHost.setDisplayName(url.getSslHostDisplayName());
        this.customUrl = url.getCustomUrl();
        this.platformUrl = url.getPlatformUrl();
        this.tenantAlias = url.getTenantAlias();
        this.ipWhiteList = url.getIpWhiteList();
        this.userName = url.getUserName();
        this.disablePlatformUrlForSubscription = url.isDisablePlatformUrlForSubscription();
        this.initTenantAndAliasFromPlatformUrl();
    }

    public void initTenantAndAliasFromPlatformUrl() {
        if (this.platformUrl != null) {
            int firstDotIndex;
            int tenantSeparatorIndex;
            if (this.platformUrl.contains(TENANT_SEPARATOR) && (tenantSeparatorIndex = this.platformUrl.indexOf(TENANT_SEPARATOR)) < (firstDotIndex = this.platformUrl.indexOf(DOT))) {
                this.tenantAlias = this.platformUrl.substring(tenantSeparatorIndex + 1, firstDotIndex);
                this.platformUrl = this.platformUrl.replace(TENANT_SEPARATOR + this.tenantAlias, "");
            }
            if (this.platformUrl.contains(ALIAS_SEPARATOR)) {
                int sep = this.platformUrl.indexOf(ALIAS_SEPARATOR);
                this.setAlias(this.platformUrl.substring(sep));
                this.setPlatformUrl(this.platformUrl.substring(0, sep));
            }
        }
    }

    public SslHost getSslHost() {
        return this.sslHost;
    }

    public void setSslHost(SslHost sslHosts) {
        this.sslHost = sslHosts;
    }

    public String getCustomUrl() {
        return this.customUrl;
    }

    public void setCustomUrl(String customUrl) {
        this.customUrl = customUrl;
    }

    public String getPlatformUrl() {
        return this.platformUrl;
    }

    public void setPlatformUrl(String platformUrl) {
        this.platformUrl = platformUrl;
    }

    public String getTenantAlias() {
        return this.tenantAlias;
    }

    public void setTenantAlias(String tenantAlias) {
        this.tenantAlias = tenantAlias;
    }

    public String getIpWhiteList() {
        return this.ipWhiteList;
    }

    public void setIpWhiteList(String ipWhiteList) {
        this.ipWhiteList = ipWhiteList;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isDisablePlatformUrlForSubscription() {
        return this.disablePlatformUrlForSubscription;
    }

    public void setDisablePlatformUrlForSubscription(boolean disablePlatformUrlForSubscription) {
        this.disablePlatformUrlForSubscription = disablePlatformUrlForSubscription;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String toString() {
        return "CustomDomainUrls{sslHost=" + (this.sslHost == null ? "null" : this.sslHost.getDisplayName()) + ", customUrl='" + this.customUrl + '\'' + ", platformUrl='" + this.platformUrl + '\'' + ", tenantAlias='" + this.tenantAlias + '\'' + ", alias='" + this.alias + '\'' + ", ipWhiteList='" + this.ipWhiteList + '\'' + ", userName='" + this.userName + '\'' + ", disablePlatformUrlForSubscription='" + this.disablePlatformUrlForSubscription + '\'' + ", lastModified=" + this.lastModified + '}';
    }

    public CustomDomainUrlsDTO toDTO() {
        CustomDomainUrlsDTO dto = new CustomDomainUrlsDTO();
        dto.setCustomUrl(this.customUrl);
        dto.setIpWhiteList(this.ipWhiteList);
        dto.setLastModified(this.lastModified.toString());
        dto.setPlatformUrl(this.platformUrl);
        dto.setSslHostDisplayName(this.sslHost == null ? null : this.sslHost.getDisplayName());
        dto.setTenantAlias(this.tenantAlias);
        dto.setUserName(this.userName);
        dto.setDisablePlatformUrlForSubscription(this.disablePlatformUrlForSubscription);
        return dto;
    }
}

