/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.commons.model;

import com.sap.core.certificate.manager.commons.model.AccountDTO;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class ProxyHostMappingDTO {
    public static final String PORT_PATTERN = ":([0-9]+)";
    private static final String DATAGROUP_KEY_SEPARATOR = "#";
    private String guid;
    private String proxy;
    private String applicationHost;
    private String accountName;
    private AccountDTO account;

    public ProxyHostMappingDTO() {
    }

    public ProxyHostMappingDTO(String proxy, String applicationHost) {
        this.proxy = proxy;
        this.applicationHost = applicationHost;
    }

    @XmlElement
    public String getGuid() {
        return this.guid;
    }

    @XmlElement
    public String getProxy() {
        return this.proxy;
    }

    @XmlElement
    public String getApplicationHost() {
        return this.applicationHost;
    }

    @XmlElement
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setApplicationHost(String applicationHost) {
        this.applicationHost = applicationHost;
    }

    public AccountDTO getAccount() {
        return this.account;
    }

    public void setAccount(AccountDTO account) {
        this.account = account;
    }

    public String getLoadBalancerDataGroupKey() {
        return this.applicationHost + DATAGROUP_KEY_SEPARATOR + this.proxy;
    }

    public String getProxyWithoutPort() {
        return null != this.proxy ? this.proxy.replaceAll(PORT_PATTERN, "") : null;
    }
}

