/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.commons.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class UrlUtil {
    public static final String PREFIX_HTTPS = "https://";
    public static final String PREFIX_HTTP = "http://";

    public static boolean isValidCustomDomain(String urlStr) {
        boolean result = false;
        try {
            URL url = new URL(UrlUtil.appendSchemeToUrl(urlStr));
            if (url.getPath() == null || url.getPath().isEmpty()) {
                result = true;
            }
        }
        catch (MalformedURLException e) {
            result = false;
        }
        return result;
    }

    public static String getURLWithHostToLowerCase(String urlStr) {
        try {
            URL url = new URL(UrlUtil.appendSchemeToUrl(urlStr));
            String urlWithHostToLowerCase = url.getHost().toLowerCase(Locale.ENGLISH);
            if (url.getPath() != null) {
                urlWithHostToLowerCase = urlWithHostToLowerCase + url.getPath();
            }
            return urlWithHostToLowerCase;
        }
        catch (MalformedURLException e) {
            return urlStr;
        }
    }

    private static String appendSchemeToUrl(String url) {
        if (!url.startsWith(PREFIX_HTTP) && !url.startsWith(PREFIX_HTTPS)) {
            return PREFIX_HTTPS + url;
        }
        return url;
    }
}

