/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.commons.util;

import com.sap.core.certificate.manager.commons.exception.InvalidCertificateException;
import com.sap.core.certificate.manager.commons.model.CACertificatesDTO;
import com.sap.core.certificate.manager.commons.model.CertificateDTO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class X509CertificatesUtil {
    private static final Logger LOGGER = Logger.getLogger(X509CertificatesUtil.class);

    public List<X509Certificate> getExpiredCertificates(String certPEM) throws UnsupportedEncodingException, CertificateException {
        List<X509Certificate> certs = this.parseCerts(certPEM);
        return this.getExpiredCertificates(certs);
    }

    public List<X509Certificate> parseCertificates(CertificateDTO certificate) {
        try {
            return this.parseCerts(certificate.getPublicKey());
        }
        catch (CertificateException e) {
            throw new InvalidCertificateException(String.format("Certificate [%s] in subaccount [%s] is not parsable!", certificate.getName(), certificate.getAccount()));
        }
    }

    public List<X509Certificate> parseCertificates(CACertificatesDTO certificate) {
        try {
            return this.parseCerts(certificate.getContent());
        }
        catch (CertificateException e) {
            throw new InvalidCertificateException("'content' does not contain valid certificate(s)!");
        }
    }

    public List<X509Certificate> parseCerts(String certPEM) throws CertificateException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (List)cf.generateCertificates(new ByteArrayInputStream(certPEM.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new CertificateException(e);
        }
    }

    public void checkCertificatesValidity(List<X509Certificate> certificates) {
        for (X509Certificate x509Certificate : certificates) {
            this.checkCertificateValidity(x509Certificate);
        }
    }

    private void checkCertificateValidity(X509Certificate certificate) {
        try {
            certificate.checkValidity();
        }
        catch (CertificateException e) {
            LOGGER.error((Object)("Certificate validation error for certificate with subject " + certificate.getSubjectDN().getName()), (Throwable)e);
            throw new InvalidCertificateException(String.format("Certificate with subject [%s] is not valid!", certificate.getSubjectDN().getName()));
        }
    }

    public List<X509Certificate> getExpiredCertificates(List<X509Certificate> certs) {
        ArrayList<X509Certificate> expired = new ArrayList<X509Certificate>();
        for (X509Certificate x509Certificate : certs) {
            try {
                x509Certificate.checkValidity();
            }
            catch (CertificateException e) {
                LOGGER.error((Object)("Certificate validation error for certificate with subject " + x509Certificate.getSubjectDN().getName()), (Throwable)e);
                expired.add(x509Certificate);
            }
        }
        return expired;
    }

    public List<X509Certificate> getCertificatesBySerialNumbers(String clientCertBundleName, List<X509Certificate> certs, List<String> serialNumbers) {
        ArrayList<String> foundSerialNumbers = new ArrayList<String>();
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        for (X509Certificate x509Certificate : certs) {
            String serialNumber = String.valueOf(x509Certificate.getSerialNumber());
            if (!serialNumbers.contains(serialNumber)) continue;
            result.add(x509Certificate);
            foundSerialNumbers.add(serialNumber);
        }
        return result;
    }

    public String getCertificateCommonName(String name) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(name.replace(", ", "\n").getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidCertificateException(e.getMessage());
        }
        Properties dnAttributes = new Properties();
        try {
            dnAttributes.load(is);
        }
        catch (IOException e) {
            throw new InvalidCertificateException(String.format("Invalid DN format: [%s] ", name));
        }
        return dnAttributes.getProperty("CN");
    }
}

