/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.commons.validation;

import com.sap.core.certificate.manager.commons.model.Constants;
import com.sap.core.certificate.manager.commons.model.SslHostDTO;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomDomainsValidationUtil {
    public static boolean isValidSupportedProtocols(SslHostDTO sslHostDTO) {
        String supportedProtocols = sslHostDTO.getSupportedProtocols();
        boolean result = true;
        String[] splitted = supportedProtocols.split(",");
        for (int i = 0; i < splitted.length; ++i) {
            splitted[i] = splitted[i].trim();
            if (CustomDomainsValidationUtil.isValidSupportedProtocol(splitted[i])) continue;
            result = false;
            break;
        }
        if (result) {
            sslHostDTO.setSupportedProtocolsArray(splitted);
        }
        return result;
    }

    public static boolean isValidSupportedProtocol(String protocol) {
        return Constants.SUPPORTED_PROTOCOLS_LIST.contains(protocol);
    }

    public static boolean validateName(String value, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }
}

