/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.commons.validation;

public class ReverseProxyValidationUtil {
    public static final String DOMAIN_NAME_REGEX = "([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{2,}";
    public static final String DOMAIN_NAME_STRICT_REGEX = "^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{2,}$";
    public static final String DOMAIN_NAME_AND_PORT_REGEX = "([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{2,}:[0-9]{2,5}";
    public static final String DOMAIN_NAME_AND_PORT_STRICT_REGEX = "^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{2,}:[0-9]{2,5}$";

    public static boolean validateDomainName(String domainName) {
        if (domainName == null) {
            return true;
        }
        return domainName.matches(DOMAIN_NAME_STRICT_REGEX);
    }

    public static boolean validateDomainAndPortStr(String domainAndPort) {
        if (domainAndPort == null) {
            return true;
        }
        return domainAndPort.matches(DOMAIN_NAME_AND_PORT_STRICT_REGEX);
    }

    public static boolean isValueSpecified(String value) {
        return value != null && !value.trim().isEmpty();
    }
}

