/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.auth.lib.callbackhandler;

import com.sap.core.jpaas.security.auth.lib.callback.AuthnStateCallback;
import com.sap.core.jpaas.security.auth.lib.callback.AuthnStateMessage;
import com.sap.core.jpaas.security.auth.lib.callbackhandler.WebCallbackHandler;
import com.sap.core.jpaas.security.auth.lib.util.Base64Util;
import com.sap.core.jpaas.security.auth.lib.util.PostParametersUtil;
import com.sap.core.jpaas.security.auth.lib.util.RequestUtil;
import com.sap.core.jpaas.security.utils.Base64;
import com.sap.engine.lib.security.http.HttpCallback;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.security.auth.callback.ExtractCookiesCallback;
import com.sap.security.auth.callback.OTPCallback;
import com.sap.security.um.user.PasswordCheckResult;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebCallbackHandler
implements WebCallbackHandler {
    private static final int MAX_FAILED_AUTH_REQUEST_BODY_SIZE_BYTES = 0x200000;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWebCallbackHandler.class);
    private static final String J_USERNAME = "j_username";
    private static final String J_PASSWORD = "j_password";
    private static final String PASSCODE = "passcode";
    protected static final String BASIC = "BASIC";
    private static final String BASIC_LOGOUT_COOKIE = "com.sap.core.jpaas.security.auth.basic.logout";
    private static final String OTP_PAGE = "otp_login.jsp";
    private static final String FAVICON_ICO = "favicon.ico";
    private static final String OTP_PAGE_PATH = "/ide/login/pages/otp_login.jsp";
    private static final String TRUE = "true";
    protected static final String ORIGINAL_URL_COOKIE_NAME = "com.sap.core.jpaas.security.auth.form.original_url";
    protected static final String ANCHOR_COOKIE_NAME = "_anchor";
    protected static final String J_SECURITY_CHECK = "/j_security_check";
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected String authMethod;
    protected String realm;
    private String username = null;
    private String password = null;
    private boolean isAuthzHeaderAlreadyParsed = false;
    protected HttpSetterCallback delayedSetterCallback;
    protected String loginPage;
    protected String errorPage;

    protected AbstractWebCallbackHandler(String realm) {
        this.realm = realm;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        Callback[] callbackArray = callbacks;
        int n = callbacks.length;
        int n2 = 0;
        while (n2 < n) {
            Callback callback = callbackArray[n2];
            if (callback instanceof NameCallback) {
                this.handle((NameCallback)callback);
            } else if (callback instanceof PasswordCallback) {
                this.handle((PasswordCallback)callback);
            } else if (callback instanceof OTPCallback) {
                this.handle((OTPCallback)callback);
            } else if (callback instanceof LanguageCallback) {
                this.handle((LanguageCallback)callback);
            } else if (callback instanceof ExtractCookiesCallback) {
                this.handle((ExtractCookiesCallback)callback);
            } else if (callback instanceof HttpGetterCallback) {
                this.handle((HttpGetterCallback)callback);
            } else if (callback instanceof HttpSetterCallback) {
                HttpSetterCallback setterCallback = (HttpSetterCallback)callback;
                if (setterCallback.getType() == 19 || setterCallback.getType() == 9) {
                    if (this.delayedSetterCallback == null) {
                        this.delayedSetterCallback = setterCallback;
                        LOG.debug(callback + " is set for delayed processing");
                    } else {
                        LOG.debug(callback + " is ignored because there is another callback set for delayed processing: " + this.delayedSetterCallback);
                    }
                } else {
                    this.handle(setterCallback);
                }
            } else if (callback instanceof AuthnStateCallback) {
                this.handle((AuthnStateCallback)callback);
            } else {
                throw new UnsupportedCallbackException(callback);
            }
            ++n2;
        }
    }

    private void handle(LanguageCallback callback) {
        LOG.debug("Entering method handle(LanguageCallback)");
        Locale defaultLocale = Locale.getDefault();
        callback.setLocale(defaultLocale);
        LOG.debug("Exiting method handle(LanguageCallback) with " + defaultLocale);
    }

    protected void handle(ExtractCookiesCallback callback) {
        LOG.debug("Entering method handle(ExtractCookiesCallback)");
        callback.setCookies(this.request.getCookies());
        LOG.debug("Exiting method handle(ExtractCookiesCallback)");
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    @Override
    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    private void enteringHandle(HttpCallback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering method handle() with " + callback);
        }
    }

    private void exitingHandle(HttpCallback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting method handle() with " + callback);
        }
    }

    protected void handle(HttpGetterCallback callback) throws IOException {
        this.enteringHandle(callback);
        String name = callback.getName();
        Object value = callback.getValue();
        switch (callback.getType()) {
            case 1: {
                value = this.request.getHeader(name);
                break;
            }
            case 2: {
                value = RequestUtil.getCookieValue(this.request, name);
                break;
            }
            case 3: {
                value = this.request.getParameterValues(name);
                break;
            }
            case 5: {
                value = this.request.getRemoteAddr();
                break;
            }
            case 6: {
                value = this.request.getMethod();
                break;
            }
            case 7: {
                value = new Boolean(this.request.isSecure());
                break;
            }
            case 9: {
                value = this.request.getInputStream();
                break;
            }
            case 10: {
                HttpSession session = this.request.getSession(false);
                if (session == null) break;
                value = session.getAttribute(name);
                break;
            }
            case 13: {
                value = this.request.getAttribute(name);
                break;
            }
            case 17: {
                value = RequestUtil.getOriginalUrlFromRequest(this.request);
                break;
            }
            case 18: {
                value = PostParametersUtil.preservePostParameters(this.request, this.response);
                break;
            }
            case 27: {
                value = this.request.getServerName();
                break;
            }
            case 4: {
                throw new IllegalArgumentException("Not supported: " + callback);
            }
            default: {
                throw new IllegalArgumentException("Not yet supported: " + callback);
            }
        }
        callback.setValue(value);
        this.exitingHandle(callback);
    }

    protected void handle(HttpSetterCallback callback) throws IOException {
        this.enteringHandle(callback);
        String name = callback.getName();
        Object value = callback.getValue();
        boolean isResponseCommitted = this.response.isCommitted();
        switch (callback.getType()) {
            case 1: {
                if (!isResponseCommitted) {
                    this.response.addHeader(name, (String)value);
                    break;
                }
                LOG.debug("Response is committed");
                break;
            }
            case 13: {
                this.request.setAttribute(name, value);
                break;
            }
            case 2: {
                this.response.addHeader("set-cookie", String.valueOf(name) + "=" + value);
                break;
            }
            case 9: {
                if (this.response.isCommitted()) break;
                if (value instanceof String) {
                    String body = (String)value;
                    this.response.getWriter().print(body);
                    this.commitResponse();
                    break;
                }
                LOG.debug("Response is committed");
                break;
            }
            case 10: {
                this.request.getSession(true).setAttribute(name, value);
                break;
            }
            case 12: {
                this.request.getSession(true).removeAttribute(name);
                break;
            }
            case 19: {
                this.response.sendRedirect((String)value);
                break;
            }
            case 18: {
                PostParametersUtil.restorePostParameters(this.request, this.response);
                break;
            }
            case 26: {
                this.request.getSession(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not yet supported: " + callback);
            }
        }
        this.exitingHandle(callback);
    }

    protected void handle(NameCallback callback) {
        LOG.debug("Entering method handle(NameCallback)");
        if (this.username == null && this.password == null) {
            this.parseUserAndPasswordFromAuthzHeader();
        }
        if (this.username == null) {
            this.username = this.request.getParameter(J_USERNAME);
        }
        if (this.username != null) {
            callback.setName(this.username);
            LOG.debug("User is present in the request: " + this.username);
        } else {
            LOG.debug("User name is not present in the request");
        }
        LOG.debug("Exiting method handle(NameCallback) with " + this.username);
    }

    protected void handle(PasswordCallback callback) {
        LOG.debug("Entering method handle(PasswordCallback)");
        if (this.username == null && this.password == null) {
            this.parseUserAndPasswordFromAuthzHeader();
        }
        if (this.password == null) {
            this.password = this.request.getParameter(J_PASSWORD);
        }
        if (this.password != null) {
            callback.setPassword(this.password.toCharArray());
            LOG.debug("Password is present in the request");
        } else {
            LOG.debug("Password is not present in the request");
        }
        LOG.debug("Exiting method handle(PasswordCallback).");
    }

    protected void handle(OTPCallback callback) {
        LOG.debug("Entering method handle(OTPCallback)");
        String passCode = this.request.getParameter(PASSCODE);
        if (passCode != null) {
            callback.setPasscode(passCode);
            LOG.debug("Passcode is present in the request");
        } else {
            LOG.debug("Passcode is not present in the request");
        }
        LOG.debug("Exiting method handle(OTPCallback).");
    }

    private void parseUserAndPasswordFromAuthzHeader() {
        LOG.debug("Entering method parseUserAndPasswordFromAuthzHeader().");
        if (this.isAuthzHeaderAlreadyParsed) {
            LOG.debug("The Authorization header is already parsed.");
        } else {
            String credentials;
            String decodeCredentials;
            int index;
            String basic;
            StringTokenizer st;
            this.isAuthzHeaderAlreadyParsed = true;
            Cookie basicLogoutCookie = RequestUtil.getCookie(this.request, BASIC_LOGOUT_COOKIE);
            if (basicLogoutCookie != null && TRUE.equals(basicLogoutCookie.getValue())) {
                LOG.debug("A cookie for BASIC logout found in request. User credentials will be ignored.");
                return;
            }
            String authenticationHeader = this.request.getHeader("Authorization");
            if (authenticationHeader != null && (st = new StringTokenizer(authenticationHeader)) != null && st.hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic") && (index = (decodeCredentials = this.decodeBasicAuthHeaderValue(credentials = st.nextToken())).indexOf(":")) != -1) {
                this.username = decodeCredentials.substring(0, index);
                this.password = decodeCredentials.substring(index + 1);
            }
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder("Exiting method parseUserAndPasswordFromAuthzHeader() with user=[" + this.username + "] and password");
            if (this.password == null) {
                debugMessage.append(" (null).");
            } else {
                debugMessage.append(" (length: ").append(this.password.length()).append(").");
            }
            LOG.debug(debugMessage.toString());
        }
    }

    String decodeBasicAuthHeaderValue(String basicAuthBase64) {
        String basicAuthIso88591;
        byte[] basicAuthBytes = Base64.decode((char[])basicAuthBase64.toCharArray());
        String basicAuthUtf8 = new String(basicAuthBytes, Charset.forName("UTF-8"));
        if (basicAuthUtf8.equals(basicAuthIso88591 = new String(basicAuthBytes, Charset.forName("ISO-8859-1")))) {
            return basicAuthUtf8;
        }
        byte[] utfString2utfBytes = basicAuthUtf8.getBytes(Charset.forName("UTF-8"));
        if (!Arrays.equals(basicAuthBytes, utfString2utfBytes)) {
            LOG.debug("Basic Authorization header seems to be in ISO-8859-1 encoded format - re-encoding with UTF-8");
            return basicAuthIso88591;
        }
        return basicAuthUtf8;
    }

    protected String getRequestURLWithQueryString() {
        StringBuffer url = this.request.getRequestURL();
        String queryString = this.request.getQueryString();
        if (queryString != null) {
            url.append('?');
            url.append(queryString);
        }
        return url.toString();
    }

    protected void handle(AuthnStateCallback callback) throws IOException {
        LOG.debug("Entering handle(AuthnStateCallback. {})", (Object)callback);
        switch (callback) {
            case LOGIN_OK: {
                if (!this.shouldRestoreOriginalRequest()) break;
                this.restoreOriginalRequest();
                break;
            }
            case LOGIN_FAILED: {
                if (!this.canSendCredentialsRequest()) break;
                this.askForBasicCredentials();
                break;
            }
            case LOGIN_FAILED_PASSWORD_DISABLED: {
                this.handleLoginFailed(AuthnStateMessage.messages.get(AuthnStateCallback.LOGIN_FAILED_PASSWORD_DISABLED), PasswordCheckResult.PWD_DISABLED);
                break;
            }
            case LOGIN_FAILED_PASSWORD_LOCKED: {
                this.handleLoginFailed(AuthnStateMessage.messages.get(AuthnStateCallback.LOGIN_FAILED_PASSWORD_LOCKED), PasswordCheckResult.PWD_LOCKED);
                break;
            }
            case LOGIN_FAILED_USER_INACTIVE: {
                this.handleLoginFailed(AuthnStateMessage.messages.get(AuthnStateCallback.LOGIN_FAILED_USER_INACTIVE), PasswordCheckResult.USER_INACTIVE);
                break;
            }
            case LOGIN_FAILED_UNKNOWN_REASON: {
                this.handleLoginFailed(AuthnStateMessage.messages.get(AuthnStateCallback.LOGIN_FAILED_UNKNOWN_REASON), PasswordCheckResult.FAILED_UNKNOWN_REASON);
                break;
            }
            case SECOND_FACTOR_EXPECTED: {
                if (this.response.isCommitted()) {
                    LOG.debug("Cannot trigger second factor authentication because the response is commited.");
                    break;
                }
                LOG.debug("Authentication with second factor will be requested.");
                String requestURI = this.request.getRequestURI();
                if (requestURI.endsWith(FAVICON_ICO) || requestURI.endsWith(OTP_PAGE)) break;
                if (!requestURI.endsWith(J_SECURITY_CHECK)) {
                    this.preserveOriginalRequestInSession();
                }
                this.forwardToOTPPage();
                break;
            }
            case LOGOUT_OK: {
                if (!this.shouldSendBasicLogoutCookie()) break;
                if (!this.response.isCommitted()) {
                    Cookie basicLogoutCookie = new Cookie(BASIC_LOGOUT_COOKIE, TRUE);
                    basicLogoutCookie.setHttpOnly(true);
                    basicLogoutCookie.setPath("/");
                    String userAgentHeader = this.request.getHeader("user-agent");
                    if (userAgentHeader != null && userAgentHeader.indexOf("Chrome") == -1) {
                        this.response.addCookie(basicLogoutCookie);
                    }
                    LOG.debug("A cookie for BASIC logout is successfully added.");
                    break;
                }
                LOG.debug("Cannot add cookie for BASIC logout because the response is committed.");
                break;
            }
        }
        this.handleDelayedSetterCallback();
        LOG.debug("Exiting handle(AuthnStateCallback." + callback + ")");
    }

    protected void askForBasicCredentials() throws IOException {
        this.deleteLogoutCookie();
        this.response.setHeader("X-message-code", PasswordCheckResult.PWD_WRONG.name());
        this.response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
        this.response.setStatus(401);
        this.commitResponse();
    }

    protected boolean canSendCredentialsRequest() {
        if (this.response.isCommitted()) {
            LOG.debug("Cannot trigger BASIC authentication because the response is committed.");
            return false;
        }
        if (!this.isAuthzHeaderAlreadyParsed) {
            return false;
        }
        String header = this.response.getHeader("com.sap.cloud.security.login");
        return header == null || !header.equals("login-request") && !header.equals("logout-request");
    }

    protected boolean shouldSendBasicLogoutCookie() {
        String header = this.response.getHeader("com.sap.cloud.security.login");
        return header == null || !header.equals("logout-request");
    }

    private void handleLoginFailed(String errorMsg, PasswordCheckResult passwordCheckResult) throws IOException {
        if (this.canSendCredentialsRequest()) {
            this.deleteLogoutCookie();
            this.response.setHeader("X-message-code", passwordCheckResult.name());
            this.response.sendError(401, String.valueOf(errorMsg) + ".");
            String userAgentHeader = this.request.getHeader("user-agent");
            if (userAgentHeader != null) {
                if (userAgentHeader.indexOf("Chrome") != -1) {
                    this.response.setHeader("WWW-Authenticate", "Basic realm=\"" + errorMsg + "\"");
                } else if (userAgentHeader.indexOf("Firefox") != -1) {
                    this.response.setHeader("WWW-Authenticate", "Basic realm=\"" + errorMsg + ".\"");
                }
            }
            this.commitResponse();
        }
    }

    private void deleteLogoutCookie() {
        Cookie basicLogoutCookie = RequestUtil.getCookie(this.request, BASIC_LOGOUT_COOKIE);
        if (basicLogoutCookie != null) {
            LOG.debug("A cookie for BASIC logout found in request.");
            this.invalidateCookie(basicLogoutCookie);
            this.response.addCookie(basicLogoutCookie);
            LOG.debug("The cookie for BASIC logout is successfully deleted.");
        }
    }

    private void invalidateCookie(Cookie basicLogoutCookie) {
        basicLogoutCookie.setValue("0");
        basicLogoutCookie.setPath("/");
        basicLogoutCookie.setHttpOnly(true);
        basicLogoutCookie.setMaxAge(0);
    }

    protected void handleDelayedSetterCallback() throws IOException {
        if (this.delayedSetterCallback != null && !this.response.isCommitted()) {
            this.handle(this.delayedSetterCallback);
        }
    }

    private void commitResponse() throws IOException {
        this.consumeRequestBeforeCommittingResponse();
        this.response.getWriter().flush();
        this.response.getWriter().close();
        LOG.debug("Response is successfully committed.");
    }

    /*
     * Unable to fully structure code
     */
    private void consumeRequestBeforeCommittingResponse() throws IOException {
        block4: {
            totalCount = 0;
            try {
                is = this.request.getInputStream();
                data = new byte[8192];
                read = 0;
                while ((read = is.read(data)) >= 0) {
                    if ((totalCount += read) <= 0x200000) continue;
                    AbstractWebCallbackHandler.LOG.warn("Request body too big for request with failed authentication");
                    break;
                }
                is.close();
                break block4;
            }
            catch (IllegalStateException v0) {
                reader = this.request.getReader();
                data = new char[8192];
                read = 0;
                ** while ((read = reader.read((char[])data)) >= 0)
            }
lbl-1000:
            // 1 sources

            {
                if ((totalCount += read) <= 0x200000) continue;
                AbstractWebCallbackHandler.LOG.warn("Request body too big for request with failed authentication");
                break;
            }
lbl20:
            // 2 sources

            reader.close();
        }
    }

    @Override
    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    @Override
    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    protected void forwardToOTPPage() throws IOException {
        try {
            Context catalina = ((Request)this.request).getContext();
            LOG.debug("Forward to default login page.");
            catalina.getServletContext().getRequestDispatcher(OTP_PAGE_PATH).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            throw new IOException(e);
        }
    }

    protected boolean shouldRestoreOriginalRequest() {
        return this.request.getRequestURI().endsWith(J_SECURITY_CHECK);
    }

    protected void restoreOriginalRequest() throws UnsupportedEncodingException, IOException {
        String originalUrl = this.constructFullURLFromCookies();
        if (originalUrl != null) {
            this.deleteOriginalURLCookie();
            this.deleteOriginalAnchorCookie();
        } else {
            originalUrl = this.getOriginalURLFromSession();
        }
        if (originalUrl != null) {
            this.response.sendRedirect(originalUrl);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Redirect to original URL: {}", (Object)originalUrl);
            }
        }
    }

    protected String getOriginalURLFromSession() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return (String)session.getAttribute(ORIGINAL_URL_COOKIE_NAME);
        }
        return null;
    }

    private void deleteOriginalURLCookie() {
        Cookie cookie = RequestUtil.getCookie(this.request, ORIGINAL_URL_COOKIE_NAME);
        this.deleteCookie(cookie);
    }

    private void deleteOriginalAnchorCookie() {
        Cookie anchorCookie = RequestUtil.getCookie(this.request, ANCHOR_COOKIE_NAME);
        this.deleteCookie(anchorCookie);
    }

    private void deleteCookie(Cookie cookie) {
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setPath(this.getContextPath());
            cookie.setValue("0");
            this.response.addCookie(cookie);
        }
    }

    protected String constructFullURLFromCookies() {
        Cookie cookie = RequestUtil.getCookie(this.request, ORIGINAL_URL_COOKIE_NAME);
        Cookie anchorCookie = RequestUtil.getCookie(this.request, ANCHOR_COOKIE_NAME);
        if (cookie != null) {
            String originalEncodedUrl = cookie.getValue();
            byte[] decodedBytes = Base64Util.decode((String)originalEncodedUrl);
            String url = new String(decodedBytes, StandardCharsets.UTF_8);
            url = String.valueOf(url) + this.obtainAnchorFromCookie(anchorCookie);
            return url;
        }
        return null;
    }

    private String obtainAnchorFromCookie(Cookie anchorCookie) {
        if (anchorCookie != null) {
            try {
                return URLDecoder.decode(anchorCookie.getValue(), StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Failed to url decode the anchor cooke", (Throwable)e);
            }
        }
        return "";
    }

    private void preserveOriginalRequestInSession() {
        HttpSession session = this.request.getSession();
        session.setAttribute(ORIGINAL_URL_COOKIE_NAME, (Object)this.getRequestURLWithQueryString());
    }

    protected void preserveOriginalRequestInCookie() {
        String originalUrlStr = this.getRequestURLWithQueryString();
        String encodedUrl = Base64Util.encodeString(originalUrlStr);
        Cookie urlCookie = new Cookie(ORIGINAL_URL_COOKIE_NAME, encodedUrl);
        urlCookie.setPath(this.getContextPath());
        this.response.addCookie(urlCookie);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Original request URL [{}] preserved in cookie [{}]", (Object)originalUrlStr, (Object)ORIGINAL_URL_COOKIE_NAME);
        }
    }

    private String getContextPath() {
        String contextPath = this.request.getContextPath();
        if (contextPath.length() == 0) {
            contextPath = "/";
        }
        return contextPath;
    }
}

